/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tags;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.syntax.RegionListVisitor;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.UserProfile;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public abstract class AbstractRegionListTag
extends SimpleTagSupport {
    private boolean mEscapeHTML = true;
    private Integer tabWidth;
    private String mSpace = " ";
    private String mEol = " <br/>";
    private int currentCol = 0;
    private boolean mPrintFirstSpaceAsSpace = false;
    private boolean printLastSpaceAsSpace = false;
    private boolean enableLinks = true;
    private boolean lastWasCR = false;
    private boolean lastWasSpace = false;

    public void setPrintFirstSpaceAsSpace(boolean printFirstSpaceAsSpace) {
        this.mPrintFirstSpaceAsSpace = printFirstSpaceAsSpace;
    }

    public void setPrintLastSpaceAsSpace(boolean printLastSpaceAsSpace) {
        this.printLastSpaceAsSpace = printLastSpaceAsSpace;
    }

    public void setSpace(String space) {
        this.mSpace = space;
    }

    public void setEol(String eol) {
        this.mEol = eol;
    }

    public void setEscapeHTML(boolean escapeHTML) {
        this.mEscapeHTML = escapeHTML;
    }

    public void setEnableLinks(boolean enableLinks) {
        this.enableLinks = enableLinks;
    }

    protected void outputRegion(final CharSequence chars, RegionList regions, final int startOffset, final int endOffset) throws IOException {
        RegionList subregions = regions.getSubset(startOffset, endOffset);
        final Writer out = this.getOut();
        subregions.visitRegions(new RegionListVisitor(){
            int hrefDepth = 0;
            int lastStart = 0;
            int lastEnd = startOffset;

            public void start() {
            }

            public void regionStart(Region region) throws IOException {
                if (this.lastEnd < region.getStart()) {
                    AbstractRegionListTag.this.format(out, chars.subSequence(this.lastEnd, region.getStart()));
                    this.lastEnd = region.getStart();
                }
                String type = AbstractRegionListTag.this.getSpanClass(region);
                String href = (String)region.getPropertyValue("href");
                if (type != null) {
                    out.write("<span class=\"" + type + "\">");
                }
                if (AbstractRegionListTag.this.enableLinks && href != null) {
                    if (this.hrefDepth == 0) {
                        out.write("<a href=\"" + href + "\">");
                    }
                    ++this.hrefDepth;
                }
                this.lastStart = region.getStart();
            }

            public void regionEnd(Region region) throws IOException {
                int outputFrom = Math.max(this.lastEnd, this.lastStart);
                AbstractRegionListTag.this.format(out, chars.subSequence(outputFrom, region.getEnd()));
                String type = AbstractRegionListTag.this.getSpanClass(region);
                String href = (String)region.getPropertyValue("href");
                if (AbstractRegionListTag.this.enableLinks && href != null) {
                    --this.hrefDepth;
                    if (this.hrefDepth == 0) {
                        out.write("</a>");
                    }
                }
                if (type != null) {
                    out.write("</span>");
                }
                this.lastEnd = region.getEnd();
            }

            public void end() throws IOException {
                AbstractRegionListTag.this.format(out, chars.subSequence(this.lastEnd, endOffset));
            }
        });
    }

    protected Writer getOut() {
        return this.getJspContext().getOut();
    }

    protected abstract String getSpanClass(Region var1);

    protected String getStandardSpanClass(Region region, boolean isFrom) {
        String type = (String)region.getPropertyValue("type");
        if (type != null) {
            return "hl_" + type;
        }
        if (region.getPropertyValue("ediff") != null) {
            return isFrom ? "ediffChangedA" : "ediffChangedB";
        }
        return null;
    }

    protected void format(Writer out, CharSequence text) throws IOException {
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char c2 = text.charAt(i2);
            boolean wasCR = false;
            boolean wasSpace = false;
            if (c2 == ' ') {
                boolean writeRealSpace = false;
                if (this.mPrintFirstSpaceAsSpace) {
                    boolean bl = writeRealSpace = !this.lastWasSpace;
                }
                if (this.printLastSpaceAsSpace) {
                    boolean bl = writeRealSpace = i2 + 1 >= text.length() || text.charAt(i2 + 1) != ' ';
                }
                if (!this.mPrintFirstSpaceAsSpace && this.currentCol == 0) {
                    writeRealSpace = false;
                }
                if (writeRealSpace) {
                    out.write(32);
                } else {
                    out.write(this.mSpace);
                }
                ++this.currentCol;
                wasSpace = true;
            } else if (c2 == '\t') {
                out.write(this.mSpace);
                ++this.currentCol;
                while (this.currentCol % this.tabWidth() != 0) {
                    out.write(this.mSpace);
                    ++this.currentCol;
                }
                wasSpace = true;
            } else if (c2 == '\r') {
                out.write(this.mEol);
                this.currentCol = 0;
                wasCR = true;
            } else if (c2 == '\n') {
                if (!this.lastWasCR) {
                    out.write(this.mEol);
                    this.currentCol = 0;
                }
            } else {
                if (this.mEscapeHTML) {
                    ExpressionUtil.escapeChar(c2, out);
                } else {
                    out.write(c2);
                }
                ++this.currentCol;
            }
            this.lastWasCR = wasCR;
            this.lastWasSpace = wasSpace;
        }
    }

    public void resetLine() {
        this.currentCol = 0;
        this.lastWasCR = false;
        this.lastWasSpace = false;
    }

    private int tabWidth() {
        if (this.tabWidth == null) {
            this.tabWidth = this.defaultTabWidth();
        }
        return this.tabWidth;
    }

    private int defaultTabWidth() {
        try {
            UserLogin user;
            JspContext ctx;
            UserManager um = AppConfig.getsConfig().getUserManager();
            if (um != null && (ctx = this.getJspContext()) != null && (user = um.getCurrentUser(ctx)) != null) {
                UserProfile profile = AppConfig.getsConfig().getUserProfileManager().getProfile(user.getUsername());
                return profile.getTabwidth();
            }
        }
        catch (Exception e2) {
            Logs.APP_LOG.info((Object)"problem getting tab width");
        }
        return AppConfig.DEFAULT_TAB_WIDTH;
    }
}

