/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tarball;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cvsrep.RCSParser;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.web.BaseAction;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.tarball.Tarballer;
import com.cenqua.fisheye.web.tarball.ZipBaller;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.tools.bzip2.CBZip2OutputStream;

public class TarballAction
extends BaseAction {
    private static final String[] TARBALL_EXTENSIONS = new String[]{".zip", ".tar.gz", ".tgz", ".tar.bz", ".tbz", ".tar.bz2", ".tbz2"};
    private RevisionCache mRep;
    private int mMaxFiles = 0;
    int mFileCount;

    public long computeLastModified() throws DbException {
        return this.computeRepositoryLastModified();
    }

    public BaseAction handleRequest() throws ServletException, IOException, DbException {
        RepositoryConfig.TarballConfig tbCfg;
        boolean isTarballEnabled;
        this.parseWaybackSpec();
        FishEyePathInfo pi = this.getPathInfo();
        RepositoryConfig cfg = pi.getRepository();
        this.mRep = pi.getEngine().getRevisionCache();
        Path path = pi.getLocalPath();
        if (this.hasBallExtension(path.getName())) {
            path = path.getParent();
        }
        boolean bl = isTarballEnabled = (tbCfg = cfg.getTarballConfig()).isEnabled() && !tbCfg.isExcluded(path);
        if (!isTarballEnabled) {
            throw new ServletException("tarballing disabled");
        }
        this.mMaxFiles = tbCfg.getMaxFileCount();
        try {
            GZIPOutputStream zout;
            AbstractBaller baller;
            String balltype = pi.getCommandParam("tarball");
            if ("tgz".equals(balltype)) {
                this.setResponseHeaders("application/x-gzip", path, "tgz");
                baller = new Tarballer(this.mRep, path);
                zout = new GZIPOutputStream((OutputStream)this.getResponse().getOutputStream());
            } else if ("tbz2".equals(balltype)) {
                this.setResponseHeaders("application/x-bzip2", path, "tbz2");
                ServletOutputStream rout = this.getResponse().getOutputStream();
                rout.write(66);
                rout.write(90);
                zout = new CBZip2OutputStream((OutputStream)rout);
                baller = new Tarballer(this.mRep, path);
            } else {
                this.setResponseHeaders("application/zip", path, "zip");
                baller = new ZipBaller(this.mRep, path);
                zout = this.getResponse().getOutputStream();
            }
            baller.start(zout);
            this.getMatchingEntries(baller, path);
            baller.done();
            ((OutputStream)zout).close();
        }
        catch (IOException e2) {
            Logs.APP_LOG.warn((Object)"error creating tarball, aborting", (Throwable)e2);
            throw new ServletException((Throwable)e2);
        }
        catch (RCSParser.ParseException e3) {
            Logs.APP_LOG.warn((Object)"error creating tarball, aborting", (Throwable)e3);
            throw new ServletException((Throwable)e3);
        }
        return null;
    }

    private void setResponseHeaders(String contentType, Path path, String ext) {
        HttpServletResponse response = this.getResponse();
        response.setContentType(contentType);
        String fname = TarballAction.makeTarballFilename(path) + "." + ext;
        response.setHeader("Content-Disposition", "attachment; filename=" + fname);
    }

    public static String makeTarballFilename(Path path) {
        String name = path.getName();
        StringBuffer res = new StringBuffer(name.length());
        for (int i2 = 0; i2 < name.length(); ++i2) {
            boolean okay;
            char c2 = name.charAt(i2);
            if (c2 > '\u007f') continue;
            boolean bl = okay = Character.isLetterOrDigit(c2) || c2 == '-' || c2 == '_' || c2 == '.';
            if (!okay) continue;
            res.append(c2);
        }
        if (res.length() == 0) {
            return "tarball";
        }
        int MAX = 20;
        if (res.length() > 20) {
            res.delete(20, res.length());
        }
        return res.toString();
    }

    private void getMatchingEntries(AbstractBaller baller, Path dir) throws IOException, RCSParser.ParseException, DbException {
        this.mFileCount = 0;
        this.traverseDir(baller, dir);
    }

    private void traverseDir(AbstractBaller baller, Path dir) throws IOException, RCSParser.ParseException, DbException {
        if (this.tooManyFiles()) {
            Logs.APP_LOG.warn((Object)("tarball truncated, too many files: " + this.mFileCount));
            return;
        }
        Path[] files = this.mRep.listFiles(dir);
        for (int i2 = 0; i2 < files.length; ++i2) {
            Path file = files[i2];
            if (this.tooManyFiles()) {
                Logs.APP_LOG.warn((Object)("tarball truncated, too many files: " + this.mFileCount));
                return;
            }
            this.checkFile(baller, file);
        }
        Path[] dirs = this.mRep.listDirs(dir);
        for (int i3 = 0; i3 < dirs.length; ++i3) {
            Path subdir = dirs[i3];
            this.traverseDir(baller, subdir);
        }
    }

    private boolean tooManyFiles() {
        return this.mMaxFiles > 0 && this.mFileCount >= this.mMaxFiles;
    }

    private void checkFile(AbstractBaller baller, Path file) throws IOException, DbException, RCSParser.ParseException {
        FileHistory history = this.getRepositoryCache().getFileHistory(file);
        if (history == null) {
            return;
        }
        BallEntry entry = null;
        if (this.mWB == null) {
            FileRevision info = history.getRevision(history.getHead());
            if (info != null && !info.isDead() && info.getPath().equals(file)) {
                entry = new BallEntry(info.getRevInfoKey(), info.getDate(), info.isBinary(), null);
            }
        } else {
            entry = this.bestMatch(history, this.mWB);
        }
        if (entry != null) {
            baller.writeFile(entry);
            ++this.mFileCount;
        }
    }

    private BallEntry bestMatch(FileHistory history, WaybackSpec wb) {
        FileRevision best = null;
        for (FileRevision info : history.getRevisions()) {
            if (!wb.matches(info, true)) continue;
            if (best == null) {
                best = info;
                continue;
            }
            best = this.betterOf(best, info);
        }
        if (best != null && !best.isDead()) {
            String symname = null;
            if (wb.getBranch() != null) {
                symname = wb.getBranch();
            }
            if (wb.getTag() != null) {
                symname = wb.getTag();
            }
            return new BallEntry(best.getRevInfoKey(), best.getDate(), best.isBinary(), symname);
        }
        return null;
    }

    private FileRevision betterOf(FileRevision ia, FileRevision ib) {
        if (ia.getDate() > ib.getDate()) {
            return ia;
        }
        return ib;
    }

    private boolean hasBallExtension(String name) {
        for (int i2 = 0; i2 < TARBALL_EXTENSIONS.length; ++i2) {
            String ext = TARBALL_EXTENSIONS[i2];
            if (!name.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    static abstract class AbstractBaller {
        protected final RevisionCache mCRep;
        protected final Path mPrefix;

        protected AbstractBaller(RevisionCache CRep, Path prefix) {
            this.mCRep = CRep;
            this.mPrefix = prefix;
        }

        public void writeFile(BallEntry entry) throws IOException, RCSParser.ParseException, DbException {
            int prefixLength = this.mPrefix.numComponents();
            Path fullpath = entry.key.getPath();
            Path pathnamepath = fullpath.trimFirst(prefixLength);
            this.writeFile(entry, pathnamepath.getPath());
        }

        public abstract void writeFile(BallEntry var1, String var2) throws IOException, RCSParser.ParseException, DbException;

        public abstract void start(OutputStream var1);

        public abstract void done() throws IOException;
    }

    static class BallEntry {
        final RevInfoKey key;
        final long date;
        final boolean binary;
        final String symrev;

        public BallEntry(RevInfoKey key, long date, boolean binary, String symrev) {
            this.key = key;
            this.date = date;
            this.binary = binary;
            this.symrev = symrev;
        }
    }
}

