/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.license.crucible;

import cenqua_com_licensing.atlassian.license.License;
import cenqua_com_licensing.atlassian.license.LicenseTypeStore;
import cenqua_com_licensing.atlassian.license.applications.crucible.CrucibleLicenseTypeStore;
import com.cenqua.license.BaseAtlassianConverter;
import com.cenqua.license.CenquaLicense;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class CrucibleConverter
extends BaseAtlassianConverter {
    private static final Set DISPLAY_FOOTER_LICENSE_TYPES = new HashSet();
    private static final String PRODUCT = "Crucible";

    public CenquaLicense getCenquaLicense(String atlassianLicenseString) throws IOException {
        License l = this.getAtlassianLicense(atlassianLicenseString);
        Properties props = new Properties();
        if (DISPLAY_FOOTER_LICENSE_TYPES.contains(l.getLicenseType())) {
            props.put("owner.verbose1", "true");
        }
        return new CenquaLicense(PRODUCT, l, props);
    }

    public String getProductName() {
        return PRODUCT.toUpperCase();
    }

    public LicenseTypeStore createLicenseTypeStore() {
        return new CrucibleLicenseTypeStore();
    }

    static {
        DISPLAY_FOOTER_LICENSE_TYPES.add(CrucibleLicenseTypeStore.CRUCIBLE_EVALUATION);
        DISPLAY_FOOTER_LICENSE_TYPES.add(CrucibleLicenseTypeStore.CRUCIBLE_COMMUNITY);
        DISPLAY_FOOTER_LICENSE_TYPES.add(CrucibleLicenseTypeStore.CRUCIBLE_OPEN_SOURCE);
    }
}

