/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.obfuscate.bbk4uide.parsing;

import com.cenqua.obfuscate.bbk4uide.parsing.ParseProgressListener;
import com.cenqua.obfuscate.bbk4uide.parsing.SyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class Parser {
    private Reader b;
    private char[] c;
    private InputStream d;
    private byte[] e;
    private int f;
    private int g;
    private int h = -1;
    private Vector i;
    private long j;
    private boolean k;
    private Date l;
    private char m;
    private int n;
    private double o;
    private boolean p;
    private StringBuffer q = new StringBuffer(1);
    private StringBuffer r = new StringBuffer();
    private StringBuffer s = new StringBuffer();
    int a;

    public Parser(Reader reader) {
        this(reader, 10000);
    }

    public Parser(Reader reader, int n) {
        this.b = reader;
        this.c = new char[n];
        if (reader == null) {
            throw new RuntimeException("reader is null");
        }
    }

    public Parser(InputStream inputStream) {
        this(inputStream, 10000);
    }

    public Parser(InputStream inputStream, int n) {
        this.d = inputStream;
        this.e = new byte[n];
        if (inputStream == null) {
            throw new RuntimeException("InputStream 'in' is null");
        }
    }

    public Parser(char[] cArray) {
        this.c = cArray;
        this.f = cArray.length;
        if (cArray == null) {
            throw new RuntimeException("cbuf is null");
        }
    }

    public Parser(String string) {
        if (string == null) {
            throw new RuntimeException("String parameter is null");
        }
        if (string.length() < 10000) {
            this.c = string.toCharArray();
            this.f = this.c.length;
        } else {
            this.b = new StringReader(string);
            this.c = new char[10000];
        }
    }

    public Parser(byte[] byArray) {
        this.e = byArray;
        this.f = byArray.length;
        if (byArray == null) {
            throw new RuntimeException("bbuf is null");
        }
    }

    public boolean match(String string) throws IOException {
        int n;
        int n2 = n = this.h == -1 ? -1 : this.g - this.h;
        if (this.h == -1) {
            this.h = this.g;
        }
        int n3 = string.length();
        for (int j = 0; j < n3; ++j) {
            if (this.g == this.f && !this.b() || (this.c != null ? this.c[this.g] : (char)this.e[this.g] & 0xFF) != string.charAt(j)) {
                if (n == -1) {
                    this.g = this.h;
                    this.h = -1;
                } else {
                    this.g = this.h + n;
                }
                return false;
            }
            ++this.g;
        }
        if (n == -1) {
            this.h = -1;
        }
        return true;
    }

    public boolean matchIgnoreCase(String string) throws IOException {
        int n;
        int n2 = n = this.h == -1 ? -1 : this.g - this.h;
        if (this.h == -1) {
            this.h = this.g;
        }
        int n3 = string.length();
        for (int j = 0; j < n3; ++j) {
            char c2;
            if (this.g == this.f && !this.b()) {
                if (n == -1) {
                    this.g = this.h;
                    this.h = -1;
                } else {
                    this.g = this.h + n;
                }
                return false;
            }
            char c3 = (char)(this.c != null ? this.c[this.g] : (char)this.e[this.g] & 0xFF);
            if (c3 >= 'A' && c3 <= 'Z') {
                c3 = (char)(c3 + 32);
            }
            if ((c2 = string.charAt(j)) >= 'A' && c2 <= 'Z') {
                c2 = (char)(c2 + 32);
            }
            if (c3 != c2) {
                if (n == -1) {
                    this.g = this.h;
                    this.h = -1;
                } else {
                    this.g = this.h + n;
                }
                return false;
            }
            ++this.g;
        }
        if (n == -1) {
            this.h = -1;
        }
        return true;
    }

    public boolean matchLong() throws IOException {
        if (this.g == this.f && !this.b()) {
            return false;
        }
        char c2 = (char)(this.c != null ? this.c[this.g] : (char)this.e[this.g] & 0xFF);
        if ((c2 < '0' || c2 > '9') && c2 != '-') {
            return false;
        }
        boolean bl = false;
        if (c2 == '-') {
            bl = true;
            c2 = (char)this.nextChar();
        }
        this.j = 0L;
        boolean bl2 = this.k = c2 == '0';
        while (c2 >= '0' && c2 <= '9') {
            this.j *= 10L;
            this.j += (long)(c2 - 48);
            ++this.g;
            if (this.g == this.f && !this.b()) break;
            c2 = (char)(this.c != null ? this.c[this.g] : (char)this.e[this.g] & 0xFF);
        }
        if (bl) {
            this.j = -this.j;
        }
        return true;
    }

    public boolean matchPositiveLong() throws IOException {
        if (this.g == this.f && !this.b()) {
            return false;
        }
        char c2 = (char)(this.c != null ? this.c[this.g] : (char)this.e[this.g] & 0xFF);
        if (c2 < '0' || c2 > '9') {
            return false;
        }
        this.j = 0L;
        boolean bl = this.k = c2 == '0';
        while (c2 >= '0' && c2 <= '9') {
            this.j *= 10L;
            this.j += (long)(c2 - 48);
            ++this.g;
            if (this.g == this.f && !this.b()) break;
            c2 = (char)(this.c != null ? this.c[this.g] : (char)this.e[this.g] & 0xFF);
        }
        return true;
    }

    public long getMatchedLong() {
        return this.j;
    }

    public void setMatchedLong(long l) {
        this.j = l;
    }

    public boolean getMatchedInitialZero() {
        return this.k;
    }

    public boolean matchHexLong() throws IOException {
        this.j = 0L;
        if (!this.matchHexDigit()) {
            return false;
        }
        this.j = this.n;
        while (this.matchHexDigit()) {
            this.j <<= 4;
            this.j += (long)this.n;
        }
        return true;
    }

    public boolean matchHexDigit() throws IOException {
        if (!this.matchDigit()) {
            if (this.matchRange('A', 'F')) {
                this.setMatchedDigit(10 + this.getMatchedChar() - 65);
            } else if (this.matchRange('a', 'f')) {
                this.setMatchedDigit(10 + this.getMatchedChar() - 97);
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean matchFloatOrDoubleWithNaNAndInfinities() throws IOException {
        if (this.matchIgnoreCase("Infinity")) {
            this.p = !this.matchIgnoreCase('f');
            this.o = Double.POSITIVE_INFINITY;
        } else if (this.matchIgnoreCase("-Infinity")) {
            this.p = !this.matchIgnoreCase('f');
            this.o = Double.NEGATIVE_INFINITY;
        } else if (this.matchIgnoreCase("NaN")) {
            this.p = !this.matchIgnoreCase('f');
            this.o = Double.NaN;
        } else if (!this.matchFloatOrDouble()) {
            return false;
        }
        return true;
    }

    public boolean matchFloatOrDouble() throws IOException {
        this.o = Double.NaN;
        int n = this.markForBackup();
        this.match('-');
        boolean bl = false;
        while (this.matchDigit()) {
            bl = true;
        }
        boolean bl2 = this.match('.');
        boolean bl3 = false;
        while (this.matchDigit()) {
            bl3 = true;
        }
        boolean bl4 = false;
        if (this.matchIgnoreCase('e')) {
            if (this.match('+') || this.match('-')) {
                // empty if block
            }
            while (this.matchDigit()) {
                bl4 = true;
            }
        }
        boolean bl5 = this.matchIgnoreCase('f') || this.matchIgnoreCase('d');
        if (!bl & !bl3) {
            this.backup(n);
            return false;
        }
        if (!(bl2 | bl4 | bl5)) {
            this.backup(n);
            return false;
        }
        String string = this.getMatchedStringFromBackupPos(n);
        this.unmarkForBackup(n);
        try {
            if (string.endsWith("f") || string.endsWith("F")) {
                this.o = Float.valueOf(string).doubleValue();
                this.p = false;
            } else {
                this.o = Double.valueOf(string);
                this.p = true;
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public double getMatchedDouble() {
        return this.o;
    }

    public boolean getMatchedDoubleNotFloat() {
        return this.p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lookaheadFloatOrDouble() throws IOException {
        int n = this.markForBackup();
        try {
            this.match('-');
            if (!this.matchDigit()) {
                boolean bl = this.match('.');
                return bl;
            }
            while (this.matchDigit()) {
            }
            boolean bl = this.match('.') || this.matchIgnoreCase('e') || this.matchIgnoreCase('f') || this.matchIgnoreCase('d');
            return bl;
        }
        finally {
            this.backup(n);
        }
    }

    public boolean matchJavaQuotedString() throws IOException {
        return this.matchJavaQuotedString(true);
    }

    public boolean matchJavaQuotedString(boolean bl) throws IOException {
        if (!this.match('\"')) {
            return false;
        }
        StringBuffer stringBuffer = this.q;
        stringBuffer.setLength(0);
        while (true) {
            if (this.matchEOL()) {
                if (!bl) break;
                throw new SyntaxException("Unterminated quoted String");
            }
            if (this.match('\"')) break;
            if (this.match('\\')) {
                if (this.match('\"')) {
                    stringBuffer.append('\"');
                    continue;
                }
                if (this.match('r')) {
                    stringBuffer.append('\r');
                    continue;
                }
                if (this.match('n')) {
                    stringBuffer.append('\n');
                    continue;
                }
                if (this.match('t')) {
                    stringBuffer.append('\t');
                    continue;
                }
                if (this.match('\\')) {
                    stringBuffer.append('\\');
                    continue;
                }
                if (this.match('u')) {
                    while (this.match('u')) {
                    }
                    this.a(0, 4);
                    stringBuffer.append((char)this.j);
                    continue;
                }
                if (this.lookaheadEOL()) continue;
                stringBuffer.append((char)this.matchAnyChar());
                continue;
            }
            stringBuffer.append((char)this.matchAnyChar());
        }
        return true;
    }

    public String getMatchedJavaQuotedString() {
        return this.q.toString();
    }

    private boolean a(int n, int n2) throws IOException {
        this.j = 0L;
        for (int j = 0; j < n2; ++j) {
            if (!this.matchHexDigit()) {
                return j >= n;
            }
            this.j <<= 4;
            this.j |= (long)(this.n & 0xF);
        }
        return true;
    }

    public static String formatJavaQuotedString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 3);
        stringBuffer.append('\"');
        for (int j = 0; j < string.length(); ++j) {
            char c2 = string.charAt(j);
            if (c2 == '\"') {
                stringBuffer.append("\\\"");
                continue;
            }
            if (c2 == '\\') {
                stringBuffer.append("\\\\");
                continue;
            }
            if (c2 == '\r') {
                stringBuffer.append("\\r");
                continue;
            }
            if (c2 == '\n') {
                stringBuffer.append("\\n");
                continue;
            }
            if (c2 == '\t') {
                stringBuffer.append("\\t");
                continue;
            }
            if (c2 > '\u007f') {
                stringBuffer.append("\\u");
                Parser.a(c2, 4, stringBuffer);
                continue;
            }
            stringBuffer.append(c2);
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    private static void a(long l, int n, StringBuffer stringBuffer) {
        for (int j = n - 1; j >= 0; --j) {
            stringBuffer.append(Parser.a(l >> j * 4 & 0xFL));
        }
    }

    private static char a(long l) {
        return (l &= 0xFL) >= 10L ? (char)(l + 97L - 10L) : (char)(l + 48L);
    }

    public boolean matchJavaIdentifier(Parser parser) throws IOException {
        if (this.matchLetter() || this.match('_') || this.match('$')) {
            StringBuffer stringBuffer = this.r;
            stringBuffer.setLength(0);
            stringBuffer.append(this.getMatchedChar());
            while (this.matchLetter() || this.matchDigit() || this.match('_') || this.match('$')) {
                stringBuffer.append(this.getMatchedChar());
            }
            return true;
        }
        return false;
    }

    public String getMatchedJavaIdentifier() {
        return this.r.toString();
    }

    public boolean matchUpToWhiteSpace() throws IOException {
        if (this.getCurrentChar() <= 32) {
            return false;
        }
        StringBuffer stringBuffer = this.s;
        stringBuffer.setLength(0);
        while (this.getCurrentChar() > 32) {
            stringBuffer.append((char)this.matchAnyChar());
        }
        return true;
    }

    public String getMatchedStringUpToWhiteSpace() {
        return this.s.toString();
    }

    public boolean matchSimpleNumericDate() throws IOException {
        this.l = null;
        long l = 0L;
        long l2 = 1L;
        long l3 = 1L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        int n = this.markForBackup();
        if (!this.matchPositiveLong()) {
            this.backup(n);
            return false;
        }
        l = this.j;
        if (l <= 99L) {
            l = this.k ? (l += 2000L) : (l += 1900L);
        }
        if (this.match('/')) {
            this.unmarkForBackup(n);
            if (this.matchPositiveLong()) {
                l2 = this.j;
                if (this.match('/') && this.matchPositiveLong()) {
                    l3 = this.j;
                }
            }
        } else {
            this.backup(n);
            return false;
        }
        n = this.markForBackup();
        boolean bl = this.match(' ') && this.matchPositiveLong() && this.match(':');
        this.backup(n);
        if (bl) {
            this.match(' ');
            this.matchPositiveLong();
            l4 = this.j;
            this.match(':');
            if (this.matchPositiveLong()) {
                l5 = this.j;
            }
            if (this.match(':') && this.matchLong()) {
                l6 = this.j;
                if (this.match('.')) {
                    double d2 = 0.1;
                    double d3 = 0.0;
                    while (this.matchDigit()) {
                        d3 += (double)this.n * d2;
                        d2 /= 10.0;
                    }
                    l7 = (long)(d3 * 1000.0);
                }
            }
        }
        n = this.markForBackup();
        if ((this.matchWordIgnoreCase("am") || this.matchWordIgnoreCase("a")) && l4 == 12L) {
            l4 = 0L;
            this.unmarkForBackup(n);
        } else if ((this.matchWordIgnoreCase("pm") || this.matchWordIgnoreCase("p")) && l4 != 12L) {
            l4 += 12L;
            this.unmarkForBackup(n);
        } else {
            this.backup(n);
        }
        n = this.markForBackup();
        boolean bl2 = false;
        int n2 = this.getCurrentChar();
        if (n2 == 43 || n2 == 45 || Parser.isLetter(n2)) {
            this.unmarkForBackup(n);
            bl2 = this.a();
        } else {
            this.backup(n);
        }
        Calendar calendar = bl2 ? Calendar.getInstance(TimeZone.getTimeZone("GMT")) : Calendar.getInstance();
        calendar.set((int)l, (int)l2 - 1, (int)l3, (int)l4, (int)l5, (int)l6);
        calendar.set(14, (int)l7);
        this.l = calendar.getTime();
        long l8 = this.l.getTime();
        this.l.setTime(l8 - (long)this.a * 60L * 1000L);
        return true;
    }

    public Date getMatchedDate() {
        return this.l;
    }

    public static boolean isLetter(int n) {
        return n >= 97 && n <= 122 || n >= 65 && n <= 90;
    }

    public boolean matchWordIgnoreCase(String string) throws IOException {
        int n = this.markForBackup();
        if (this.matchIgnoreCase(string) && !this.matchLetter()) {
            this.unmarkForBackup(n);
            return true;
        }
        this.backup(n);
        return false;
    }

    boolean a() throws IOException {
        this.a = 0;
        int n = 0;
        if (this.matchIgnoreCase("gmt") || this.matchIgnoreCase("u") || this.matchIgnoreCase("ut") || this.matchIgnoreCase("utc") || this.matchIgnoreCase("greenwich mean time")) {
            n = 0;
        } else if (this.matchIgnoreCase("edt")) {
            n = -4;
        } else if (this.matchIgnoreCase("eastern daylight time")) {
            n = -4;
        } else if (this.matchIgnoreCase("est")) {
            n = -5;
        } else if (this.matchIgnoreCase("eastern standard time")) {
            n = -5;
        } else if (this.matchIgnoreCase("cdt")) {
            n = -5;
        } else if (this.matchIgnoreCase("central daylight time")) {
            n = -5;
        } else if (this.matchIgnoreCase("cst")) {
            n = -6;
        } else if (this.matchIgnoreCase("central standard time")) {
            n = -6;
        } else if (this.matchIgnoreCase("mdt")) {
            n = -6;
        } else if (this.matchIgnoreCase("mountain daylight time")) {
            n = -6;
        } else if (this.matchIgnoreCase("mst")) {
            n = -7;
        } else if (this.matchIgnoreCase("mountain standard time")) {
            n = -7;
        } else if (this.matchIgnoreCase("pdt")) {
            n = -7;
        } else if (this.matchIgnoreCase("pacific daylight time")) {
            n = -7;
        } else if (this.matchIgnoreCase("pst")) {
            n = -8;
        } else if (this.matchIgnoreCase("pacific standard time")) {
            n = -8;
        } else if (this.matchIgnoreCase("nst")) {
            n = 12;
        } else if (this.matchIgnoreCase("sst")) {
            n = 11;
        } else if (this.matchIgnoreCase("aet")) {
            n = 10;
        } else if (this.matchIgnoreCase("jst")) {
            n = 9;
        } else if (this.matchIgnoreCase("ctt")) {
            n = 8;
        } else if (this.matchIgnoreCase("vst")) {
            n = 7;
        } else if (this.matchIgnoreCase("bst")) {
            n = 6;
        } else if (this.matchIgnoreCase("plt")) {
            n = 5;
        } else if (this.matchIgnoreCase("net")) {
            n = 4;
        } else if (this.matchIgnoreCase("eat")) {
            n = 3;
        } else if (this.matchIgnoreCase("art")) {
            n = 2;
        } else if (this.matchIgnoreCase("eet")) {
            n = 1;
        } else if (this.matchIgnoreCase("ect")) {
            n = 1;
        } else if (this.matchIgnoreCase("cat")) {
            n = -1;
        } else if (this.matchIgnoreCase("bet")) {
            n = -3;
        } else if (this.matchIgnoreCase("agt")) {
            n = -3;
        } else if (this.matchIgnoreCase("prt")) {
            n = -4;
        } else if (this.matchIgnoreCase("ast")) {
            n = -9;
        } else if (this.matchIgnoreCase("hst")) {
            n = -10;
        } else if (this.matchIgnoreCase("mit")) {
            n = -11;
        } else if (this.matchIgnoreCase("pht")) {
            n = 0;
        } else if (!this.matchWordIgnoreCase("z")) {
            if (this.matchWordIgnoreCase("a")) {
                n = -1;
            } else if (this.matchWordIgnoreCase("m")) {
                n = -12;
            } else if (this.matchWordIgnoreCase("n")) {
                n = 1;
            } else if (this.matchWordIgnoreCase("y")) {
                n = 12;
            }
        }
        n *= 60;
        long l = 0L;
        if (this.match('+') && this.matchPositiveLong()) {
            l = this.j;
        } else if (this.match('-') && this.matchPositiveLong()) {
            l = -this.j;
        }
        n = l > -24L && l < 24L ? (int)((long)n + l * 60L) : (int)((long)n + (l / 100L * 60L + l % 100L));
        if (this.match(':') && this.matchPositiveLong()) {
            l = l < 0L ? (l -= this.j) : (l += this.j);
        }
        this.a = n;
        return true;
    }

    public static String formatSimpleNumericDate(Date date) {
        StringBuffer stringBuffer = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        stringBuffer.append(n);
        stringBuffer.append('/');
        stringBuffer.append(n2);
        if (n3 != 1) {
            stringBuffer.append('/');
            stringBuffer.append(n3);
        }
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        int n6 = calendar.get(13);
        int n7 = calendar.get(14);
        if (n4 != 0 || n5 != 0 || n6 != 0 || n7 != 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(n4);
            stringBuffer.append(':');
            stringBuffer.append(n5);
        }
        if (n6 != 0 || n7 != 0) {
            stringBuffer.append(':');
            stringBuffer.append(n6);
        }
        if (n7 != 0) {
            stringBuffer.append('.');
            if ((n7 %= 1000) < 10) {
                stringBuffer.append("00");
            } else if (n7 < 100) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n7);
        }
        Parser.a(stringBuffer, (long)calendar.getTimeZone().getRawOffset());
        return stringBuffer.toString();
    }

    private static void a(StringBuffer stringBuffer, long l) {
        boolean bl;
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l = -l;
        }
        long l2 = l / 60000L;
        long l3 = l2 / 60L;
        long l4 = l2 % 60L;
        stringBuffer.append(bl ? "-" : "+");
        Parser.a(stringBuffer, (int)l3, 2);
        Parser.a(stringBuffer, (int)l4, 2);
    }

    private static void a(StringBuffer stringBuffer, int n, int n2) {
        int n3 = Parser.a(n);
        if (n < 0) {
            stringBuffer.append('-');
            n = -n;
        }
        while (n3 < n2) {
            stringBuffer.append("0");
            ++n3;
        }
        Parser.a(stringBuffer, n);
    }

    private static int a(int n) {
        if (n == 0) {
            return 1;
        }
        int n2 = 0;
        if (n < 0) {
            ++n2;
            n = -n;
        }
        while (n > 0) {
            ++n2;
            n /= 10;
        }
        return n2;
    }

    private static void a(StringBuffer stringBuffer, int n) {
        if (n == 0) {
            stringBuffer.append('0');
        } else if (n < 0) {
            stringBuffer.append('-');
            Parser.b(stringBuffer, -n);
        } else {
            Parser.b(stringBuffer, n);
        }
    }

    private static void b(StringBuffer stringBuffer, int n) {
        if (n >= 10) {
            Parser.b(stringBuffer, n / 10);
        }
        stringBuffer.append((char)(48 + n % 10));
    }

    public boolean matchWhiteSpace() throws IOException {
        if (this.g == this.f && !this.b() || (char)(this.c != null ? this.c[this.g] : (char)this.e[this.g] & 0xFF) > ' ') {
            return false;
        }
        while ((this.g != this.f || this.b()) && (char)(this.c != null ? this.c[this.g] : (char)this.e[this.g] & 0xFF) <= ' ') {
            ++this.g;
        }
        return true;
    }

    public boolean matchEOL() throws IOException {
        if (this.g == this.f && !this.b()) {
            return true;
        }
        char c2 = (char)(this.c != null ? this.c[this.g] : (char)this.e[this.g] & 0xFF);
        if (c2 == '\n') {
            ++this.g;
            return true;
        }
        if (c2 == '\r') {
            ++this.g;
            this.match('\n');
            return true;
        }
        return false;
    }

    public int skipNonEOL() throws IOException {
        if (this.g == this.f && !this.b()) {
            return -1;
        }
        char c2 = (char)(this.c != null ? this.c[this.g] : (char)this.e[this.g] & 0xFF);
        if (c2 == '\r' || c2 == '\n') {
            return -1;
        }
        ++this.g;
        return c2;
    }

    public boolean lookaheadEOL() throws IOException {
        if (this.g == this.f && !this.b()) {
            return true;
        }
        char c2 = (char)(this.c != null ? this.c[this.g] : (char)this.e[this.g] & 0xFF);
        return c2 == '\n' || c2 == '\r';
    }

    public boolean skipUpToEOL() throws IOException {
        if (this.g == this.f && !this.b()) {
            return false;
        }
        while (this.g != this.f || this.b()) {
            char c2 = (char)(this.c != null ? this.c[this.g] : (char)this.e[this.g] & 0xFF);
            if (c2 == '\r' || c2 == '\n') {
                return true;
            }
            ++this.g;
        }
        return true;
    }

    public boolean skipLine() throws IOException {
        if (this.skipUpToEOL()) {
            this.matchEOL();
            return true;
        }
        return false;
    }

    public boolean writeUpToEOL(Writer writer) throws IOException {
        int n;
        int n2 = n = this.h == -1 ? -1 : this.g - this.h;
        if (this.h == -1) {
            this.h = this.g;
        }
        int n3 = this.g - this.h;
        if (this.skipUpToEOL()) {
            int n4 = this.h + n3;
            int n5 = this.g - this.h - n3;
            if (this.c != null) {
                writer.write(this.c, n4, n5);
            } else {
                for (int j = 0; j < n5; ++j) {
                    writer.write(this.e[n4 + j] & 0xFF);
                }
            }
            if (n == -1) {
                this.h = -1;
            }
            return true;
        }
        if (n == -1) {
            this.h = -1;
        }
        return false;
    }

    public boolean writeLine(Writer writer) throws IOException {
        int n;
        int n2 = n = this.h == -1 ? -1 : this.g - this.h;
        if (this.h == -1) {
            this.h = this.g;
        }
        int n3 = this.g - this.h;
        if (this.skipUpToEOL()) {
            this.matchEOL();
            int n4 = this.h + n3;
            int n5 = this.g - this.h - n3;
            if (this.c != null) {
                writer.write(this.c, n4, n5);
            } else {
                for (int j = 0; j < n5; ++j) {
                    writer.write(this.e[n4 + j] & 0xFF);
                }
            }
            if (n == -1) {
                this.h = -1;
            }
            return true;
        }
        if (n == -1) {
            this.h = -1;
        }
        return false;
    }

    public boolean writeUpToEOL(OutputStream outputStream) throws IOException {
        int n;
        int n2 = n = this.h == -1 ? -1 : this.g - this.h;
        if (this.h == -1) {
            this.h = this.g;
        }
        int n3 = this.g - this.h;
        if (this.skipUpToEOL()) {
            int n4 = this.h + n3;
            int n5 = this.g - this.h - n3;
            if (this.c != null) {
                for (int j = 0; j < n5; ++j) {
                    outputStream.write((byte)this.c[n4 + j]);
                }
            } else {
                outputStream.write(this.e, n4, n5);
            }
            if (n == -1) {
                this.h = -1;
            }
            return true;
        }
        if (n == -1) {
            this.h = -1;
        }
        return false;
    }

    public boolean writeLine(OutputStream outputStream) throws IOException {
        int n;
        if (this.e == null) {
            throw new RuntimeException("cannot write from char buf to OutputStream in this version");
        }
        int n2 = n = this.h == -1 ? -1 : this.g - this.h;
        if (this.h == -1) {
            this.h = this.g;
        }
        int n3 = this.g - this.h;
        if (this.skipUpToEOL()) {
            this.matchEOL();
            int n4 = this.h + n3;
            int n5 = this.g - this.h - n3;
            if (this.c != null) {
                for (int j = 0; j < n5; ++j) {
                    outputStream.write((byte)this.c[n4 + j]);
                }
            } else {
                outputStream.write(this.e, n4, n5);
            }
            if (n == -1) {
                this.h = -1;
            }
            return true;
        }
        if (n == -1) {
            this.h = -1;
        }
        return false;
    }

    public String readLine() throws IOException {
        int n = this.markForBackup();
        String string = null;
        if (this.skipUpToEOL()) {
            string = this.getMatchedStringFromBackupPos(n);
            this.matchEOL();
        }
        this.unmarkForBackup(n);
        return string;
    }

    public String getMatchedStringFromBackupPos(int n) throws IOException {
        int n2 = this.h + (n == -1 ? 0 : n);
        int n3 = this.g - this.h - (n == -1 ? 0 : n);
        return this.c != null ? new String(this.c, n2, n3) : new String(this.e, n2, n3);
    }

    public boolean matchDigit() throws IOException {
        int n = this.getCurrentChar();
        if (n >= 48 && n <= 57) {
            this.n = n - 48;
            this.m = (char)n;
            ++this.g;
            return true;
        }
        return false;
    }

    public int getMatchedDigit() {
        return this.n;
    }

    public void setMatchedDigit(int n) {
        this.n = n;
    }

    public boolean matchLetter() throws IOException {
        int n = this.getCurrentChar();
        if (n >= 65 && n <= 90 || n >= 97 && n <= 122) {
            this.m = (char)n;
            ++this.g;
            return true;
        }
        return false;
    }

    public boolean match(char c2) throws IOException {
        if (this.g == this.f && !this.b() || (char)(this.c != null ? this.c[this.g] : (char)this.e[this.g] & 0xFF) != c2) {
            return false;
        }
        ++this.g;
        this.m = c2;
        return true;
    }

    public boolean matchIgnoreCase(char c2) throws IOException {
        if (this.g == this.f && !this.b()) {
            return false;
        }
        char c3 = (char)(this.c != null ? this.c[this.g] : (char)this.e[this.g] & 0xFF);
        if (c3 >= 'A' && c3 <= 'Z') {
            c3 = (char)(c3 + 32);
        }
        if (c2 >= 'A' && c2 <= 'Z') {
            c2 = (char)(c2 + 32);
        }
        if (c3 != c2) {
            return false;
        }
        ++this.g;
        this.m = c2;
        return true;
    }

    public boolean matchRange(char c2, char c3) throws IOException {
        if (this.g == this.f && !this.b()) {
            return false;
        }
        char c4 = (char)(this.c != null ? this.c[this.g] : (char)this.e[this.g] & 0xFF);
        if (c4 < c2 || c4 > c3) {
            return false;
        }
        ++this.g;
        this.m = c4;
        return true;
    }

    public boolean matchCharSet(String string) throws IOException {
        if (this.g == this.f && !this.b()) {
            return false;
        }
        char c2 = (char)(this.c != null ? this.c[this.g] : (char)this.e[this.g] & 0xFF);
        int n = string.length();
        for (int j = 0; j < n; ++j) {
            if (string.charAt(j) != c2) continue;
            ++this.g;
            this.m = c2;
            return true;
        }
        return false;
    }

    public boolean matchCharSet(char[] cArray) throws IOException {
        if (this.g == this.f && !this.b()) {
            return false;
        }
        char c2 = (char)(this.c != null ? this.c[this.g] : (char)this.e[this.g] & 0xFF);
        int n = cArray.length;
        for (int j = 0; j < n; ++j) {
            if (cArray[j] != c2) continue;
            ++this.g;
            this.m = c2;
            return true;
        }
        return false;
    }

    public int getCurrentChar() throws IOException {
        if (this.g == this.f && !this.b()) {
            return -1;
        }
        return this.c != null ? this.c[this.g] : this.e[this.g] & 0xFF;
    }

    public int matchAnyChar() throws IOException {
        if (this.g == this.f && !this.b()) {
            return -1;
        }
        this.m = (char)(this.c != null ? this.c[this.g++] : this.e[this.g++] & 0xFF);
        return this.m;
    }

    public int nextChar() throws IOException {
        if (this.g == this.f && !this.b()) {
            return -1;
        }
        ++this.g;
        if (this.g == this.f && !this.b()) {
            return -1;
        }
        this.m = (char)(this.c != null ? this.c[this.g] : this.e[this.g] & 0xFF);
        return this.m;
    }

    public char getMatchedChar() {
        return this.m;
    }

    public boolean matchEOF() throws IOException {
        return this.g == this.f && !this.b();
    }

    public int markForBackup() {
        if (this.h == -1) {
            this.h = this.g;
            return -1;
        }
        return this.g - this.h;
    }

    public void unmarkForBackup(int n) {
        if (n == -1) {
            if (this.h == -1) {
                throw new RuntimeException("unmarkForBackup() without markForBackup().");
            }
            this.h = -1;
        } else {
            if (n > this.g - this.h) {
                throw new RuntimeException("backupSave > pos - backupPos");
            }
            if (n < 0) {
                throw new RuntimeException("backupSave < 0");
            }
        }
    }

    public void backup(int n) {
        if (n == -1) {
            if (this.h == -1) {
                throw new RuntimeException("backup() without markForBackup().");
            }
            this.g = this.h;
            this.h = -1;
        } else {
            if (n > this.g - this.h) {
                throw new RuntimeException("backupSave > pos - backupPos");
            }
            if (n < 0) {
                throw new RuntimeException("backupSave < 0");
            }
            this.g = this.h + n;
        }
    }

    public boolean isMarkedForBackup() {
        return this.h != -1;
    }

    private boolean b() throws IOException {
        int n;
        if (this.g != this.f) {
            this.err("Internal parser error: pos != len in fill");
        }
        if (this.c != null ? this.b == null : this.d == null) {
            return false;
        }
        if (this.f == (this.c != null ? this.c.length : this.e.length)) {
            if (this.h != -1) {
                Object[] objectArray;
                if (this.h > 0) {
                    if (this.c != null) {
                        System.arraycopy(this.c, this.h, this.c, 0, this.f - this.h);
                    } else {
                        System.arraycopy(this.e, this.h, this.e, 0, this.f - this.h);
                    }
                    this.g -= this.h;
                    this.f -= this.h;
                    this.h = 0;
                } else if (this.c != null) {
                    objectArray = new char[this.c.length * 2];
                    System.arraycopy(this.c, 0, objectArray, 0, this.c.length);
                    this.c = objectArray;
                } else {
                    objectArray = new byte[this.c.length * 2];
                    System.arraycopy(this.e, 0, objectArray, 0, this.e.length);
                    this.e = (byte[])objectArray;
                }
            } else {
                this.f = 0;
                this.g = 0;
            }
        }
        int n2 = n = this.c != null ? this.b.read(this.c, this.f, this.c.length - this.f) : this.d.read(this.e, this.f, this.e.length - this.f);
        if (n == -1) {
            return false;
        }
        this.f += n;
        return true;
    }

    public void err(String string) throws SyntaxException {
        int n;
        if (this.f < 0) {
            this.f = 0;
        }
        if (this.f > (n = this.getBufLength())) {
            this.f = n;
        }
        if (this.g < 0) {
            this.g = 0;
        }
        if (this.g > this.f) {
            this.g = this.f;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.g - 30;
        if (n2 < 0) {
            n2 = 0;
        }
        while (n2 < this.g) {
            stringBuffer.append(this.b(n2));
            ++n2;
        }
        stringBuffer.append("@PARSE_POSITION@");
        int n3 = 0;
        int n4 = 0;
        for (int j = this.g; j < this.f && ++n4 <= 120; ++j) {
            char c2 = this.b(j);
            if (c2 == '\n') {
                ++n3;
            }
            if (n3 > 3) break;
            stringBuffer.append(c2);
        }
        throw new SyntaxException("Syntax error: " + string + ":\r\n" + stringBuffer);
    }

    private char b(int n) {
        return (char)(this.c != null ? this.c[n] : (char)this.e[n] & 0xFF);
    }

    public int getBufLength() {
        return this.c != null ? this.c.length : this.e.length;
    }

    public void close() throws IOException {
        this.c = null;
        this.e = null;
        this.r = null;
        this.q = null;
        this.s = null;
        if (this.b != null) {
            this.b.close();
        } else if (this.d != null) {
            this.d.close();
        }
    }

    public void fireParseProgress() {
        if (this.i == null) {
            return;
        }
        for (int j = 0; j < this.i.size(); ++j) {
            ((ParseProgressListener)this.i.elementAt(j)).parseProgressOccurred(this);
        }
    }

    public synchronized void addParseProgressListener(ParseProgressListener parseProgressListener) {
        if (this.i == null) {
            this.i = new Vector();
        }
        this.i.addElement(parseProgressListener);
    }

    public synchronized void removeParseProgressListener(ParseProgressListener parseProgressListener) {
        if (this.i == null) {
            return;
        }
        this.i.removeElement(parseProgressListener);
    }

    public static void p(Object object) {
        System.out.println(object);
    }
}

