/*
 * Decompiled with CFR 0.152.
 */
package cenqua_com_licensing.atlassian.license.ng;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class DefaultPropertiesPersister {
    public static void store(Properties props, Writer writer) throws IOException {
        BufferedWriter out = new BufferedWriter(writer);
        Enumeration keys = ((Hashtable)props).keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String val = props.getProperty(key);
            out.write(DefaultPropertiesPersister.escape(key, true) + "=" + DefaultPropertiesPersister.escape(val, false));
            out.newLine();
        }
        out.flush();
    }

    public static void load(Properties props, Reader reader) throws IOException {
        BufferedReader in = new BufferedReader(reader);
        String line;
        while ((line = in.readLine()) != null) {
            char firstChar;
            if ((line = DefaultPropertiesPersister.trimLeadingWhitespace(line)).length() <= 0 || (firstChar = line.charAt(0)) == '#' || firstChar == '!') continue;
            while (DefaultPropertiesPersister.endsWithContinuationMarker(line)) {
                String nextLine = in.readLine();
                line = line.substring(0, line.length() - 1);
                if (nextLine == null) continue;
                line = line + DefaultPropertiesPersister.trimLeadingWhitespace(nextLine);
            }
            int separatorIndex = line.indexOf("=");
            if (separatorIndex == -1) {
                separatorIndex = line.indexOf(":");
            }
            String key = separatorIndex != -1 ? line.substring(0, separatorIndex) : line;
            String value = separatorIndex != -1 ? line.substring(separatorIndex + 1) : "";
            key = DefaultPropertiesPersister.trimTrailingWhitespace(key);
            value = DefaultPropertiesPersister.trimLeadingWhitespace(value);
            ((Hashtable)props).put(DefaultPropertiesPersister.unescape(key), DefaultPropertiesPersister.unescape(value));
        }
        return;
    }

    private static boolean hasLength(String str) {
        return str != null && str.length() > 0;
    }

    private static String trimLeadingWhitespace(String str) {
        if (!DefaultPropertiesPersister.hasLength(str)) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str);
        while (buf.length() > 0 && Character.isWhitespace(buf.charAt(0))) {
            buf.deleteCharAt(0);
        }
        return buf.toString();
    }

    private static String trimTrailingWhitespace(String str) {
        if (!DefaultPropertiesPersister.hasLength(str)) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str);
        while (buf.length() > 0 && Character.isWhitespace(buf.charAt(buf.length() - 1))) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    private static boolean endsWithContinuationMarker(String line) {
        boolean evenSlashCount = true;
        for (int index = line.length() - 1; index >= 0 && line.charAt(index) == '\\'; --index) {
            evenSlashCount = !evenSlashCount;
        }
        return !evenSlashCount;
    }

    private static String unescape(String str) {
        StringBuffer outBuffer = new StringBuffer(str.length());
        int index = 0;
        while (index < str.length()) {
            int c2;
            if ((c2 = str.charAt(index++)) == 92) {
                if ((c2 = str.charAt(index++)) == 116) {
                    c2 = 9;
                } else if (c2 == 114) {
                    c2 = 13;
                } else if (c2 == 110) {
                    c2 = 10;
                } else if (c2 == 102) {
                    c2 = 12;
                }
            }
            outBuffer.append((char)c2);
        }
        return outBuffer.toString();
    }

    private static String escape(String str, boolean isKey) {
        int len = str.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int index = 0; index < len; ++index) {
            char c2 = str.charAt(index);
            switch (c2) {
                case ' ': {
                    if (index == 0 || isKey) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append("\\\\");
                    continue block8;
                }
                case '\t': {
                    outBuffer.append("\\t");
                    continue block8;
                }
                case '\n': {
                    outBuffer.append("\\n");
                    continue block8;
                }
                case '\r': {
                    outBuffer.append("\\r");
                    continue block8;
                }
                case '\f': {
                    outBuffer.append("\\f");
                    continue block8;
                }
                default: {
                    if ("=: \t\r\n\f#!".indexOf(c2) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(c2);
                }
            }
        }
        return outBuffer.toString();
    }
}

