/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.impl;

import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.crucible.spi.TxTemplate;
import com.atlassian.crucible.spi.data.CommentData;
import com.atlassian.crucible.spi.data.FisheyeReviewItemData;
import com.atlassian.crucible.spi.data.GeneralCommentData;
import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.crucible.spi.data.ReviewItemData;
import com.atlassian.crucible.spi.data.VersionedLineCommentData;
import com.atlassian.crucible.spi.impl.Utils;
import com.atlassian.crucible.spi.services.ReviewService;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.FileRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.PermaIdFormatException;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.RevisionComment;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.model.managers.PatchManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.RevisionCommentManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.crucible.upload.UploadItem;
import com.cenqua.crucible.upload.UploadManager;
import com.cenqua.crucible.util.PatchReviewCreationHelper;
import com.cenqua.crucible.view.ReviewFilters;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RevInfoKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="reviewService")
public class DefaultReviewService
implements ReviewService {
    private TxTemplate txTemplate;
    private ProjectManager projectManager;
    private Map<Integer, ReviewData.State> stateMap;

    @Autowired
    public DefaultReviewService(TxTemplate txTemplate, ProjectManager projectManager) {
        this.txTemplate = txTemplate;
        this.projectManager = projectManager;
    }

    @Override
    public ReviewData createReview(final ReviewData reviewData) {
        return this.txTemplate.execute(new TxCallback<ReviewData>(){

            @Override
            public ReviewData doInTransaction(TransactionStatus status) {
                Review review = DefaultReviewService.this.createReviewFromReviewData(reviewData);
                return reviewData;
            }
        });
    }

    @Override
    public ReviewData createReviewFromPatch(final ReviewData reviewData, final String patch) {
        return this.txTemplate.execute(new TxCallback<ReviewData>(){

            @Override
            public ReviewData doInTransaction(TransactionStatus status) {
                Review review = DefaultReviewService.this.createReviewFromReviewData(reviewData);
                try {
                    UploadItem ui = UploadManager.createUploadItemFromContent(Utils.getUserByName(DefaultReviewService.this.txTemplate.getEffectivePrincipal().getUserName()), review.getPermaId() + "-patch.txt", patch.trim(), "text/plain", "patch for review " + review.getPermaId());
                    Patch p = PatchManager.createPatch(ui);
                    p.setReview(review);
                    PatchReviewCreationHelper.addAllPatchRevsToReview(p, review);
                    return reviewData;
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        });
    }

    private Review createReviewFromReviewData(ReviewData reviewData) {
        Project project = this.projectManager.getProjectByKey(reviewData.getProjectKey());
        if (project == null) {
            throw new RuntimeException("No project found with key " + reviewData.getProjectKey());
        }
        this.requirePermission("action:createReview", project);
        Review review = ReviewManager.createReview(this.projectManager, project, reviewData.getName());
        review.setDescription(reviewData.getDescription());
        review.setAuthor(Utils.getUserByName(reviewData.getAuthor()));
        review.setModerator(Utils.getUserByName(reviewData.getAuthor()));
        review.setCreator(Utils.getUserByName(reviewData.getAuthor()));
        review.setRepoName(reviewData.getRepoName());
        reviewData.setPermaIdAsString(review.getPermaId());
        return review;
    }

    @Override
    public List<ReviewData> getAllReviews() {
        return this.txTemplate.execute(new TxCallback<List<ReviewData>>(){

            @Override
            public List<ReviewData> doInTransaction(TransactionStatus status) {
                ArrayList<ReviewData> reviewDataList = new ArrayList<ReviewData>();
                Collection<Review> reviews = ReviewManager.getReviews();
                for (Review r : reviews) {
                    if (!DefaultReviewService.this.testReviewPermission("action:viewReview", r)) continue;
                    reviewDataList.add(DefaultReviewService.this.buildReviewData(r));
                }
                return reviewDataList;
            }
        });
    }

    @Override
    public ReviewData getReview(final PermId<ReviewData> id) {
        return this.txTemplate.execute(new TxCallback<ReviewData>(){

            @Override
            public ReviewData doInTransaction(TransactionStatus status) {
                try {
                    Review review = ReviewManager.getReviewByPermaId(id.getId());
                    if (review == null) {
                        throw new RuntimeException("No review exists with permId '" + id.getId() + "'");
                    }
                    DefaultReviewService.this.requireReviewPermission("action:viewReview", review);
                    return DefaultReviewService.this.buildReviewData(review);
                }
                catch (PermaIdFormatException e2) {
                    throw new RuntimeException(e2);
                }
            }
        });
    }

    @Override
    public List<ReviewData> getReviewsInStates(final ReviewData.State[] states) {
        return this.txTemplate.execute(new TxCallback<List<ReviewData>>(){

            @Override
            public List<ReviewData> doInTransaction(TransactionStatus status) {
                ArrayList<ReviewData> reviewDataList = new ArrayList<ReviewData>();
                String[] statesAsStrings = new String[states.length];
                int i2 = 0;
                for (ReviewData.State s : states) {
                    statesAsStrings[i2++] = s.toString();
                }
                Collection<Review> reviews = ReviewManager.getReviewsInStates(statesAsStrings);
                for (Review r : reviews) {
                    if (!DefaultReviewService.this.testReviewPermission("action:viewReview", r)) continue;
                    reviewDataList.add(DefaultReviewService.this.buildReviewData(r));
                }
                return reviewDataList;
            }
        });
    }

    private ReviewData buildReviewData(Review r) {
        return new ReviewData(r.getProject().getKey(), r.getName(), r.getDescription(), r.getAuthor().getUserName(), r.getModerator().getUserName(), r.getCreator().getUserName(), r.getRepoName(), r.getPermaId(), this.modelStateToDataState(r.getState()), r.getParentReview() == null ? null : new PermId(r.getParentReview().getPermaId()));
    }

    private ReviewData.State modelStateToDataState(State state) {
        ReviewData.State dataState;
        if (this.stateMap == null) {
            this.stateMap = new HashMap<Integer, ReviewData.State>();
            this.stateMap.put(StateManager.States.DRAFT_STATE.ordinal(), ReviewData.State.Draft);
            this.stateMap.put(StateManager.States.APPROVAL_STATE.ordinal(), ReviewData.State.Approval);
            this.stateMap.put(StateManager.States.REVIEW_STATE.ordinal(), ReviewData.State.Review);
            this.stateMap.put(StateManager.States.SUMMARIZE_STATE.ordinal(), ReviewData.State.Summarize);
            this.stateMap.put(StateManager.States.CLOSED_STATE.ordinal(), ReviewData.State.Closed);
            this.stateMap.put(StateManager.States.DEAD_STATE.ordinal(), ReviewData.State.Dead);
            this.stateMap.put(StateManager.States.REJECTED_STATE.ordinal(), ReviewData.State.Rejected);
            this.stateMap.put(StateManager.States.NONE_STATE.ordinal(), ReviewData.State.Unknown);
        }
        if ((dataState = this.stateMap.get(state.getStateType().ordinal())) == null) {
            throw new RuntimeException("Unknown state " + state.getVerbage());
        }
        return dataState;
    }

    @Override
    public ReviewItemData addFisheyeDiff(final PermId<ReviewData> id, final String repositoryName, final String fromPath, final String fromRevision, final String toPath, final String toRevision) {
        return this.txTemplate.execute(new TxCallback<ReviewItemData>(){

            @Override
            public ReviewItemData doInTransaction(TransactionStatus status) {
                try {
                    Review review = ReviewManager.getReviewByPermaId(id.getId());
                    DefaultReviewService.this.requireReviewPermission("action:modifyReviewFiles", review);
                    String sourceName = "FE:" + repositoryName;
                    RepositorySource source = (RepositorySource)SourceFactory.getSource(sourceName, DefaultReviewService.this.txTemplate.getEffectiveUserLogin());
                    FileRevision to = DefaultReviewService.this.getFileRevision(source, toPath, toRevision);
                    FileRevisionExtraInfo frxInfo = review.addFileRevision(to);
                    if (fromPath != null) {
                        FileRevision from = DefaultReviewService.this.getFileRevision(source, fromPath, fromRevision);
                        frxInfo.setFromRevision(from);
                    }
                    FisheyeReviewItemData newReview = new FisheyeReviewItemData(repositoryName, fromPath, fromRevision, toPath, toRevision);
                    newReview.setPermIdAsString(frxInfo.getPermaId());
                    return newReview;
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
        });
    }

    private FileRevision getFileRevision(RepositorySource source, String path, String revision) throws DbException {
        com.cenqua.fisheye.rep.FileRevision fe = source.getRepoEngine().getRevisionCache().getFileRevision(new RevInfoKey(new Path(path), revision));
        if (fe == null) {
            throw new RuntimeException("Couldn't find revision with path '" + path + "' and revision '" + revision + "' in repository '" + source.getSourceName() + "'.");
        }
        return FileRevisionManager.createRevision(source.getSourceName(), fe);
    }

    @Override
    public void removeReviewItem(final PermId<ReviewData> reviewId, final PermId<ReviewItemData> itemId) {
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws PermaIdFormatException, DbException {
                Review review = ReviewManager.getReviewByPermaId(reviewId.getId());
                DefaultReviewService.this.requireReviewPermission("action:modifyReviewFiles", review);
                FileRevisionExtraInfo frx = FRXManager.getByPermaId(itemId.getId());
                review.removeFRX(frx);
                return null;
            }
        });
    }

    @Override
    public List<ReviewItemData> getReviewItemsForReview(final PermId<ReviewData> id) {
        return this.txTemplate.execute(new TxCallback<List<ReviewItemData>>(){

            @Override
            public List<ReviewItemData> doInTransaction(TransactionStatus status) throws PermaIdFormatException, DbException {
                Review review = ReviewManager.getReviewByPermaId(id.getId());
                DefaultReviewService.this.requireReviewPermission("action:viewReview", review);
                List<FileRevisionExtraInfo> frxs = review.getFrxs();
                ArrayList<ReviewItemData> data = new ArrayList<ReviewItemData>(frxs.size());
                for (FileRevisionExtraInfo frx : frxs) {
                    data.add(DefaultReviewService.this.buildReviewItemData(frx));
                }
                return data;
            }
        });
    }

    private FisheyeReviewItemData buildReviewItemData(FileRevisionExtraInfo frx) {
        return new FisheyeReviewItemData(frx.getFileRevision().getSource() != null ? frx.getFileRevision().getSource().getSourceIdentifier() : "", frx.getFromRevision() != null ? frx.getFromRevision().getPath() : "", frx.getFromRevision() != null ? frx.getFromRevision().getRevisionName() : "", frx.getFileRevision().getPath(), frx.getFileRevision().getRevisionName(), frx.getPermaId());
    }

    @Override
    public VersionedLineCommentData addComment(final PermId<ReviewItemData> id, final VersionedLineCommentData comment) {
        return this.txTemplate.execute(new TxCallback<VersionedLineCommentData>(){

            @Override
            public VersionedLineCommentData doInTransaction(TransactionStatus status) throws PermaIdFormatException, DbException {
                FileRevisionExtraInfo frx = FRXManager.getByPermaId(id.getId());
                DefaultReviewService.this.requireReviewPermission("action:commentOnReview", frx.getReview());
                Comment c2 = DefaultReviewService.this.createComment(frx.getReview(), comment);
                RevisionComment rc = RevisionCommentManager.createAndAddRevisionComment(c2, frx, frx.getFileRevision());
                rc.setCreateDate(comment.getCreateDate());
                rc.setLineRange(comment.getToLineRange());
                if (frx.getFromRevision() != null && comment.getFromLineRange() != null) {
                    rc = RevisionCommentManager.createAndAddRevisionComment(c2, frx, frx.getFromRevision());
                    rc.setCreateDate(comment.getCreateDate());
                    rc.setLineRange(comment.getFromLineRange());
                }
                comment.setPermaIdAsString(c2.getPermaId());
                return comment;
            }
        });
    }

    @Override
    public GeneralCommentData addGeneralComment(final PermId<ReviewData> id, final GeneralCommentData comment) {
        return this.txTemplate.execute(new TxCallback<GeneralCommentData>(){

            @Override
            public GeneralCommentData doInTransaction(TransactionStatus status) throws PermaIdFormatException, DbException {
                Review review = ReviewManager.getReviewByPermaId(id.getId());
                DefaultReviewService.this.requireReviewPermission("action:commentOnReview", review);
                Comment c2 = DefaultReviewService.this.createComment(review, comment);
                review.addComment(c2);
                comment.setPermaIdAsString(c2.getPermaId());
                return comment;
            }
        });
    }

    private Comment createComment(Review review, CommentData comment) {
        Comment c2 = CommentManager.createComment(comment.getMessage(), review, Utils.getUserByName(comment.getUser()));
        c2.setCreateDate(comment.getCreateDate());
        c2.setDefectApproved(comment.isDefectApproved());
        c2.setDefectRaised(comment.isDefectRaised());
        c2.setDraft(comment.isDraft());
        return c2;
    }

    @Override
    public List<GeneralCommentData> getGeneralComments(final PermId<ReviewData> id) {
        return this.txTemplate.execute(new TxCallback<List<GeneralCommentData>>(){

            @Override
            public List<GeneralCommentData> doInTransaction(TransactionStatus status) throws PermaIdFormatException {
                Review review = ReviewManager.getReviewByPermaId(id.getId());
                DefaultReviewService.this.requireReviewPermission("action:viewReview", review);
                Set<Comment> comments = review.getComments();
                ArrayList<GeneralCommentData> commentDatas = new ArrayList<GeneralCommentData>(comments.size());
                for (Comment c2 : comments) {
                    commentDatas.add(DefaultReviewService.this.buildGeneralCommentData(c2));
                }
                return commentDatas;
            }
        });
    }

    @Override
    public List<VersionedLineCommentData> getVersionedComments(final PermId<ReviewItemData> id) {
        return this.txTemplate.execute(new TxCallback<List<VersionedLineCommentData>>(){

            @Override
            public List<VersionedLineCommentData> doInTransaction(TransactionStatus status) throws PermaIdFormatException, DbException {
                FileRevisionExtraInfo frx = FRXManager.getByPermaId(id.getId());
                DefaultReviewService.this.requireReviewPermission("action:viewReview", frx.getReview());
                ArrayList<VersionedLineCommentData> data = new ArrayList<VersionedLineCommentData>();
                for (CommentManager.CommentPair comment : frx.getCommentPairs()) {
                    data.add(DefaultReviewService.this.buildVersionedLineCommentData(comment));
                }
                return data;
            }
        });
    }

    @Override
    public List<VersionedLineCommentData> getAllRevisionComments(final PermId<ReviewData> id) {
        return this.txTemplate.execute(new TxCallback<List<VersionedLineCommentData>>(){

            @Override
            public List<VersionedLineCommentData> doInTransaction(TransactionStatus status) throws PermaIdFormatException, DbException {
                Review review = ReviewManager.getReviewByPermaId(id.getId());
                DefaultReviewService.this.requireReviewPermission("action:viewReview", review);
                ArrayList<VersionedLineCommentData> data = new ArrayList<VersionedLineCommentData>();
                List<RevisionComment> revisionComments = CommentManager.getRevisionComments(review);
                Collection<CommentManager.CommentPair> commentPairs = CommentManager.createCommentPairs(revisionComments);
                for (CommentManager.CommentPair comment : commentPairs) {
                    data.add(DefaultReviewService.this.buildVersionedLineCommentData(comment));
                }
                return data;
            }
        });
    }

    @Override
    public List<ReviewData> getUncompletedReviewsForUser(final String userName) {
        return this.txTemplate.execute(new TxCallback<List<ReviewData>>(){

            @Override
            public List<ReviewData> doInTransaction(TransactionStatus status) {
                ArrayList<ReviewData> reviewDataList = new ArrayList<ReviewData>();
                ReviewFilters reviewFilters = new ReviewFilters(Utils.getUserByName(userName));
                List reviews = ReviewManager.getReviewsAsRolesInStates(reviewFilters.getToReviewFilterDef(), null, "review", null);
                for (Review r : reviews) {
                    if (!DefaultReviewService.this.testReviewPermission("action:viewReview", r)) continue;
                    reviewDataList.add(DefaultReviewService.this.buildReviewData(r));
                }
                return reviewDataList;
            }
        });
    }

    @Override
    public FisheyeReviewItemData getReviewItem(final PermId<ReviewData> reviewDataPermId, final PermId<ReviewItemData> reviewItemDataPermId) {
        return this.txTemplate.execute(new TxCallback<FisheyeReviewItemData>(){

            @Override
            public FisheyeReviewItemData doInTransaction(TransactionStatus status) throws PermaIdFormatException, DbException {
                Review review = ReviewManager.getReviewByPermaId(reviewDataPermId.getId());
                DefaultReviewService.this.requireReviewPermission("action:viewReview", review);
                for (FileRevisionExtraInfo frx : review.getFrxs()) {
                    if (!frx.getPermaId().equals(reviewItemDataPermId.getId())) continue;
                    return DefaultReviewService.this.buildReviewItemData(frx);
                }
                return null;
            }
        });
    }

    @Override
    public ReviewData changeState(final PermId<ReviewData> id, final ReviewService.Action action) {
        return this.txTemplate.execute(new TxCallback<ReviewData>(){

            @Override
            public ReviewData doInTransaction(TransactionStatus status) throws Exception, DbException {
                Review review = ReviewManager.getReviewByPermaId(id.getId());
                String userName = DefaultReviewService.this.txTemplate.getEffectivePrincipal().getUserName();
                CrucibleUser user = CrucibleUserManager.getUserByName(userName);
                if (user == null) {
                    throw new RuntimeException("The user named '" + userName + "' is not a Crucible user.");
                }
                review.changeState(action.getActionString(), user);
                return DefaultReviewService.this.buildReviewData(review);
            }
        });
    }

    @Override
    public List<ReviewData> getChildReviews(final PermId<ReviewData> id) {
        return this.txTemplate.execute(new TxCallback<List<ReviewData>>(){

            @Override
            public List<ReviewData> doInTransaction(TransactionStatus status) throws PermaIdFormatException {
                Review review = ReviewManager.getReviewByPermaId(id.getId());
                DefaultReviewService.this.requireReviewPermission("action:viewReview", review);
                ArrayList<ReviewData> reviewDataList = new ArrayList<ReviewData>();
                List reviews = review.getChildReviews();
                for (Review r : reviews) {
                    if (!DefaultReviewService.this.testReviewPermission("action:viewReview", r)) continue;
                    reviewDataList.add(DefaultReviewService.this.buildReviewData(r));
                }
                return reviewDataList;
            }
        });
    }

    private VersionedLineCommentData buildVersionedLineCommentData(CommentManager.CommentPair c2) {
        FileRevisionExtraInfo frx = c2.getRevisionComment() != null ? c2.getRevisionComment().getFrx() : c2.getFromRevisionComment().getFrx();
        return new VersionedLineCommentData(new PermId<ReviewItemData>(frx.getPermaId()), c2.getComment().getMessage(), c2.getComment().isDraft(), c2.getComment().isDeleted(), c2.getComment().isDefectRaised(), c2.getComment().isDefectApproved(), c2.getComment().getUser().getUserName(), c2.getComment().getCreateDate(), c2.getFromRevisionComment() == null ? null : c2.getFromRevisionComment().getLineRange(), c2.getRevisionComment().getLineRange(), c2.getComment().getPermaId());
    }

    private GeneralCommentData buildGeneralCommentData(Comment c2) {
        return new GeneralCommentData(c2.getMessage(), c2.isDraft(), c2.isDeleted(), c2.isDefectRaised(), c2.isDefectApproved(), c2.getUser().getUserName(), c2.getCreateDate(), c2.getPermaId());
    }

    @Override
    public Set<String> getReviewers(final PermId<ReviewData> id) {
        return this.txTemplate.execute(new TxCallback<Set<String>>(){

            @Override
            public Set<String> doInTransaction(TransactionStatus status) throws PermaIdFormatException {
                Review review = ReviewManager.getReviewByPermaId(id.getId());
                DefaultReviewService.this.requireReviewPermission("action:viewReview", review);
                HashSet<String> reviewers = new HashSet<String>();
                for (CrucibleUser u : review.getReviewers()) {
                    reviewers.add(u.getUserName());
                }
                return reviewers;
            }
        });
    }

    @Override
    public void addReviewer(final PermId<ReviewData> id, final String userName) {
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws Exception, DbException {
                Review review = ReviewManager.getReviewByPermaId(id.getId());
                CrucibleUser user = CrucibleUserManager.getUserByName(userName);
                if (user == null) {
                    throw new RuntimeException("The user named '" + userName + "' is not a Crucible user.");
                }
                review.addReviewer(user);
                return null;
            }
        });
    }

    private boolean testReviewPermission(String actionName, Project project) {
        return ReviewUtil.principalCanDoProjectAction(this.txTemplate.getEffectivePrincipal(), actionName, project);
    }

    private boolean testReviewPermission(String actionName, Review review) {
        return ReviewUtil.principalCanDoReviewAction(this.txTemplate.getEffectivePrincipal(), actionName, review);
    }

    private void requirePermission(String actionName, Project project) {
        if (!this.testReviewPermission(actionName, project)) {
            UserActionManager.Action a2 = UserActionManager.getInstance().getAction(actionName);
            throw new RuntimeException("You do not have permission to " + a2.getDisplayName() + " in project " + project.getName());
        }
    }

    private void requireReviewPermission(String actionName, Review review) {
        if (!this.testReviewPermission(actionName, review)) {
            UserActionManager.Action a2 = UserActionManager.getInstance().getAction(actionName);
            throw new RuntimeException("You do not have permission to " + a2.getDisplayName() + " the review " + review.toString());
        }
    }
}

