/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.plugin.webresource;

import com.atlassian.fisheye.plugin.FisheyePluginManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="webResourceIntegration")
public class FisheyeWebResourceIntegration
implements WebResourceIntegration {
    private FisheyePluginManager pluginManager;
    private ThreadLocal<Map> requestCache = new ThreadLocal();
    private static ThreadLocal<String> contextPathThreadLocal = new ThreadLocal();

    @Autowired
    public FisheyeWebResourceIntegration(FisheyePluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public PluginAccessor getPluginAccessor() {
        return this.pluginManager;
    }

    public Map getRequestCache() {
        HashMap map = this.requestCache.get();
        if (map == null) {
            map = new HashMap();
            this.requestCache.set(map);
        }
        return map;
    }

    public String getSystemCounter() {
        return "1";
    }

    public String getSystemBuildNumber() {
        return "build-307";
    }

    public static void setContextPath(String contextPath) {
        contextPathThreadLocal.set(contextPath);
    }

    public String getBaseUrl() {
        String contextPath = contextPathThreadLocal.get();
        if (contextPath == null) {
            throw new Error("Null contextPath");
        }
        return contextPath;
    }
}

