/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions;

import com.cenqua.crucible.actions.BaseAction;
import com.cenqua.crucible.filters.CrucibleFilter;

public abstract class PagedSearch
extends BaseAction {
    protected int page = 1;
    protected String filterParams;
    protected String query;
    protected static final int PAGE_LENGTH = 50;
    protected static final int MAX_PAGE_EXTEND_PERCENT = 10;
    private int pageLength = 50;

    public boolean isNoResults() {
        return this.getNumberOfResults() == 0;
    }

    public boolean isSinglePage() {
        return this.getNumberOfResults() < this.getMaxPageLength();
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query.trim();
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public void setPageLength(int pageLength) {
        this.pageLength = pageLength;
    }

    private int getMaxPageExtend() {
        return this.getPageLength() * 10 / 100;
    }

    private int getMaxPageLength() {
        return this.getPageLength() + this.getMaxPageExtend();
    }

    public String getSearchParams() {
        if (this.filterParams == null) {
            String qry = CrucibleFilter.getRequest().getQueryString();
            this.filterParams = qry == null ? null : qry.replaceAll("&page=[0-9]*", "");
        }
        return this.filterParams;
    }

    public String getFilterParams() {
        return "X";
    }

    public int getStart() {
        return (this.page - 1) * this.getPageLength();
    }

    public int getEnd() {
        int end = this.getStart() + this.getPageLength();
        int n = this.getNumberOfResults();
        if (end + this.getMaxPageExtend() > n) {
            end = n;
        }
        return end;
    }

    public abstract int getNumberOfResults();

    public int getNumberOfPages() {
        int d2;
        int n = this.getNumberOfResults();
        if (n > (d2 = this.getMaxPageExtend())) {
            n -= d2;
        }
        return n / this.getPageLength();
    }

    public boolean getSomeResultsHidden() {
        return false;
    }
}

