/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions;

import com.cenqua.crucible.actions.PagedSearch;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.view.ReviewFilterState;
import com.cenqua.crucible.view.RowDetail;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewQueryAction
extends PagedSearch {
    private ReviewFilterState filterState = new ReviewFilterState(this.getCurrentUser(), "toReview", "ReviewQueryAction");

    public String execute() {
        this.filterState.setFilterFromSession();
        return "success";
    }

    public boolean isNoReviews() {
        return this.getCountAllReviews() == 0L;
    }

    public String[] getState() {
        return this.filterState.getState();
    }

    public void setState(String[] state) {
        this.filterState.setState(state);
    }

    public String getAuthor() {
        return this.filterState.getAuthor();
    }

    public void setAuthor(String author) {
        this.filterState.setAuthor(author);
    }

    public String getModerator() {
        return this.filterState.getModerator();
    }

    public void setModerator(String moderator) {
        this.filterState.setModerator(moderator);
    }

    public String getCreator() {
        return this.filterState.getCreator();
    }

    public void setCreator(String creator) {
        this.filterState.setCreator(creator);
    }

    public String getReviewer() {
        return this.filterState.getReviewer();
    }

    public void setReviewer(String reviewer) {
        this.filterState.setReviewer(reviewer);
    }

    public String getTitle() {
        return this.filterState.getTitle();
    }

    public void setTitle(String title) {
        this.filterState.setTitle(title);
    }

    public boolean getOrRoles() {
        return this.filterState.getOrRoles();
    }

    public void setOrRoles(boolean orRoles) {
        this.filterState.setOrRoles(orRoles);
    }

    public String getComplete() {
        return this.filterState.getComplete();
    }

    public void setComplete(String complete) {
        this.filterState.setComplete(complete);
    }

    public String getFilterName() {
        return this.filterState.getFilterName();
    }

    public String getFilterDescription() {
        return this.filterState.getFilterDescription();
    }

    public void setFilter(String filter) {
        this.filterState.setFilter(filter);
    }

    public String getFilter() {
        return this.filterState.getFilter();
    }

    public String getProject() {
        Project project = this.filterState.getProject();
        return project == null ? null : project.getKey();
    }

    public void setProject(String projectKey) {
        this.filterState.setProject(this.projectManager.getProjectByKey(projectKey));
    }

    public List<Project> getProjects() {
        return this.projectManager.getAllProjects();
    }

    public Collection getStates() {
        return this.filterState.getStates();
    }

    @Override
    public String getFilterParams() {
        return this.filterState.getFilterParams();
    }

    public List<RowDetail> getFilteredReviewDetails() {
        return this.filterState.getFilteredReviewDetails(this);
    }

    public Iterator getReviewDetails() {
        return this.filterState.getReviewDetailsMap().values().iterator();
    }

    @Override
    public int getNumberOfResults() {
        return this.filterState.getNumberOfResults();
    }

    public long getCountToReview() {
        return this.filterState.countFilteredReviews("toReview");
    }

    public long getCountRequireMyApproval() {
        return this.filterState.countFilteredReviews("requireMyApproval");
    }

    public int getCountToSummarize() {
        return this.filterState.countFilteredReviewResults("toSummarize");
    }

    public int getCountOutForReview() {
        return this.filterState.countFilteredReviewResults("outForReview");
    }

    public long getCountDrafts() {
        return this.filterState.countFilteredReviews("drafts");
    }

    public long getCountClosed() {
        return this.filterState.countFilteredReviews("closed");
    }

    public long getCountOpen() {
        return this.filterState.countFilteredReviews("open");
    }

    public long getCountTrash() {
        return this.filterState.countFilteredReviews("trash");
    }

    public long getCountAllReviews() {
        return this.filterState.countFilteredReviews("allReviews");
    }

    public long getCountAllOpenReviews() {
        return this.filterState.countFilteredReviews("allOpenReviews");
    }

    public long getCountAllClosedReviews() {
        return this.filterState.countFilteredReviews("allClosedReviews");
    }

    @Override
    public boolean getSomeResultsHidden() {
        if (this.filterState.getFilter().equals("custom")) {
            return false;
        }
        return (long)this.getNumberOfResults() != this.filterState.countFilteredReviews(this.filterState.getFilter());
    }
}

