/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions;

import com.cenqua.crucible.actions.ReviewBaseAction;
import com.cenqua.crucible.model.managers.LogManager;

public class ReviewSummaryAction
extends ReviewBaseAction {
    private String summary;
    private String command = "";

    private void log(String message) {
        LogManager.log(this.getCurrentUser().getDisplayName() + " altering " + this.getReview().getPermaId() + message);
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public String getError() {
        return "error.unauthorized.summary";
    }

    public String getErrorDescription() {
        return "error.unauthorized.summary.description";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        if (this.canSummarize()) {
            try {
                this.beginTx();
                if (this.command == null) {
                    this.command = "success";
                } else if (this.summary != null && !this.summary.equals("")) {
                    this.log(" changing summary to \"" + this.summary + "\"");
                    this.getReview().setSummary(this.summary);
                }
                this.commitTx();
                String string = this.command;
                return string;
            }
            finally {
                this.rollbackTxIfNotCommited();
            }
        }
        return "AccessError";
    }
}

