/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.admin.permschemes;

import com.atlassian.crucible.spi.impl.Utils;
import com.cenqua.crucible.actions.admin.project.UserData;
import com.cenqua.crucible.model.managers.UserActionManager;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionData {
    private boolean isAnonymousUsers;
    private boolean isAllUsers;
    private Set<UserData> users = new HashSet<UserData>();
    private Set<String> groups = new HashSet<String>();
    private Set<String> roles = new HashSet<String>();
    private final UserActionManager.Action action;

    ActionData(UserActionManager.Action action) {
        this.action = action;
    }

    ActionData(String name) {
        this.action = UserActionManager.getInstance().getAction(name);
    }

    public String getName() {
        return this.action.getName();
    }

    public String getDisplayName() {
        return this.action.getDisplayName();
    }

    public String getDescription() {
        return this.action.getPermissionDescription();
    }

    public boolean isAnonymousUsers() {
        return this.isAnonymousUsers;
    }

    public void setAnonymousUsers(boolean anonymousUsers) {
        this.isAnonymousUsers = anonymousUsers;
    }

    public boolean isAllUsers() {
        return this.isAllUsers;
    }

    public void setAllUsers(boolean allUsers) {
        this.isAllUsers = allUsers;
    }

    public Set<UserData> getUsers() {
        return this.users;
    }

    public void setUsers(Set<UserData> users) {
        this.users = users;
    }

    public void addUser(String userName) {
        this.users.add(Utils.crucibleUserToUserData(Utils.getUserByName(userName)));
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public void addGroup(String groupName) {
        this.groups.add(groupName);
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public void addRole(String roleName) {
        this.roles.add(roleName);
    }
}

