/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.admin.permschemes;

import com.atlassian.crucible.spi.TxCallback;
import com.cenqua.crucible.actions.BaseAction;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.fisheye.util.StringUtil;
import org.springframework.transaction.TransactionStatus;

public class RenamePermSchemeAction
extends BaseAction {
    private String oldPSName;
    private String newPSName;

    public String getOldPSName() {
        return this.oldPSName;
    }

    public void setOldPSName(String oldPSName) {
        this.oldPSName = oldPSName;
    }

    public String getNewPSName() {
        return this.newPSName;
    }

    public void setNewPSName(String newPSName) {
        this.newPSName = newPSName;
    }

    public String getPsName() {
        return this.newPSName;
    }

    public String execute() throws Exception {
        return this.txTemplate.execute(new TxCallback<String>(){

            @Override
            public String doInTransaction(TransactionStatus status) throws Exception {
                PermissionScheme ps = PermissionManager.findPS(RenamePermSchemeAction.this.oldPSName);
                if (ps == null) {
                    RenamePermSchemeAction.this.addActionError("Could not find Permission Scheme.");
                    return "error";
                }
                if (StringUtil.nullOrEmpty(RenamePermSchemeAction.this.newPSName)) {
                    RenamePermSchemeAction.this.addActionError("Permission Scheme name must not be blank.");
                    return "error";
                }
                PermissionScheme newPS = PermissionManager.findPS(RenamePermSchemeAction.this.newPSName);
                if (newPS != null) {
                    RenamePermSchemeAction.this.addActionError("A Permission Scheme with that name exists.");
                    return "error";
                }
                ps.setName(RenamePermSchemeAction.this.newPSName);
                return "success";
            }
        });
    }
}

