/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.admin.project;

import com.cenqua.crucible.actions.admin.project.UserData;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectData {
    private int id;
    private String name;
    private String key;
    private Set<UserData> defaultReviewerUsers;
    private Set<UserData> allowedReviewerUsers;
    private Set<String> defaultReviewerGroups;
    private Set<String> allowedReviewerGroups;
    private UserData defaultModerator;
    private String defaultRepositoryName;
    private String permissionSchemeName;
    private boolean allowReviewersToJoin;

    public ProjectData() {
    }

    public ProjectData(int id, String name, String key, Set<UserData> defaultReviewerUsers, Set<String> defaultReviewerGroups, Set<UserData> allowedReviewerUsers, Set<String> allowedReviewerGroups, UserData defaultModerator, String defaultRepositoryName, String permissionSchemeName, boolean allowReviewersToJoin) {
        this.id = id;
        this.name = name;
        this.key = key;
        this.defaultReviewerUsers = defaultReviewerUsers;
        this.defaultReviewerGroups = defaultReviewerGroups;
        this.allowedReviewerUsers = allowedReviewerUsers;
        this.allowedReviewerGroups = allowedReviewerGroups;
        this.defaultModerator = defaultModerator;
        this.defaultRepositoryName = defaultRepositoryName;
        this.permissionSchemeName = permissionSchemeName;
        this.allowReviewersToJoin = allowReviewersToJoin;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setDefaultModerator(UserData defaultModerator) {
        this.defaultModerator = defaultModerator;
    }

    public void setDefaultRepositoryName(String defaultRepositoryName) {
        this.defaultRepositoryName = defaultRepositoryName;
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public UserData getDefaultModerator() {
        return this.defaultModerator;
    }

    public String getDefaultRepositoryName() {
        return this.defaultRepositoryName;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public String getPermissionSchemeName() {
        return this.permissionSchemeName;
    }

    public void setPermissionSchemeName(String permissionSchemeName) {
        this.permissionSchemeName = permissionSchemeName;
    }

    public boolean isAllowReviewersToJoin() {
        return this.allowReviewersToJoin;
    }

    public void setAllowReviewersToJoin(boolean allowReviewersToJoin) {
        this.allowReviewersToJoin = allowReviewersToJoin;
    }

    public List<Operation> getOperations() {
        if (this.id == 1) {
            return Arrays.asList(new Operation("Edit"));
        }
        return Arrays.asList(new Operation("Edit"), new Operation("Delete"));
    }

    public Set<UserData> getDefaultReviewerUsers() {
        return this.defaultReviewerUsers;
    }

    public void setDefaultReviewerUsers(Set<UserData> defaultReviewerUsers) {
        this.defaultReviewerUsers = defaultReviewerUsers;
    }

    public Set<UserData> getAllowedReviewerUsers() {
        return this.allowedReviewerUsers;
    }

    public void setAllowedReviewerUsers(Set<UserData> allowedReviewerUsers) {
        this.allowedReviewerUsers = allowedReviewerUsers;
    }

    public Set<String> getDefaultReviewerGroups() {
        return this.defaultReviewerGroups;
    }

    public void setDefaultReviewerGroups(Set<String> defaultReviewerGroups) {
        this.defaultReviewerGroups = defaultReviewerGroups;
    }

    public Set<String> getAllowedReviewerGroups() {
        return this.allowedReviewerGroups;
    }

    public void setAllowedReviewerGroups(Set<String> allowedReviewerGroups) {
        this.allowedReviewerGroups = allowedReviewerGroups;
    }

    public String getDefaultReviewerUsersAsString() {
        return this.collectionToCommaSepString(this.getDefaultReviewerUsers());
    }

    public String getDefaultReviewerGroupsAsString() {
        return this.collectionToCommaSepString(this.getDefaultReviewerGroups());
    }

    private String collectionToCommaSepString(Collection<?> it) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (Object u : it) {
            sb.append(sep);
            sb.append(u.toString());
            sep = ", ";
        }
        return sb.toString();
    }

    public class Operation {
        private String name;

        public Operation(String name) {
            this.name = name;
        }

        public String getOpName() {
            return this.name;
        }

        public String getOpParameters() {
            return "op=" + this.name + "&id=" + ProjectData.this.getId();
        }
    }
}

