/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.create;

import com.cenqua.crucible.actions.ReviewBaseAction;
import com.cenqua.crucible.filters.CrucibleFilter;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.tags.ReviewUtil;
import java.util.Set;

public class JoinReviewAction
extends ReviewBaseAction {
    private void log(String message) {
        LogManager.log(this.getCurrentUser().getDisplayName() + " altering " + this.getReview().getPermaId() + message);
    }

    public String getContextPath() {
        return CrucibleFilter.getRequest().getContextPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        try {
            this.beginTx();
            if (!ReviewUtil.isShowJoinReview(this.getReview(), this.getCurrentUser())) {
                this.commitTx();
                this.addActionError("Authorization error, contact " + this.getReview().getModerator().getDisplayName() + " to join this review.");
                String string = "error";
                return string;
            }
            if (this.getCurrentUser() == null) {
                this.commitTx();
                String string = "loginRequired";
                return string;
            }
            Set<CrucibleUser> reviewers = this.getReview().getActiveReviewers();
            if (!reviewers.contains(this.getCurrentUser())) {
                this.getReview().addReviewer(this.getCurrentUser());
                this.log(" adding reviewer " + this.getCurrentUser().getDisplayName());
                if (this.getReview().getState().isReviewState()) {
                    NotificationManager.INSTANCE.noteGeneralMsg(this.getReview(), this.getCurrentUser(), this.getCurrentUser(), "You have been added as a reviewer in review " + this.getPermaId());
                }
            }
            this.commitTx();
            String string = "success";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }
}

