/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.project;

import com.cenqua.crucible.actions.project.ReviewAgeBucketSegment;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.StateManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewAgeBucket {
    private final int maxAge;
    private int totalCount = 0;
    private final String description;
    private final Map<StateManager.States, Integer> counts = new HashMap<StateManager.States, Integer>();

    public ReviewAgeBucket(int maxAge, String description) {
        this.maxAge = maxAge;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public boolean isNoReviews() {
        return this.totalCount == 0;
    }

    public StateManager.States addReview(Review r) {
        Integer n;
        StateManager.States s = r.getState().getStateType();
        if (r.getCountActiveReviewers() == 0 && s.equals((Object)StateManager.States.REVIEW_STATE)) {
            s = StateManager.States.SUMMARIZE_STATE;
        }
        if ((n = this.counts.get((Object)s)) == null) {
            n = new Integer(1);
            this.counts.put(s, n);
        } else {
            this.counts.put(s, new Integer(n + 1));
        }
        ++this.totalCount;
        return s;
    }

    private int getCount(StateManager.States state) {
        Integer c2 = this.counts.get((Object)state);
        if (c2 == null) {
            return 0;
        }
        return c2;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    private int getDraftCount() {
        return this.getCount(StateManager.States.DRAFT_STATE);
    }

    public int getToReviewCount() {
        return this.getCount(StateManager.States.REVIEW_STATE);
    }

    public int getToSummariseCount() {
        return this.getCount(StateManager.States.SUMMARIZE_STATE);
    }

    public List<ReviewAgeBucketSegment> getSegments() {
        ArrayList<ReviewAgeBucketSegment> segs = new ArrayList<ReviewAgeBucketSegment>();
        segs.add(new ReviewAgeBucketSegment(this.getDraftCount(), "Draft"));
        segs.add(new ReviewAgeBucketSegment(this.getToReviewCount(), "Review"));
        segs.add(new ReviewAgeBucketSegment(this.getToSummariseCount(), "Summarise"));
        return segs;
    }
}

