/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.search.comment;

import com.cenqua.crucible.actions.PagedSearch;
import com.cenqua.crucible.actions.search.comment.CommentSearchData;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.reports.commentsDefects.DefectReportDO;
import com.cenqua.crucible.util.HqlUtil;
import com.cenqua.crucible.view.CommentDO;
import com.cenqua.crucible.view.StateDO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentSearchAction
extends PagedSearch {
    private List<CommentDO> results;
    private List<Comment> comments;
    private String[] selectedStates;
    private CommentSearchData searchData = new CommentSearchData();
    private Long numDefects;
    private Long numMajor;
    private List<DefectReportDO> defectReport;

    public String[] getSelectedStates() {
        return this.selectedStates;
    }

    public void setSelectedStates(String[] selectedStates) {
        this.selectedStates = selectedStates;
    }

    public List<CommentDO> getCommentDOs() {
        if (this.results == null) {
            List<Comment> comments = this.getComments().subList(this.getStart(), this.getEnd());
            CrucibleUser user = this.getCurrentUser();
            this.results = new LinkedList<CommentDO>();
            for (Comment comment : comments) {
                this.results.add(new CommentDO(comment, user));
            }
        }
        return this.results;
    }

    private List<Comment> getComments() {
        if (this.comments == null) {
            this.comments = new LinkedList<Comment>();
            this.comments.addAll(CommentManager.searchComments(this.getSearch(), "comment"));
        }
        return this.comments;
    }

    public Collection<StateDO> getStates() {
        List<State> states = StateManager.INSTANCE.getStates();
        LinkedList<StateDO> wrappedStates = new LinkedList<StateDO>();
        for (State state : states) {
            wrappedStates.add(new StateDO(state, this.selectedStates));
        }
        return wrappedStates;
    }

    @Override
    public int getNumberOfResults() {
        return this.getComments().size();
    }

    public CommentSearchData getSearch() {
        return this.searchData;
    }

    public void setSearch(CommentSearchData searchData) {
        this.searchData = searchData;
    }

    public Set<String> getMetricNames() {
        return this.searchData.getMetricsByName().keySet();
    }

    public long getCountDefectsInFilter() {
        if (this.numDefects == null) {
            if (this.getSearch().isComments() && !this.getSearch().isDefects()) {
                return 0L;
            }
            CommentSearchData sd = this.copySearchForCounts();
            sd.setDefects(true);
            List l = CommentManager.searchComments(sd, "count(distinct comment.id)");
            this.numDefects = HqlUtil.getCountFromSet(l);
        }
        return this.numDefects;
    }

    public List<DefectReportDO> getDefectClassificationReport() {
        if (this.defectReport == null) {
            this.defectReport = new ArrayList<DefectReportDO>();
            if (this.getSearch().isComments() && !this.getSearch().isDefects()) {
                return this.defectReport;
            }
            CommentSearchData sd = this.copySearchForCounts();
            sd.setDefects(true);
            Collection<CommentSearchData.MetricDO> mdos = this.getSearch().getMetrics();
            if (mdos != null) {
                for (CommentSearchData.MetricDO mdo : mdos) {
                    sd.setMetric(mdo.getId(), true);
                    List l = CommentManager.searchComments(sd, "count(distinct comment.id)");
                    this.defectReport.add(new DefectReportDO(mdo.getMetricName(), mdo.getFieldName(), HqlUtil.getCountFromSet(l)));
                    sd.setMetric(mdo.getId(), false);
                }
            }
        }
        return this.defectReport;
    }

    public long getCountMajorDefectsInFilter() {
        if (this.numMajor == null) {
            if (this.getSearch().isComments() && !this.getSearch().isDefects()) {
                return 0L;
            }
            CommentSearchData sd = this.copySearchForCounts();
            sd.setDefects(true);
            ArrayList<CommentSearchData.MetricDO> mdos = this.getSearch().getMetricsByName().get("rank");
            if (mdos != null) {
                for (CommentSearchData.MetricDO mdo : mdos) {
                    if (mdo.getFieldName().equals("Major")) {
                        sd.setMetric(mdo.getId(), true);
                    }
                    if (mdo.getFieldName().equals("Major") || !mdo.isSelected()) continue;
                    return 0L;
                }
            }
            List l = CommentManager.searchComments(sd, "count(distinct comment.id)");
            this.numMajor = HqlUtil.getCountFromSet(l);
        }
        return this.numMajor;
    }

    public long getCountOtherDefectsInFilter() {
        return this.getCountDefectsInFilter() - this.getCountMajorDefectsInFilter();
    }

    private CommentSearchData copySearchForCounts() {
        CommentSearchData sd = new CommentSearchData();
        sd.setAuthorName(this.getSearch().getAuthorName());
        sd.setProjectId(this.getSearch().getProjectId());
        sd.setState(this.getSearch().getState());
        sd.setText(this.getSearch().getText());
        sd.setPeriod(this.getSearch().getPeriod());
        sd.setPermaId(this.getSearch().getPermaId());
        ArrayList<Integer> mdos = new ArrayList<Integer>();
        for (CommentSearchData.MetricDO mdo : this.getSearch().getMetrics()) {
            if (!mdo.isSelected()) continue;
            mdos.add(mdo.getId());
        }
        sd.setMetric(mdos.toArray(new Integer[0]));
        return sd;
    }
}

