/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.fisheye;

import com.cenqua.crucible.fisheye.CrucibleLinker;
import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.crucible.CrucibleBridge;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.syntax.SyntaxDefinition;

public class CrucibleBridgeImplementation
implements CrucibleBridge {
    public CrucibleBridgeImplementation() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                NotificationManager.INSTANCE.stopNotifier();
                HibernateUtil.destroy();
            }
        });
    }

    public void logSysinfo() {
        Logs.CONSOLE.info((Object)"Crucible 1.5.4 (including FishEye 1.5.4) (build-307), Built on 2008-07-31");
    }

    public void startup() throws ConfigException {
        try {
            HibernateUtil.setUp();
            NotificationManager.INSTANCE.startNotifier();
            UserActionManager uam = UserActionManager.getInstance();
        }
        catch (CruDBException e2) {
            throw new ConfigException(e2);
        }
    }

    public SyntaxDefinition getPermalinkLinker() {
        return new CrucibleLinker();
    }

    public void createCrucibleUser(String userName) throws Exception {
        CrucibleUserManager.createUser(userName);
    }

    public void stop() {
        NotificationManager.INSTANCE.stopNotifier();
        HibernateUtil.closeSession();
        HibernateUtil.destroy();
    }
}

