/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.fisheye;

import com.cenqua.crucible.filters.CrucibleFilter;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.syntax.InputState;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.syntax.SyntaxDefinition;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrucibleLinker
extends SyntaxDefinition {
    public CrucibleLinker() {
        super("Crucible Linker");
    }

    @Override
    public void generateRegions(InputState input, RegionList outputRegions) {
        SyntaxDefinition def = this.getDef();
        def.generateRegions(input, outputRegions);
    }

    private SyntaxDefinition getDef() {
        StringBuffer buf = new StringBuffer("syntaxdef commentparser {\n");
        StringBuffer projectCodesRegex = new StringBuffer();
        List<String> codes = CrucibleFilter.hasContext() ? CrucibleFilter.getAllProjectCodes() : this.getAllProjectCodes();
        if (codes.isEmpty()) {
            projectCodesRegex.append("CR");
        } else {
            String sep = "";
            for (String code : codes) {
                projectCodesRegex.append(sep);
                projectCodesRegex.append(Pattern.quote(code));
                sep = "|";
            }
        }
        RepositoryConfig.appendCommentFormatterRules(buf, "(" + projectCodesRegex + ")-\\d+", AppConfig.getsConfig().getSiteURL() + "cru/${0}");
        buf.append("}");
        return SyntaxDefinition.parse(new StringReader(buf.toString()), new LinkedList<String>());
    }

    public List<String> getAllProjectCodes() {
        ProjectManager projectManager = (ProjectManager)SpringContext.getComponent("projectManager");
        return projectManager.getAllProjectKeys();
    }
}

