/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.VariableSubstituter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;

public class Config {
    public static Configuration configDB() throws CruDBException {
        return Config.configDB(null);
    }

    public static Configuration configDB(Properties feprops) throws CruDBException {
        try {
            String dbPath;
            File dbDir;
            if (feprops == null) {
                feprops = Config.getConfigProperties();
            }
            if (!(dbDir = new File(dbPath = feprops.getProperty("dbPath"))).exists()) {
                if (!dbDir.mkdirs()) {
                    throw new IOException("Can't create default database");
                }
                Configuration cfg = Config.getConfig(feprops);
                Connection conn = Config.getConnection(cfg);
                Config.createDB(cfg, conn);
                Config.close(conn);
            } else {
                Config.close(Config.checkUpVersion(feprops, 22));
            }
            return Config.getConfig(feprops);
        }
        catch (Exception e2) {
            throw new CruDBException(e2);
        }
    }

    private static Configuration getConfig(Properties feprops) {
        Configuration cfg = new Configuration();
        cfg.addResource("com/cenqua/crucible/model/CrucibleUser.hbm.xml");
        cfg.addResource("com/cenqua/crucible/model/Project.hbm.xml");
        cfg.addResource("com/cenqua/crucible/model/ReviewPermaId.hbm.xml");
        cfg.addResource("com/cenqua/crucible/model/Review.hbm.xml");
        cfg.addResource("com/cenqua/crucible/model/ReviewParticipant.hbm.xml");
        cfg.addResource("com/cenqua/crucible/model/LogItem.hbm.xml");
        cfg.addResource("com/cenqua/crucible/model/StateChangeLog.hbm.xml");
        cfg.addResource("com/cenqua/crucible/model/FileRevision.hbm.xml");
        cfg.addResource("com/cenqua/crucible/model/FileRevisionExtraInfo.hbm.xml");
        cfg.addResource("com/cenqua/crucible/model/Comment.hbm.xml");
        cfg.addResource("com/cenqua/crucible/model/RevisionComment.hbm.xml");
        cfg.addResource("com/cenqua/crucible/model/CustomField.hbm.xml");
        cfg.addResource("com/cenqua/crucible/upload/UploadItem.hbm.xml");
        cfg.addResource("com/cenqua/crucible/model/Patch.hbm.xml");
        cfg.addResource("com/cenqua/crucible/model/PermissionScheme.hbm.xml");
        cfg.addResource("com/cenqua/crucible/model/principalAssociations/Anonymous.hbm.xml");
        cfg.addResource("com/cenqua/crucible/model/principalAssociations/AllUser.hbm.xml");
        cfg.addResource("com/cenqua/crucible/model/principalAssociations/User.hbm.xml");
        cfg.addResource("com/cenqua/crucible/model/principalAssociations/Group.hbm.xml");
        cfg.addResource("com/cenqua/crucible/model/principalAssociations/Role.hbm.xml");
        cfg.addResource("com/cenqua/crucible/hibernate/DbVersion.hbm.xml");
        cfg.addResource("com/cenqua/crucible/configuration/metrics/MetricsConfigDef.hbm.xml");
        cfg.addResource("com/cenqua/crucible/notification/NotificationStore.hbm.xml");
        cfg.addResource("com/cenqua/crucible/notification/Recipient.hbm.xml");
        cfg.addResource("com/cenqua/crucible/fisheye/CrucibleReindexMessage.hbm.xml");
        cfg.setProperty("hibernate.show_sql", "false");
        cfg.setProperty("hibernate.connection.autocommit", "false");
        cfg.setProperty("hibernate.connection.driver_class", feprops.getProperty("jdbcDriverClass"));
        cfg.setProperty("hibernate.connection.url", feprops.getProperty("jdbcUrl"));
        cfg.setProperty("hibernate.connection.username", feprops.getProperty("jdbcUsername"));
        cfg.setProperty("hibernate.connection.password", feprops.getProperty("jdbcPassword"));
        cfg.setProperty("hibernate.dialect", feprops.getProperty("jdbcDialect"));
        cfg.setProperty("hibernate.c3p0.min_size", feprops.getProperty("c3p0.min_size"));
        cfg.setProperty("hibernate.c3p0.max_size", feprops.getProperty("c3p0.max_size"));
        cfg.setProperty("hibernate.c3p0.timeout", feprops.getProperty("c3p0.timeout"));
        cfg.setProperty("hibernate.c3p0.max_statements", feprops.getProperty("c3p0.max_statements"));
        cfg.setProperty("hibernate.bytecode.use_reflection_optimizer", "true");
        return cfg;
    }

    public static Properties getConfigProperties() {
        Properties feprops = new Properties();
        feprops.setProperty("fisheye.home", AppConfig.getAppHome().getAbsolutePath());
        feprops.setProperty("fisheye.inst", AppConfig.getInstanceDir().getAbsolutePath());
        feprops.setProperty("dbPath", VariableSubstituter.substituteRefs((CharSequence)"${fisheye.inst}/var/data/crudb", feprops));
        feprops.setProperty("jdbcUrl", VariableSubstituter.substituteRefs((CharSequence)"jdbc:hsqldb:file:${fisheye.inst}/var/data/crudb/crucible", feprops));
        feprops.setProperty("jdbcDriverClass", "org.hsqldb.jdbcDriver");
        feprops.setProperty("jdbcUsername", "sa");
        feprops.setProperty("jdbcPassword", "");
        feprops.setProperty("jdbcDialect", "org.hibernate.dialect.HSQLDialect");
        feprops.setProperty("jdbcIsolation", Integer.toString(2));
        feprops.setProperty("c3p0.min_size", "5");
        feprops.setProperty("c3p0.max_size", "20");
        feprops.setProperty("c3p0.timeout", "1800");
        feprops.setProperty("c3p0.max_statements", "50");
        return feprops;
    }

    public static Connection getConnection(Configuration cfg) throws ClassNotFoundException, SQLException {
        Class.forName(cfg.getProperty("hibernate.connection.driver_class"));
        Connection conn = DriverManager.getConnection(cfg.getProperty("hibernate.connection.url"), cfg.getProperty("hibernate.connection.username"), cfg.getProperty("hibernate.connection.password"));
        conn.setAutoCommit(false);
        return conn;
    }

    public static Connection getConnection(Properties cfg) throws ClassNotFoundException, SQLException {
        Class.forName(cfg.getProperty("jdbcDriverClass"));
        return DriverManager.getConnection(cfg.getProperty("jdbcUrl"), cfg.getProperty("jdbcUsername"), cfg.getProperty("jdbcPassword"));
    }

    private static void createDB(Configuration cfg, Connection conn) throws Exception {
        Logs.CONSOLE.info((Object)"Creating database");
        Class<?> dialectClass = Class.forName(cfg.getProperty("hibernate.dialect"));
        Dialect dialect = (Dialect)dialectClass.newInstance();
        Config.executeSqlScript(cfg.generateSchemaCreationScript(dialect), conn);
        conn.createStatement().executeUpdate("INSERT INTO CRUVERSION VALUES(1,22)");
        conn.commit();
    }

    private static void executeSqlScript(String[] array, Connection conn) throws SQLException {
        for (int i2 = 0; i2 < array.length; ++i2) {
            conn.createStatement().executeUpdate(array[i2]);
        }
    }

    private static void close(Connection conn) throws SQLException {
        Statement st = conn.createStatement();
        st.execute("SHUTDOWN");
        conn.commit();
        conn.close();
    }

    public static void runUpgrade(String ugFileName, Connection conn) throws CruDBException, IOException {
        BufferedReader in = null;
        HashMap<String, Object> vars = new HashMap<String, Object>();
        int lineNo = 0;
        try {
            String line;
            Logs.CONSOLE.info((Object)("Upgrading database from " + ugFileName));
            Logs.APP_LOG.info((Object)("Upgrading database from " + ugFileName));
            in = new BufferedReader(new FileReader(ugFileName));
            String sqlCommand = "";
            conn.setAutoCommit(false);
            while ((line = in.readLine()) != null && !line.equals("!stop")) {
                ++lineNo;
                if (!Config.blankOrComment(line)) {
                    sqlCommand = sqlCommand + line.replaceAll("\\\\n", "\n");
                }
                if (!sqlCommand.endsWith(";")) continue;
                if (sqlCommand.startsWith("$")) {
                    String[] var = sqlCommand.split("=");
                    ResultSet r = conn.createStatement().executeQuery(var[1].trim());
                    if (r.next()) {
                        vars.put(var[0].substring(1).trim(), r.getObject(1));
                    }
                    sqlCommand = "";
                    continue;
                }
                for (String s : vars.keySet()) {
                    String r = vars.get(s) == null ? "null" : vars.get(s).toString();
                    sqlCommand = sqlCommand.replaceAll("\\$" + s, r);
                }
                Logs.APP_LOG.debug((Object)("Update executing: " + sqlCommand));
                conn.createStatement().executeUpdate(sqlCommand);
                sqlCommand = "";
            }
            conn.commit();
        }
        catch (IOException e2) {
            throw new CruDBException("Trouble upgrading your db from " + ugFileName + ", line " + lineNo + ", please contact http://www.atlassian.com/support/", e2);
        }
        catch (SQLException e3) {
            throw new CruDBException("Trouble upgrading your db from " + ugFileName + ", line " + lineNo + ", please contact http://www.atlassian.com/support/", e3);
        }
        finally {
            try {
                conn.rollback();
            }
            catch (SQLException e4) {
                Logs.APP_LOG.error((Object)"Can't rollback database changes after error.", (Throwable)e4);
            }
            if (in != null) {
                in.close();
            }
        }
    }

    private static boolean blankOrComment(String str) {
        return str.trim().equals("") || str.startsWith("#");
    }

    public static Connection checkUpVersion(Properties feprops, int reqVersion) throws SQLException, IOException, CruDBException, ClassNotFoundException {
        Connection conn = Config.getConnection(feprops);
        conn.setAutoCommit(false);
        int version = Config.getDBVersion(conn);
        while (version < reqVersion) {
            String ugFileName = VariableSubstituter.substituteRefs((CharSequence)("${fisheye.home}/sql/upgrade_" + version + ".sql"), feprops);
            Config.runUpgrade(ugFileName, conn);
            version = Config.getDBVersion(conn);
        }
        return conn;
    }

    public static int getDBVersion(Connection conn) throws SQLException, CruDBException {
        ResultSet tables = conn.getMetaData().getTables(null, null, "CRUVERSION", null);
        if (!tables.first()) {
            return 0;
        }
        ResultSet rs = conn.createStatement().executeQuery("SELECT version FROM cruversion WHERE version_id = 1");
        if (rs.next()) {
            return rs.getInt("version");
        }
        throw new CruDBException("Unknown DB Version: Version table exists but the version is not set.");
    }
}

