/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.Role;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class ReplyNotification
extends Notification {
    private Comment comment;
    private Comment reply;
    private static final String REPLY_NOTE_TEMPLATE = "reply-notification.ftl";

    public ReplyNotification() {
    }

    public ReplyNotification(Review review, Comment comment, Comment reply) {
        super(reply.getUser());
        this.setComment(comment);
        this.setReply(reply);
        this.setReview(review);
    }

    protected Integer getType() {
        return NotificationManager.TYPE_REPLIED;
    }

    public Comment getComment() {
        if (this.comment == null && this.getRef1() != null) {
            this.comment = CommentManager.getById(this.getRef1());
            if (this.comment == null) {
                Logs.APP_LOG.warn((Object)("Comment " + this.getRef1() + "doesn't exist."));
            }
        }
        return this.comment;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
        this.setRef1(comment.getId());
    }

    public Comment getReply() {
        if (this.reply == null && this.getRef2() != null) {
            this.reply = CommentManager.getById(this.getRef2());
            if (this.reply == null) {
                Logs.APP_LOG.warn((Object)("Reply " + this.getRef2() + "doesn't exist."));
            }
        }
        return this.reply;
    }

    public void setReply(Comment reply) {
        this.reply = reply;
        this.setRef2(reply.getId());
    }

    public String getEmailSubject() {
        return "[" + this.getReview().getPermaId() + "] Comment: " + this.getReview().getName();
    }

    public String getLink() {
        return AppConfig.getsConfig().getSiteURL() + "cru/" + this.getReview().getPermaId() + (this.getComment() != null ? "#c" + this.getComment().getId() : "");
    }

    protected String getEmailTemplateName() {
        return REPLY_NOTE_TEMPLATE;
    }

    public String getRSSNote() throws IOException, TemplateException {
        return this.getEmailNote();
    }

    public String getRSSTitle() {
        if (this.getReply() == null) {
            return "Reply deleted";
        }
        return this.getReview().getPermaId() + ":" + this.getReply().getUser().getDisplayName() + " replied";
    }

    public String getDescription() {
        return "Reply";
    }

    public List getRolesToNotify() {
        LinkedList<Role> roles = new LinkedList<Role>();
        roles.add(ReviewManager.AUTHOR);
        roles.add(ReviewManager.MODERATOR);
        roles.add(ReviewManager.REVIEWER);
        return roles;
    }

    public Integer getEmailNotificationPref(CrucibleUser user) {
        return user.getReplyEmailNotification();
    }

    public Integer getRssNotificationPref(CrucibleUser user) {
        return user.getCompleteEmailNotification();
    }
}

