/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.reports;

import com.cenqua.fisheye.util.SortedMultiMap;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.general.DefaultPieDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PieDatasetAdjuster {
    public static DefaultPieDataset adjustPieDataset(DefaultPieDataset data, int maxSegments, double minSegmentSize) {
        double segmentSize;
        DefaultPieDataset newDs = new DefaultPieDataset();
        SortedMultiMap<Number, Comparable> segmentsBySize = new SortedMultiMap<Number, Comparable>();
        double totalValues = 0.0;
        double otherSize = 0.0;
        for (Comparable c2 : data.getKeys()) {
            totalValues += data.getValue(c2).doubleValue();
            segmentsBySize.add(-data.getValue(c2).doubleValue(), c2);
        }
        int tooSmallCount = 0;
        for (Comparable c3 : data.getKeys()) {
            segmentSize = data.getValue(c3).doubleValue();
            if (!(segmentSize / totalValues < minSegmentSize / 100.0)) continue;
            ++tooSmallCount;
        }
        if (tooSmallCount > 1) {
            for (Comparable c3 : data.getKeys()) {
                segmentSize = data.getValue(c3).doubleValue();
                if (!(segmentSize / totalValues < minSegmentSize / 100.0)) continue;
                otherSize += segmentSize;
                PieDatasetAdjuster.removeByValue(segmentsBySize, c3);
            }
        }
        if (maxSegments > 0 && segmentsBySize.size() > maxSegments + 1 || otherSize > 0.0) {
            int count = 0;
            Iterator i2 = segmentsBySize.iterator();
            while (i2.hasNext()) {
                Comparable key = (Comparable)i2.next();
                if (count++ < maxSegments) {
                    newDs.setValue(key, data.getValue(key));
                    continue;
                }
                otherSize += data.getValue(key).doubleValue();
            }
        } else {
            Iterator i3 = segmentsBySize.iterator();
            while (i3.hasNext()) {
                Comparable key = (Comparable)i3.next();
                newDs.setValue(key, data.getValue(key));
            }
        }
        if (otherSize > 0.0) {
            newDs.setValue((Comparable)((Object)"Other"), otherSize);
        }
        return newDs;
    }

    private static void removeByValue(SortedMultiMap<Number, Comparable> map, Comparable v) {
        for (Number n : map.keySet()) {
            List l = map.getList(n);
            if (!l.remove(v)) continue;
            return;
        }
    }
}

