/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.reports.commentsDefects;

import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.CommentManager;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class CommentDatasetMaker {
    private DefaultCategoryDataset commentDataSet;
    private Date from;
    private Date to;
    private Project project;
    private long totalComments = 0L;
    private long totalDefects = 0L;

    public CommentDatasetMaker(Date from, Date to, Project project) {
        this.to = to;
        this.from = from;
        this.project = project;
    }

    public CategoryDataset getDataSet() {
        if (this.commentDataSet == null) {
            this.makeDataset(this.from, this.to, this.project);
        }
        return this.commentDataSet;
    }

    public Date getFrom() {
        return this.from;
    }

    public Date getTo() {
        return this.to;
    }

    public Project getProject() {
        return this.project;
    }

    public long getTotalComments() {
        return this.totalComments;
    }

    public long getTotalDefects() {
        return this.totalDefects;
    }

    private void makeDataset(Date from, Date to, Project project) {
        long count;
        this.commentDataSet = new DefaultCategoryDataset();
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy");
        cal.setTime(from);
        while (to.compareTo(cal.getTime()) > 0) {
            count = CommentManager.countCommentsOnDay(cal.getTime(), false, project);
            this.commentDataSet.addValue((double)count, (Comparable)((Object)"comments"), (Comparable)((Object)df.format(cal.getTime())));
            this.totalComments += count;
            ((Calendar)cal).add(5, 1);
        }
        cal.setTime(from);
        while (to.compareTo(cal.getTime()) > 0) {
            count = CommentManager.countCommentsOnDay(cal.getTime(), true, project);
            this.commentDataSet.addValue((double)count, (Comparable)((Object)"defects"), (Comparable)((Object)df.format(cal.getTime())));
            this.totalDefects += count;
            ((Calendar)cal).add(5, 1);
        }
    }
}

