/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.diff.patchDiff;

import com.cenqua.crucible.model.FileRevision;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.managers.PatchManager;
import com.cenqua.crucible.revision.diff.patchDiff.PatchDiffListener;
import com.cenqua.crucible.revision.diff.patchDiff.PatchException;
import com.cenqua.crucible.revision.diff.patchDiff.PatchSectionView;
import com.cenqua.crucible.revision.diff.unified.UnifiedDiffException;
import com.cenqua.crucible.revision.diff.unified.UnifiedDiffParser;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.io.LineReader;
import com.cenqua.fisheye.io.ReaderLineReader;
import com.cenqua.fisheye.syntax.InputState;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.syntax.SyntaxDefinition;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchDiff {
    private FileRevision toRevision;
    private PatchDiffListener pdl;
    private LinkedList<PatchSectionView> sections;
    private File patchFile;

    public PatchDiff(FileRevision toRevision) {
        this.toRevision = toRevision;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PatchDiffListener process() throws PatchException {
        PatchDiffListener patchDiffListener;
        ReaderLineReader lineReader = null;
        try {
            UnifiedDiffParser parser = new UnifiedDiffParser();
            lineReader = new ReaderLineReader(LineReader.Mode.MODE_MIXED, new BufferedReader(new FileReader(this.getPatchFile())));
            PatchDiffListener pdl = new PatchDiffListener();
            parser.processRevision(lineReader, pdl, this.toRevision.getPath());
            patchDiffListener = pdl;
        }
        catch (FileNotFoundException e2) {
            try {
                throw new PatchException(e2);
                catch (UnifiedDiffException e3) {
                    throw new PatchException(e3);
                }
            }
            catch (Throwable throwable) {
                IOHelper.close(lineReader);
                throw throwable;
            }
        }
        IOHelper.close(lineReader);
        return patchDiffListener;
    }

    public List<PatchSectionView> getSectionViews() throws PatchException {
        if (this.sections == null) {
            SyntaxDefinition syntaxDefinition = AppConfig.getsConfig().getSyntaxDefinitions().getSyntaxDefinitionForFile(this.toRevision.getFileName());
            this.sections = new LinkedList();
            List<PatchDiffListener.Sect> sects = this.getPatchDiffListener().getSects();
            for (PatchDiffListener.Sect sect : sects) {
                RegionList fromSyntaxHighlightRegions = this.createRegionList(syntaxDefinition, sect.getFromLines());
                RegionList toSyntaxHighlightRegions = this.createRegionList(syntaxDefinition, sect.getToLines());
                this.sections.add(new PatchSectionView(sect, fromSyntaxHighlightRegions, toSyntaxHighlightRegions));
            }
        }
        return this.sections;
    }

    private RegionList createRegionList(SyntaxDefinition syntaxDefinition, StringBuilder text) {
        RegionList regions = new RegionList();
        syntaxDefinition.generateRegions(new InputState(text), regions);
        return regions;
    }

    public PatchDiffListener getPatchDiffListener() throws PatchException {
        if (this.pdl == null) {
            this.pdl = this.process();
        }
        return this.pdl;
    }

    public File getPatchFile() {
        if (this.patchFile == null) {
            Patch p = PatchManager.findPatch(this.toRevision);
            this.patchFile = p.getPatchFile();
        }
        return this.patchFile;
    }
}

