/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.source;

import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.FileRevision;
import com.cenqua.crucible.model.FileRevisionException;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.revision.FileInfo;
import com.cenqua.crucible.revision.source.SourceException;
import com.cenqua.crucible.view.FRXDO;
import com.cenqua.fisheye.diff.view.DiffPrinter;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.syntax.RegionList;
import java.io.File;
import java.util.List;

public abstract class Source {
    public static final String PATCH_SPACE = "PATCH:";
    public static final String FE_SPACE = "FE:";
    protected String reason = "";
    protected String sourceName = "";

    public static String getRepoSourceName(String repname) {
        return FE_SPACE + repname;
    }

    public static String getPatchSourceName(String identifier) {
        return PATCH_SPACE + identifier;
    }

    public static boolean isRepositorySource(String sourceName) {
        return sourceName.startsWith(FE_SPACE);
    }

    public static String getRepositorySourceIdentifier(String sourceName) {
        if (Source.isRepositorySource(sourceName)) {
            return sourceName.split(":")[1];
        }
        return null;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getSourceIdentifier() {
        return this.sourceName.split(":")[1];
    }

    public abstract String getChangeSetId(FileRevision var1);

    public abstract FileInfo getFileInfo(FileRevision var1) throws FileRevisionException;

    public String getReason() {
        return this.reason;
    }

    public SourceException getException() {
        return new SourceException(this.reason);
    }

    public abstract boolean isAvailable();

    public List getAnnotatedAncestors(FileRevisionExtraInfo frx) throws Exception {
        return null;
    }

    public abstract boolean isAnySuccessorRevisions(FileRevision var1);

    public abstract String getLatestRevIdent(FileRevision var1);

    public abstract DiffPrinter getDiffPrinter(FileRevisionExtraInfo var1, String var2, String var3, int var4, boolean var5, boolean var6) throws Exception;

    public abstract FRXDO getFRXDO(FileRevisionExtraInfo var1, CrucibleUser var2, String var3, boolean var4, boolean var5) throws Exception;

    public abstract Blame getBlame(FileRevision var1) throws Exception;

    public abstract IndexedLineReader getFileContents(FileRevision var1, File var2, String var3) throws Exception;

    public abstract void insertLinks(CharSequence var1, RegionList var2);
}

