/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.reports.Period;
import com.cenqua.crucible.reports.reviews.ReviewsDatasetMaker;
import com.cenqua.fisheye.config.SpringContext;
import java.util.Date;

public class ReviewReportDO {
    private int w = 200;
    private int h = 100;
    private Project project;
    private String stateName;
    private ReviewsDatasetMaker rdm;
    private Period period = new Period();

    public ReviewReportDO() {
        this.period.lastFortnight();
        this.setProjectByKey("CR");
        this.stateName = "Review";
    }

    public void setH(int h2) {
        this.h = h2;
    }

    public void setW(int w) {
        this.w = w;
    }

    public void setFrom(String from) {
        this.period.setFromStr(from);
    }

    public void setTo(String to) {
        this.period.setToStr(to);
    }

    public void setProjectByKey(String projKey) {
        ProjectManager pm = (ProjectManager)SpringContext.getComponent("projectManager");
        this.project = pm.getProjectByKey(projKey);
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public String getStateName() {
        return this.stateName;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public int getW() {
        return this.w;
    }

    public int getH() {
        return this.h;
    }

    public Date getTo() {
        return this.period.getTo();
    }

    public String getToStr() {
        return this.period.getToStr();
    }

    public Date getFrom() {
        return this.period.getFrom();
    }

    public String getFromStr() {
        return this.period.getFromStr();
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public Project getProject() {
        return this.project;
    }

    public ReviewsDatasetMaker getData() {
        if (this.rdm == null) {
            this.rdm = new ReviewsDatasetMaker(this.period.getFrom(), this.period.getTo(), this.stateName, this.project);
            this.rdm.getDataSet();
        }
        return this.rdm;
    }

    public long getMaxReviews() {
        return this.getData().getMaxReviews();
    }

    public long getOpenReviews() {
        return this.getData().getOpenReviews();
    }
}

