/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.ReviewManager;
import java.util.Date;

public class RowDetail {
    private Object[] reviewData;
    private String permaId;
    private CrucibleUser author;
    private CrucibleUser moderator;
    private Long activeCount = new Long(0L);
    private Long completedCount = new Long(0L);
    private Long fileCount = new Long(0L);
    private Long reviewCommentCount = new Long(0L);
    private Long fileCommentCount = new Long(0L);

    public RowDetail(Object[] array) {
        this.reviewData = array;
    }

    public Review getReview() {
        return ReviewManager.getReviewById(this.getId());
    }

    public String getPermaId() {
        return this.permaId;
    }

    public void setPermaId(String permaId) {
        this.permaId = permaId;
    }

    public Integer getId() {
        return (Integer)this.reviewData[0];
    }

    public String getName() {
        return (String)this.reviewData[1];
    }

    public String getDescription() {
        return (String)this.reviewData[2];
    }

    public Date getCreateDate() {
        return (Date)this.reviewData[3];
    }

    public String getState() {
        return (String)this.reviewData[4];
    }

    public boolean isClosedState() {
        return this.getState().equals("Closed");
    }

    public boolean isDraftState() {
        return this.getState().equals("Draft");
    }

    public boolean isApprovalState() {
        return this.getState().equals("Approval");
    }

    public void setAuthor(CrucibleUser author) {
        this.author = author;
    }

    public CrucibleUser getAuthor() {
        return this.author;
    }

    public void setModerator(CrucibleUser moderator) {
        this.moderator = moderator;
    }

    public CrucibleUser getModerator() {
        return this.moderator;
    }

    public CrucibleUser getCreator() {
        return (CrucibleUser)this.reviewData[5];
    }

    public Long getActiveCount() {
        return this.activeCount;
    }

    public void setActiveCount(Long activeCount) {
        this.activeCount = activeCount;
    }

    public Long getCompletedCount() {
        return this.completedCount;
    }

    public void setCompletedCount(Long completedCount) {
        this.completedCount = completedCount;
    }

    public Long getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(Long fileCount) {
        this.fileCount = fileCount;
    }

    public int getCountReviewers() {
        return this.getCompletedCount().intValue() + this.getActiveCount().intValue();
    }

    public Long getReviewCommentCount() {
        return this.reviewCommentCount;
    }

    public void setReviewCommentCount(Long reviewCommentCount) {
        this.reviewCommentCount = reviewCommentCount;
    }

    public Long getFileCommentCount() {
        return this.fileCommentCount;
    }

    public void setFileCommentCount(Long fileCommentCount) {
        this.fileCommentCount = fileCommentCount;
    }
}

