/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye;

import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Path
implements Serializable,
Comparable<Path> {
    private static final Pattern SPLIT_PATTERN = Pattern.compile("/");
    private static final Map<String, String> componentCache = new WeakHashMap<String, String>();
    private final String[] mPath;
    private String stringRep = null;

    private Path(String[] comp) {
        this.mPath = this.canonicalize(comp);
    }

    public Path() {
        this.mPath = new String[0];
    }

    public Path(CharSequence path) {
        this.mPath = this.canonicalize(Path.split(path));
    }

    public Path(Path path) {
        this.mPath = path.getComponents();
    }

    public Path(Path aParent, String aPath) {
        this.mPath = this.canonicalize(Path.join(aParent.getComponents(), Path.split(aPath)));
    }

    public Path(Path aParent, Path aPath) {
        this.mPath = this.canonicalize(Path.join(aParent.getComponents(), aPath.getComponents()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] canonicalize(String[] components) {
        for (int i2 = 0; i2 < components.length; ++i2) {
            String component = components[i2];
            String canonical = componentCache.get(component);
            if (canonical == null) {
                Map<String, String> map = componentCache;
                synchronized (map) {
                    componentCache.put(new String(component), component);
                    continue;
                }
            }
            components[i2] = canonical;
        }
        return components;
    }

    public Path(List<String> start) {
        this(start.toArray(new String[start.size()]));
    }

    public Path getParent() {
        if (this.mPath.length == 0) {
            return this;
        }
        String[] comp = new String[this.mPath.length - 1];
        System.arraycopy(this.mPath, 0, comp, 0, comp.length);
        return new Path(comp);
    }

    public String getPath() {
        if (this.stringRep == null) {
            StringBuffer buf = new StringBuffer();
            String sep = "";
            for (String path : this.mPath) {
                buf.append(sep).append(path);
                sep = "/";
            }
            this.stringRep = buf.toString();
        }
        return this.stringRep;
    }

    public String[] getComponents() {
        return this.mPath;
    }

    public Path[] getPathComponents() {
        Path[] paths = new Path[this.mPath.length + 1];
        for (int i2 = 0; i2 <= this.mPath.length; ++i2) {
            String[] comp = new String[i2];
            System.arraycopy(this.mPath, 0, comp, 0, i2);
            paths[i2] = new Path(comp);
        }
        return paths;
    }

    public boolean isAncestor(Path decendant) {
        Path commonRoot = this.getCommonRoot(decendant);
        return commonRoot.equals(this);
    }

    public Path getCommonRoot(Path other) {
        int i2;
        int limit = Math.min(this.mPath.length, other.mPath.length);
        for (i2 = 0; i2 < limit && this.mPath[i2].equals(other.mPath[i2]); ++i2) {
        }
        if (i2 == 0) {
            return new Path("/");
        }
        String[] commonComponents = new String[i2];
        System.arraycopy(this.mPath, 0, commonComponents, 0, i2);
        return new Path(commonComponents);
    }

    public Path getRelativePath(Path aStartPath) {
        return this.getRelativePath(aStartPath, true);
    }

    public Path getRelativePath(Path aStartPath, boolean caseSensitive) {
        List<String> start = Path.simplify(aStartPath.mPath);
        if (start.isEmpty()) {
            return this;
        }
        List<String> us = Path.simplify(this.mPath);
        while (start.size() > 0 && us.size() > 0 && this.isEqualFirstComponent(start, us, caseSensitive)) {
            start.remove(0);
            us.remove(0);
        }
        int nback = start.size();
        for (int i2 = 0; i2 < nback; ++i2) {
            start.add("..");
            start.add("..");
        }
        start.addAll(us);
        return new Path(start).simplify();
    }

    private boolean isEqualFirstComponent(List<String> start, List<String> us, boolean caseSensitive) {
        String lhs = start.get(0);
        String rhs = us.get(0);
        if (!caseSensitive) {
            lhs = lhs.toLowerCase(Locale.US);
            rhs = rhs.toLowerCase(Locale.US);
        }
        return lhs.equals(rhs);
    }

    public String getName() {
        if (this.mPath.length == 0) {
            return "";
        }
        return this.mPath[this.mPath.length - 1];
    }

    public String toString() {
        return this.getPath();
    }

    public Path simplify() {
        List<String> list = Path.simplify(this.mPath);
        return new Path(list.toArray(new String[list.size()]));
    }

    public boolean isAbove() {
        return this.mPath.length > 0 && this.mPath[0].equals("..");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Path)) {
            return false;
        }
        Path path = (Path)o;
        return Arrays.equals(this.mPath, path.mPath);
    }

    public int hashCode() {
        int result = 0;
        for (String s : this.mPath) {
            result += s.hashCode();
        }
        return result;
    }

    private static List<String> simplify(String[] aPath) {
        String s0;
        ArrayList<String> path = new ArrayList<String>(Arrays.asList(aPath));
        for (int i2 = 0; i2 < path.size(); ++i2) {
            String s1 = (String)path.get(i2);
            if ("..".equals(s1) && i2 > 0) {
                String s02 = (String)path.get(i2 - 1);
                if ("..".equals(s02)) continue;
                path.remove(i2--);
                path.remove(i2--);
                continue;
            }
            if (!".".equals(s1)) continue;
            path.remove(i2--);
        }
        if (path.size() == 1 && (s0 = (String)path.get(0)).length() == 0) {
            path.remove(0);
        }
        return path;
    }

    private static String[] join(String[] aLeft, String[] aRight) {
        String[] result = new String[aLeft.length + aRight.length];
        System.arraycopy(aLeft, 0, result, 0, aLeft.length);
        System.arraycopy(aRight, 0, result, aLeft.length, aRight.length);
        return result;
    }

    public static String join(String a2, String b2) {
        if (a2 == null) {
            a2 = "";
        }
        if (b2 == null) {
            b2 = "";
        }
        if (a2.length() == 0) {
            return b2;
        }
        if (b2.length() == 0) {
            return a2;
        }
        if (a2.endsWith("/")) {
            a2 = a2.substring(0, a2.length() - 1);
        }
        if (b2.startsWith("/")) {
            b2 = b2.substring(1);
        }
        return a2 + "/" + b2;
    }

    public static String[] split(CharSequence aPath) {
        if (aPath == null || aPath.length() == 0) {
            return new String[0];
        }
        if (aPath.length() > 0 && aPath.charAt(0) == '/') {
            aPath = aPath.subSequence(1, aPath.length());
        }
        if (aPath.length() == 0) {
            return new String[0];
        }
        return SPLIT_PATTERN.split(aPath);
    }

    public boolean isRoot() {
        return this.mPath.length == 0 || this.mPath.length == 1 && this.mPath[0].length() == 0;
    }

    public Path trimFirst() {
        return this.trimFirst(1);
    }

    public Path trimFirst(int n) {
        if (this.mPath.length == 0) {
            return this;
        }
        int newLen = this.mPath.length - n;
        if (newLen <= 0) {
            return new Path();
        }
        String[] p = new String[newLen];
        System.arraycopy(this.mPath, n, p, 0, p.length);
        return new Path(p);
    }

    public Path trimLast() {
        if (this.mPath.length == 0) {
            return this;
        }
        if (this.mPath.length == 1) {
            return new Path();
        }
        String[] p = new String[this.mPath.length - 1];
        System.arraycopy(this.mPath, 0, p, 0, p.length);
        return new Path(p);
    }

    public String getComponent(int i2) {
        return this.mPath[i2];
    }

    public int numComponents() {
        return this.mPath.length;
    }

    @Override
    public int compareTo(Path o) {
        if (o == null) {
            return -1;
        }
        String[] path = o.mPath;
        for (int i2 = 0; i2 < this.mPath.length && i2 < path.length; ++i2) {
            String a2 = this.mPath[i2];
            String b2 = path[i2];
            int r = a2.compareTo(b2);
            if (r == 0) continue;
            return r;
        }
        if (this.mPath.length < path.length) {
            return -1;
        }
        if (path.length < this.mPath.length) {
            return 1;
        }
        return 0;
    }

    public static String parseName(String p) {
        int idx = p.lastIndexOf("/");
        if (idx == -1) {
            return p;
        }
        return p.substring(idx + 1);
    }

    public static String parseDir(String p) {
        int idx = p.lastIndexOf("/");
        if (idx == -1) {
            return "";
        }
        return p.substring(0, idx);
    }

    public Path abbreviate(int maxLength) {
        return this.abbreviateImpl((int)maxLength).path;
    }

    public Path[] abbreviatePathComponents(int maxLength) {
        List<Path> pc = this.abbreviateImpl((int)maxLength).pathComponents;
        return pc.toArray(new Path[pc.size()]);
    }

    public String toURL() {
        try {
            return FishEyeURLEncoder.encode(this.getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            return this.getPath();
        }
    }

    private AbbrevResult abbreviateImpl(int maxLength) {
        String ellipses = "...";
        if (this.mPath.length <= 2) {
            return new AbbrevResult(this, Arrays.asList(this.getPathComponents()));
        }
        int len = this.getPath().length();
        if (len <= maxLength) {
            return new AbbrevResult(this, Arrays.asList(this.getPathComponents()));
        }
        ArrayList<String> components = new ArrayList<String>(Arrays.asList(this.mPath));
        ArrayList<Path> pathComponents = new ArrayList<Path>(Arrays.asList(this.getPathComponents()));
        int insertEllipsesAt = components.size() / 2;
        while (len > maxLength && components.size() > 2) {
            int midPoint = components.size() / 2;
            insertEllipsesAt = Math.min(insertEllipsesAt, midPoint);
            String s = components.remove(midPoint);
            pathComponents.remove(midPoint);
            len -= s.length() + 1;
        }
        components.add(insertEllipsesAt, "...");
        pathComponents.add(insertEllipsesAt, null);
        return new AbbrevResult(new Path(components), pathComponents);
    }

    public boolean hasPrefix(Path p) {
        return this.hasPrefix(p, true);
    }

    public boolean hasPrefix(Path p, boolean caseSensitive) {
        if (p.numComponents() > this.numComponents()) {
            return false;
        }
        for (int i2 = 0; i2 < p.mPath.length; ++i2) {
            String p1 = p.mPath[i2];
            String p0 = this.mPath[i2];
            if (!caseSensitive) {
                p1 = p1.toLowerCase(Locale.US);
                p0 = p0.toLowerCase(Locale.US);
            }
            if (p1.equals(p0)) continue;
            return false;
        }
        return true;
    }

    public Path normalize() {
        ArrayList<String> components = new ArrayList<String>(Arrays.asList(this.mPath));
        int i2 = 0;
        while (i2 < components.size()) {
            String component = (String)components.get(i2);
            if (component.equals(".")) {
                components.remove(i2);
                continue;
            }
            if (component.equals("..") && i2 != 0) {
                String previous = (String)components.get(i2 - 1);
                if (!previous.equals("..")) {
                    components.remove(i2);
                    components.remove(i2 - 1);
                    --i2;
                    continue;
                }
                ++i2;
                continue;
            }
            ++i2;
        }
        return new Path(components.toArray(new String[components.size()]));
    }

    public String getPath(boolean caseSensitive) {
        String normalized = caseSensitive ? this.getPath() : this.getPath().toLowerCase(Locale.US);
        return normalized;
    }

    public void toLowerCase() {
        for (int i2 = 0; i2 < this.mPath.length; ++i2) {
            this.mPath[i2] = this.mPath[i2].toLowerCase();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AbbrevResult {
        final Path path;
        final List<Path> pathComponents;

        public AbbrevResult(Path path, List<Path> pathComponents) {
            this.path = path;
            this.pathComponents = pathComponents;
        }
    }
}

