/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye;

import com.cenqua.fisheye.AllowRules;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryProperties;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config1.AllowType;
import com.cenqua.fisheye.config1.CustomRepositoryConfigType;
import com.cenqua.fisheye.config1.GroupListType;
import com.cenqua.fisheye.config1.GroupType;
import com.cenqua.fisheye.config1.HideDirType;
import com.cenqua.fisheye.config1.HostAuthRepositoryConfigType;
import com.cenqua.fisheye.config1.LdapRepositoryConfigType;
import com.cenqua.fisheye.config1.LinkerType;
import com.cenqua.fisheye.config1.RepSecurityType;
import com.cenqua.fisheye.config1.RepositoryDefaultsType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.config1.TarballType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.FreeTextAnalyzer;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RepositoryTester;
import com.cenqua.fisheye.syntax.Linker;
import com.cenqua.fisheye.syntax.SyntaxDefinition;
import com.cenqua.fisheye.util.AntGlob;
import com.cenqua.fisheye.util.StringUtil;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.SimpleAnalyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepositoryConfig {
    private final RepositoryType mConfig;
    private final RepositoryDefaultsType mConfigDefaults;
    private final String mName;
    private Linker mLinker = new Linker();
    private final PerFieldAnalyzerWrapper mMasterAnalyzer = new PerFieldAnalyzerWrapper((Analyzer)new SimpleAnalyzer());
    private final List<AntGlob> hideDirectoryPatterns = new ArrayList<AntGlob>();
    private final TarballConfig mTarballConfig;
    private final List<AntGlob> disallowPatterns = new ArrayList<AntGlob>();
    private final List<Path> allowDirs = new ArrayList<Path>();
    private final RepositoryStatus status = new RepositoryStatus();
    private final RepositoryProperties mProperties;
    private boolean storeDiffs;

    public RepositoryConfig(RepositoryType config, RepositoryDefaultsType configDefaults) {
        this.mConfig = config;
        this.mConfigDefaults = configDefaults;
        this.mName = config.getName();
        this.mMasterAnalyzer.addAnalyzer("comment", (Analyzer)new FreeTextAnalyzer());
        this.mMasterAnalyzer.addAnalyzer("contents", (Analyzer)new FreeTextAnalyzer());
        this.mTarballConfig = new TarballConfig(config.getTarball(), configDefaults.getTarball());
        this.setup();
        this.mProperties = new RepositoryProperties(config, configDefaults);
        this.storeDiffs = true;
        if (config.isSetStoreDiff()) {
            this.storeDiffs = config.getStoreDiff();
        }
    }

    public boolean isStoreDiffs() {
        return this.storeDiffs;
    }

    public abstract RepositoryEngine createRepositoryEngine() throws ConfigException, DbException;

    public abstract RepositoryTester createRepositoryTester() throws ConfigException;

    public AllowRules getAllowRules() {
        return new AllowRules(this.allowDirs, this.disallowPatterns);
    }

    private void setup() {
        this.setupLinker();
        if (this.mConfig.isSetAllow()) {
            this.setupRepositoryAllows(this.mConfig.getAllow());
        }
        this.setupRepositoryAllows(this.mConfigDefaults.getAllow());
        this.setupRepositoryHidden(this.mConfig.getHideDirArray());
        this.setupRepositoryHidden(this.mConfigDefaults.getHideDirArray());
    }

    public void setupLinker() {
        Linker linker = new Linker();
        if (this.mConfig.isSetLinker()) {
            linker.addHighlighter(RepositoryConfig.parseCommentFormatter(this.mConfig.getLinker()));
        }
        linker.addHighlighters(AppConfig.getsConfig().getDefaultLinker(this.mConfigDefaults));
        this.mLinker = linker;
    }

    private void setupRepositoryHidden(HideDirType[] hiddendirs) {
        for (HideDirType hidden : hiddendirs) {
            AntGlob glob = new AntGlob(hidden.getPattern(), hidden.getCasesensitive());
            this.hideDirectoryPatterns.add(glob);
        }
    }

    private void setupRepositoryAllows(AllowType allow) {
        AllowType.Exclude[] excludes;
        AllowType.Include[] includeDirs;
        for (AllowType.Include includeDir : includeDirs = allow.getIncludeArray()) {
            String dir = includeDir.getTree();
            this.allowDirs.add(new Path(dir));
        }
        for (AllowType.Exclude exclude : excludes = allow.getExcludeArray()) {
            AntGlob glob = new AntGlob(exclude.getPattern(), exclude.getCasesensitive());
            this.disallowPatterns.add(glob);
        }
    }

    public static SyntaxDefinition parseCommentFormatter(LinkerType e2) {
        Object child;
        int i2;
        StringBuffer buf = new StringBuffer("syntaxdef commentparser {\n");
        boolean foundSomething = false;
        for (i2 = 0; i2 < e2.sizeOfSimpleArray(); ++i2) {
            child = e2.getSimpleArray(i2);
            foundSomething = true;
            String re = child.getRegex();
            String href = child.getHref();
            RepositoryConfig.appendCommentFormatterRules(buf, re, href);
        }
        for (i2 = 0; i2 < e2.sizeOfAdvancedArray(); ++i2) {
            child = e2.getAdvancedArray(i2).getSyntaxdef();
            foundSomething = true;
            buf.append((String)child).append("\n");
        }
        buf.append("}\n");
        if (!foundSomething) {
            return SyntaxDefinition.PASS_THRU;
        }
        StringReader in = new StringReader(buf.toString());
        LinkedList<String> errors = new LinkedList<String>();
        SyntaxDefinition sd = SyntaxDefinition.parse(in, errors);
        if (errors.isEmpty()) {
            return sd;
        }
        Logs.APP_LOG.warn((Object)"errors parsing comment formatter");
        Logs.APP_LOG.debug((Object)("errors parsing comment formatter, input was:\n" + buf));
        for (String error : errors) {
            Logs.APP_LOG.warn((Object)error);
        }
        return SyntaxDefinition.PASS_THRU;
    }

    public static void appendCommentFormatterRules(StringBuffer buf, String re, String href) {
        re = StringUtil.replace(re, "/", "\\/");
        href = StringUtil.replace(href, "\"", "\\\"");
        buf.append("/").append(re).append("/ : { region {\n");
        buf.append("href=\"").append(href).append("\";\n");
        buf.append("type=bugid;\n");
        buf.append("bugid=\"${0}\";\n");
        buf.append("}}\n");
    }

    public TarballConfig getTarballConfig() {
        return this.mTarballConfig;
    }

    public List getHideDirectoryPatterns() {
        return this.hideDirectoryPatterns;
    }

    public String getName() {
        return this.mName;
    }

    public PerFieldAnalyzerWrapper getMasterAnalyzer() {
        return this.mMasterAnalyzer;
    }

    public Linker getLinker() {
        return this.mLinker;
    }

    public List<String> getAllowedGroups() {
        RepSecurityType sec = this.mConfig.getSecurity();
        if (sec.isSetRequiredGroups()) {
            return this.addGroups(sec.getRequiredGroups());
        }
        sec = this.mConfigDefaults.getSecurity();
        if (sec.isSetRequiredGroups()) {
            return this.addGroups(sec.getRequiredGroups());
        }
        return Collections.emptyList();
    }

    private List<String> addGroups(GroupListType groups) {
        LinkedList<String> result = new LinkedList<String>();
        for (int i2 = 0; i2 < groups.sizeOfGroupArray(); ++i2) {
            GroupType g2 = groups.getGroupArray(i2);
            result.add(g2.getName());
        }
        return result;
    }

    public boolean isAnonAccessAllowed() {
        RepSecurityType sec = this.mConfig.getSecurity();
        if (sec.isSetAllowAnon()) {
            return sec.getAllowAnon();
        }
        sec = this.mConfigDefaults.getSecurity();
        return sec.getAllowAnon();
    }

    public LdapRepositoryConfigType getLdapConstraint() {
        RepSecurityType sec = this.mConfig.getSecurity();
        if (sec.isSetLdap()) {
            return sec.getLdap();
        }
        sec = this.mConfigDefaults.getSecurity();
        return sec.getLdap();
    }

    public HostAuthRepositoryConfigType getHostAuthConstraint() {
        RepSecurityType sec = this.mConfig.getSecurity();
        if (sec.isSetHostAuth()) {
            return sec.getHostAuth();
        }
        sec = this.mConfigDefaults.getSecurity();
        return sec.getHostAuth();
    }

    public CustomRepositoryConfigType getCustomAuthConstraint() {
        RepSecurityType sec = this.mConfig.getSecurity();
        if (sec.isSetCustom()) {
            return sec.getCustom();
        }
        sec = this.mConfigDefaults.getSecurity();
        return sec.getCustom();
    }

    public boolean isEnabled() {
        return this.mConfig.getEnabled();
    }

    public boolean isContentIndexingEnabled() {
        if (AppConfig.Hacks.DISABLE_CONTENT_INDEXING) {
            return false;
        }
        if (this.mConfig.isSetTextIndexer()) {
            return this.mConfig.getTextIndexer().getEnabled();
        }
        return this.mConfigDefaults.getTextIndexer().getEnabled();
    }

    public boolean isWatchesEnabled() {
        if (this.mConfig.isSetWatches()) {
            return this.mConfig.getWatches().getEnabled();
        }
        return this.mConfigDefaults.getWatches().getEnabled();
    }

    public RepositoryProperties getRepositoryProperties() {
        return this.mProperties;
    }

    public String getRepositoryType() {
        if (this.mConfig.isSetCvs()) {
            return "cvs";
        }
        if (this.mConfig.isSetSvn()) {
            return "svn";
        }
        if (this.mConfig.isSetPerforce()) {
            return "p4";
        }
        return "custom";
    }

    public RepositoryStatus getStatus() {
        return this.status;
    }

    public RepositoryType getRepositoryTypeConfig() {
        return this.mConfig;
    }

    public RepositoryDefaultsType getRepositoryDefaultsTypeConfig() {
        return this.mConfigDefaults;
    }

    public static class TarballConfig {
        private final TarballType mConfig;
        private final TarballType mDefaults;
        private final boolean mHasConfig;

        public TarballConfig(TarballType config, TarballType defaults) {
            this.mConfig = config;
            this.mDefaults = defaults;
            this.mHasConfig = config != null;
        }

        public boolean isEnabled() {
            return this.mHasConfig ? this.mConfig.getEnabled() : this.mDefaults.getEnabled();
        }

        public int getMaxFileCount() {
            int max = 0;
            if (this.mDefaults.isSetMaxFileCount()) {
                max = this.mDefaults.getMaxFileCount().intValue();
            }
            if (this.mHasConfig && this.mConfig.isSetMaxFileCount()) {
                max = this.mConfig.getMaxFileCount().intValue();
            }
            return max;
        }

        public boolean isExcluded(Path path) {
            return TarballConfig.isExcluded(this.mDefaults.getExcludeArray(), path) || this.mHasConfig && TarballConfig.isExcluded(this.mConfig.getExcludeArray(), path);
        }

        private static boolean isExcluded(TarballType.Exclude[] ex, Path path) {
            for (TarballType.Exclude exclude : ex) {
                Path tree;
                Path dir;
                if (exclude.isSetDir() && path.equals(dir = new Path(exclude.getDir()))) {
                    return true;
                }
                if (!exclude.isSetTree() || !path.hasPrefix(tree = new Path(exclude.getTree()))) continue;
                return true;
            }
            return false;
        }
    }
}

