/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.api;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.io.OutputStreamBuffer;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.LoginCookie;
import com.cenqua.fisheye.user.LoginCookieToken;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseApiHandler {
    public static final String XML_UTF8 = "text/xml; charset=UTF-8";
    protected Context context;
    protected final List mErrorMessages = new LinkedList();
    protected PrintWriter out;
    private OutputStreamBuffer buffer;

    public void setup(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.setup(new HttpContext(req, resp));
    }

    public void setup(Context context) throws IOException {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public List getErrors() {
        return this.mErrorMessages;
    }

    public void addError(String msg) {
        this.mErrorMessages.add(msg);
    }

    public void addErrors(List errors) {
        this.mErrorMessages.addAll(errors);
    }

    public void startResponse() throws IOException {
        this.buffer = new OutputStreamBuffer();
        this.out = new PrintWriter(new OutputStreamWriter((OutputStream)this.buffer, "UTF8"));
        this.openResponse();
    }

    public void endResponse() throws IOException {
        this.closeResponse();
        this.out.close();
        this.context.setContentType(XML_UTF8);
        PrintWriter wout = this.context.getWriter();
        this.buffer.closeAndStream(wout, "UTF8");
        ((Writer)wout).close();
        this.buffer.dispose();
        this.buffer = null;
    }

    public void sendError(String msg) throws IOException {
        if (this.buffer != null) {
            this.buffer.dispose();
            this.buffer = null;
        }
        this.context.setContentType(XML_UTF8);
        this.out = this.context.getWriter();
        this.writeError(msg);
    }

    public abstract String parseCommand() throws IOException;

    public abstract String getStringParam(int var1, String var2);

    public abstract Long getDateParam(int var1, String var2);

    public abstract Long getLongParam(int var1, String var2);

    protected abstract void openResponse();

    protected abstract void closeResponse();

    protected abstract void writeError(String var1) throws IOException;

    public abstract void openArrayValue();

    public abstract void closeArrayValue();

    public abstract void openArrayMember(String var1);

    public abstract void closeArrayMember(String var1);

    public abstract void openArray();

    public abstract void closeArray();

    public abstract void openStruct0(String var1);

    public abstract void openStruct1();

    public abstract void closeStruct0(String var1);

    public abstract void closeStruct(String var1);

    public abstract void writeBooleanAttribute(String var1, boolean var2) throws IOException;

    public abstract void writeDateAttribute(String var1, long var2) throws IOException;

    public abstract void writeDateMember(String var1, long var2) throws IOException;

    public abstract void writeTextAttribute(String var1, String var2) throws IOException;

    public abstract void writeTextMember(String var1, String var2) throws IOException;

    public abstract void writeTextValue(String var1) throws IOException;

    public abstract void writeBooleanValue(boolean var1) throws IOException;

    public abstract void writeIntAttribute(String var1, int var2) throws IOException;

    public abstract void writeIntMember(String var1, int var2) throws IOException;

    protected static void xmlEscape(PrintWriter out, String msg) throws IOException {
        ExpressionUtil.escapeString(msg, out);
    }

    public void writeTextArrayMember(String name, String[] values) throws IOException {
        this.openArrayMember(name);
        for (String s : values) {
            this.writeTextValue(s);
        }
        this.closeArrayMember(name);
    }

    public void writeTextMapMember(String name, String entryName, Map[] values) throws IOException {
        this.openArrayMember(name);
        for (Map m : values) {
            this.openArrayMember(entryName);
            Iterator i$ = m.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o;
                Map.Entry e2 = o = i$.next();
                this.writeTextMember((String)e2.getKey(), (String)e2.getValue());
            }
            this.closeArrayMember(entryName);
        }
        this.closeArrayMember(name);
    }

    public static class HttpContext
    implements Context {
        private final HttpServletRequest req;
        private final HttpServletResponse resp;
        private UserLogin currentUser;

        public HttpContext(HttpServletRequest req, HttpServletResponse resp) {
            this.req = req;
            this.resp = resp;
        }

        public PrintWriter getWriter() throws IOException {
            return this.resp.getWriter();
        }

        public void setContentType(String s) {
            this.resp.setContentType(s);
        }

        public String getPathInfo() {
            return this.req.getPathInfo();
        }

        public String getParameter(String name) {
            return this.req.getParameter(name);
        }

        public BufferedReader getReader() throws IOException {
            return this.req.getReader();
        }

        public UserLogin getUser() {
            if (this.currentUser == null) {
                this.currentUser = AppConfig.getsConfig().getUserManager().getCurrentUser(this.req);
            }
            return this.currentUser;
        }

        public UserLogin checkAuth(String authString) throws DbException {
            UserManager um = AppConfig.getsConfig().getUserManager();
            LoginCookieToken c2 = LoginCookieToken.decode(authString);
            return um.login(this.req, this.resp, c2);
        }

        public LoginCookie login(String username, String password) throws DbException, LicensePolicyException {
            UserManager um = AppConfig.getsConfig().getUserManager();
            UserLogin user = um.login(this.req, this.resp, username, password, false);
            if (user == null) {
                return null;
            }
            LoginCookie lc = um.preCookUrl(this.req, "/api/", true);
            return lc;
        }

        public void logout(UserLogin user) throws DbException {
            UserManager um = AppConfig.getsConfig().getUserManager();
            um.logout(this.req, this.resp);
        }
    }

    public static interface Context {
        public PrintWriter getWriter() throws IOException;

        public void setContentType(String var1);

        public String getPathInfo();

        public String getParameter(String var1);

        public BufferedReader getReader() throws IOException;

        public UserLogin getUser();

        public UserLogin checkAuth(String var1) throws DbException;

        public LoginCookie login(String var1, String var2) throws DbException, LicensePolicyException;

        public void logout(UserLogin var1) throws DbException;
    }
}

