/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.bucket;

import com.cenqua.fisheye.bucket.InvalidBucketException;
import com.cenqua.fisheye.bucket.PeriodUnit;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;

class Period {
    private PeriodUnit periodUnit;
    private int bucket;
    private Date startDate;
    private Date endDate;
    private TimeZone timeZone;

    public String toString() {
        return this.bucket + " (" + this.getFormattedPeriod() + ")";
    }

    public String getFormattedPeriod() {
        String result = this.startDate.toString();
        if (this.periodUnit != PeriodUnit.DAY) {
            result = result + " - " + this.endDate.toString();
        }
        return result;
    }

    public Period(PeriodUnit period, TimeZone timeZone) {
        this.periodUnit = period;
        this.timeZone = timeZone;
        this.setPeriod(new Date(0L));
    }

    public Period(PeriodUnit period, int bucket, TimeZone timeZone) throws InvalidBucketException {
        this.periodUnit = period;
        this.timeZone = timeZone;
        this.setPeriod(bucket);
    }

    public Period(PeriodUnit period, Date date, TimeZone timeZone) {
        this.periodUnit = period;
        this.timeZone = timeZone;
        this.setPeriod(date);
    }

    public void setPeriod(int bucket) throws InvalidBucketException {
        this.bucket = bucket;
        this.startDate = this.bucketToStartDate(bucket);
        this.endDate = this.bucketToEndDate(bucket);
    }

    public void setPeriod(Date date) {
        this.bucket = this.periodUnit.dateToBucket(date.getTime(), this.timeZone);
        this.startDate = new Date(this.periodUnit.bucketToStartDate(this.bucket, this.timeZone));
        this.endDate = new Date(this.periodUnit.bucketToEndDate(this.bucket, this.timeZone));
    }

    public void setPeriod(Period period) {
        this.bucket = period.getBucket();
        this.startDate = new Date(period.getStartTime());
        this.endDate = new Date(period.getEndTime());
    }

    public int getBucket() {
        return this.bucket;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public long getStartTime() {
        return this.startDate.getTime();
    }

    public long getEndTime() {
        return this.endDate.getTime();
    }

    public Date bucketToStartDate(int bucket) throws InvalidBucketException {
        try {
            return new Date(this.periodUnit.bucketToStartDate(bucket, this.timeZone));
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new InvalidBucketException("Invalid month or year bucket");
        }
    }

    public Date bucketToEndDate(int bucket) throws InvalidBucketException {
        try {
            return new Date(this.periodUnit.bucketToEndDate(bucket, this.timeZone));
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new InvalidBucketException("Invalid month or year bucket");
        }
    }

    public void setToNextBucket(int step) throws InvalidBucketException {
        this.setPeriod(this.bucket + step);
    }

    public Period getNextBucket(int step) throws InvalidBucketException {
        return new Period(this.periodUnit, this.bucket + step, this.timeZone);
    }

    public String getStringTT(SimpleDateFormat tooltipDateFormat) {
        String result = tooltipDateFormat.format(this.startDate);
        if (this.periodUnit != PeriodUnit.DAY) {
            result = result + " to " + tooltipDateFormat.format(this.endDate);
        }
        return result;
    }

    public TimePeriod getTimePeriod() {
        return new SimpleTimePeriod(this.startDate, this.endDate);
    }

    public PeriodUnit getPeriodUnit() {
        return this.periodUnit;
    }
}

