/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.ctl;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.logging.SubstitutingDOMConfigurator;
import java.io.File;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.LogManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseCommand {
    private static final String SERVER_LOG4J_XML = "log4j.xml";
    private static final String CLIENT_LOG4J_XML = "log4j-client.xml";
    public static final int EXIT_FAILURE = 1;

    static boolean handleCommonArguments(List<String> argList, PrintStream err) {
        Iterator<String> argIterator = argList.iterator();
        while (argIterator.hasNext()) {
            String s = argIterator.next();
            if (s.equals("--config") && argIterator.hasNext()) {
                argIterator.remove();
                File cfgFile = new File(argIterator.next()).getAbsoluteFile();
                argIterator.remove();
                if (!cfgFile.isFile()) {
                    err.println("Could not read config file " + cfgFile.getAbsolutePath());
                    return false;
                }
                AppConfig.setConfigurationFile(cfgFile);
                continue;
            }
            if (s.equals("--Xno-slurp")) {
                argIterator.remove();
                AppConfig.noSlurp = true;
                continue;
            }
            if (s.equals("--Xdisable-content-indexing")) {
                argIterator.remove();
                AppConfig.Hacks.DISABLE_CONTENT_INDEXING = true;
                continue;
            }
            if (s.equals("--Xdisable-dirtree-empty-checks")) {
                argIterator.remove();
                AppConfig.Hacks.DISABLE_DIRTREE_EMPTY_CHECKS = true;
                continue;
            }
            if (s.equals("--Xtab-width") && argIterator.hasNext()) {
                argIterator.remove();
                String tw = argIterator.next();
                argIterator.remove();
                AppConfig.DEFAULT_TAB_WIDTH = Integer.parseInt(tw);
                continue;
            }
            if ("--quiet".equals(s)) {
                argIterator.remove();
                Logs.setupQuietMode();
            }
            if (!"--debug".equals(s) && !"--debug-perf".equals(s)) continue;
            argIterator.remove();
            Logs.setupDebugMode();
        }
        return true;
    }

    static void setupLogging(boolean isClient) {
        File logCfgFile;
        LogManager.resetConfiguration();
        Logs.init();
        File logDir = AppConfig.getLogDir();
        if (!logDir.isDirectory()) {
            logDir.mkdirs();
        }
        if (!logDir.isDirectory()) {
            Logs.APP_LOG.warn((Object)("could not create logs directory: " + logDir.getAbsolutePath()));
        }
        String log4jFilename = isClient ? CLIENT_LOG4J_XML : SERVER_LOG4J_XML;
        File logCfgFile1 = new File(AppConfig.getInstanceDir(), log4jFilename);
        File logCfgFile2 = new File(AppConfig.getAppHome(), log4jFilename);
        if (logCfgFile1.isFile()) {
            logCfgFile = logCfgFile1;
        } else if (logCfgFile2.isFile()) {
            logCfgFile = logCfgFile2;
        } else {
            Logs.APP_LOG.warn((Object)("Could not find log configuration file, tried " + logCfgFile1 + " and " + logCfgFile2));
            return;
        }
        LogManager.resetConfiguration();
        Properties props = new Properties();
        props.setProperty("fisheye.home", AppConfig.getAppHome().getAbsolutePath());
        props.setProperty("fisheye.inst", AppConfig.getInstanceDir().getAbsolutePath());
        SubstitutingDOMConfigurator cfg = new SubstitutingDOMConfigurator(props);
        cfg.doConfigure(logCfgFile.getAbsolutePath(), LogManager.getLoggerRepository());
    }
}

