/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.cvsrep.Chunk;
import com.cenqua.fisheye.cvsrep.ChunkList;
import com.cenqua.fisheye.cvsrep.DiffParser;
import com.cenqua.fisheye.cvsrep.RcsRevisionInfo;
import com.cenqua.fisheye.cvsrep.Revision;
import com.cenqua.fisheye.cvsrep.RevisionEdge;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.io.LineReader;
import com.cenqua.fisheye.io.StreamLineReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeTree {
    private final Map<RevisionEdge, ChunkList> mEdgeMap = new HashMap<RevisionEdge, ChunkList>();
    private final Map<Revision, Set<RevisionEdge>> mFromEdgeMap = new HashMap<Revision, Set<RevisionEdge>>();
    private int mHeadLines = 0;
    private int mHeadBytes = 0;
    private Revision mHeadRev;
    private final Map<Revision, Node> mNodes = new HashMap<Revision, Node>();

    public List<Revision> getAncestors(Revision aRev) {
        LinkedList<Revision> list = new LinkedList<Revision>();
        Revision rev = aRev;
        while (rev != null) {
            list.add(0, rev);
            Node node = this.getNode(rev);
            rev = node.getAncestor();
        }
        return list;
    }

    void addRevision(Revision aRev) {
        Node node = new Node(aRev);
        this.mNodes.put(aRev, node);
    }

    void setupAncestor(Revision aDescendant, Revision aAncestor) {
        Node node = this.getNode(aDescendant);
        node.setAncestor(aAncestor);
    }

    void setDeltaText(Revision aFrom, Revision aTo, InputStream in) throws IOException {
        RevisionEdge edge = new RevisionEdge(aFrom, aTo);
        final ChunkList hunks = new ChunkList();
        this.mEdgeMap.put(edge, hunks);
        Set<RevisionEdge> fromEdges = this.mFromEdgeMap.get(aFrom);
        if (fromEdges == null) {
            fromEdges = new HashSet<RevisionEdge>();
            this.mFromEdgeMap.put(aFrom, fromEdges);
        }
        fromEdges.add(edge);
        if (in != null) {
            DiffParser parser = new DiffParser(in);
            parser.parseHunks(new DiffParser.DiffListener(){

                public void delete(int line, int count) {
                    hunks.addDelete(line, count);
                }

                public void startAdd(int line, int count) {
                    hunks.addAdd(line, count);
                }

                public void addLine(String line) {
                }
            });
        }
    }

    void setHeadText(Revision aRevision, InputStream aIn) throws IOException {
        this.mHeadRev = aRevision;
        if (aIn != null) {
            String line;
            StreamLineReader reader = new StreamLineReader(LineReader.Mode.MODE_UNIX, aIn);
            this.mHeadLines = 0;
            this.mHeadBytes = 0;
            while ((line = reader.readLine()) != null) {
                ++this.mHeadLines;
                this.mHeadBytes += line.length();
            }
        }
    }

    public Node getNode(Revision aRev) {
        return this.mNodes.get(aRev);
    }

    public ChunkList getChange(RevisionEdge edge) {
        return this.mEdgeMap.get(edge);
    }

    public int getHeadBytes() {
        return this.mHeadBytes;
    }

    void postProcess(Map<Revision, RcsRevisionInfo> revMap) {
        if (this.mHeadRev == null) {
            return;
        }
        this.computeLines(this.mHeadRev, this.mHeadLines);
        for (Map.Entry<Revision, RcsRevisionInfo> entry : revMap.entrySet()) {
            Revision rev = entry.getKey();
            RcsRevisionInfo info = entry.getValue();
            Node node = this.getNode(rev);
            info.setLineCount(node.getLineCount());
            Revision ancestor = node.getAncestor();
            if (ancestor != null) {
                RevisionEdge edge = new RevisionEdge(ancestor, rev);
                if (!this.mEdgeMap.containsKey(edge)) {
                    Node ancestorNode = this.getNode(ancestor);
                    info.setLinesChanged(ancestorNode.getLinesRemoved(), ancestorNode.getLinesAdded(), this.reverseHunks(ancestorNode.getHunks()));
                    continue;
                }
                info.setLinesChanged(node.getLinesAdded(), node.getLinesRemoved(), node.getHunks());
                continue;
            }
            ArrayList<Hunk> hunks = new ArrayList<Hunk>();
            hunks.add(Hunk.createAddHunk(1, 1, node.getLineCount()));
            info.setLinesChanged(node.getLineCount(), 0, hunks);
        }
        for (RcsRevisionInfo info : revMap.values()) {
            RcsRevisionInfo ancestor = info.getAncestor();
            if (info.isDead()) {
                int oldCount = info.getLineCount();
                info.setLineCount(0);
                if (ancestor == null) {
                    info.setLinesChanged(0, 0, new ArrayList<Hunk>());
                    continue;
                }
                ArrayList<Hunk> hunks = new ArrayList<Hunk>();
                hunks.add(Hunk.createDeleteHunk(1, 1, oldCount));
                info.setLinesChanged(0, oldCount, hunks);
                continue;
            }
            if (ancestor == null || !ancestor.isDead()) continue;
            ArrayList<Hunk> hunks = new ArrayList<Hunk>();
            hunks.add(Hunk.createAddHunk(1, 1, info.getLineCount()));
            info.setLinesChanged(info.getLineCount(), 0, hunks);
        }
    }

    private List<Hunk> reverseHunks(List<Hunk> hunks) {
        ArrayList<Hunk> revHunks = new ArrayList<Hunk>();
        for (Hunk hunk : hunks) {
            revHunks.add(hunk.getReverse());
        }
        return revHunks;
    }

    private void computeLines(Revision aStartRevision, int aStartLines) {
        LinkedList<Node> leftToProcess = new LinkedList<Node>();
        Node firstNode = this.getNode(aStartRevision);
        firstNode.setLineCount(aStartLines);
        leftToProcess.addFirst(firstNode);
        while (!leftToProcess.isEmpty()) {
            Node node = (Node)leftToProcess.removeFirst();
            Revision nodeRev = node.getRevision();
            Set<RevisionEdge> edges = this.mFromEdgeMap.get(nodeRev);
            if (edges == null) continue;
            for (RevisionEdge edge : edges) {
                leftToProcess.addLast(this.processEdge(edge, node));
            }
        }
    }

    public Node processEdge(RevisionEdge edge, Node node) {
        ArrayList<Hunk> hunks = new ArrayList<Hunk>();
        Chunk[] chunkArray = this.mEdgeMap.get(edge).asArray();
        Arrays.sort(chunkArray, new Chunk.ChunkComparer());
        boolean skipNext = false;
        int added = 0;
        int removed = 0;
        for (int i2 = 0; i2 < chunkArray.length; ++i2) {
            Chunk nextChunk;
            if (skipNext) {
                skipNext = false;
                continue;
            }
            Chunk chunk = chunkArray[i2];
            int oldLine = chunk.getLine();
            int newLine = oldLine + added - removed;
            int count = chunk.getCount();
            if (i2 < chunkArray.length - 1 && chunkArray[i2 + 1].getLine() == oldLine) {
                nextChunk = chunkArray[i2 + 1];
                skipNext = true;
                hunks.add(new Hunk(oldLine, newLine, count, nextChunk.getCount()));
                removed += count;
                added += nextChunk.getCount();
                continue;
            }
            if (chunk.isDelete() && i2 < chunkArray.length - 1 && chunkArray[i2 + 1].getLine() >= oldLine && chunkArray[i2 + 1].getLine() < oldLine + count) {
                nextChunk = chunkArray[i2 + 1];
                skipNext = true;
                hunks.add(new Hunk(oldLine, newLine, count, nextChunk.getCount()));
                removed += count;
                added += nextChunk.getCount();
                continue;
            }
            if (chunk.isAdd()) {
                hunks.add(Hunk.createAddHunk(oldLine + 1, newLine + 1, count));
                added += count;
                continue;
            }
            if (!chunk.isDelete()) continue;
            hunks.add(Hunk.createDeleteHunk(oldLine, newLine, count));
            removed += count;
        }
        int count = node.getLineCount() + added - removed;
        Node nextNode = this.getNode(edge.getTo());
        nextNode.setLineCounts(added, removed);
        nextNode.setLineCount(count);
        nextNode.setHunks(hunks);
        return nextNode;
    }

    public int getNumberOfChildren(Revision rev) {
        int count = 0;
        for (RevisionEdge edge : this.mEdgeMap.keySet()) {
            Revision from = edge.getFrom();
            Revision to = edge.getTo();
            int compare = to.compareTo(from);
            if ((!rev.equals(from) || compare <= 0) && (!rev.equals(to) || compare >= 0)) continue;
            ++count;
        }
        return count;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Node {
        private final Revision mRevision;
        private int mLineCount;
        private int mLinesAdded;
        private int mLinesRemoved;
        private Revision mAncestor;
        private List<Hunk> hunks;

        public Node(Revision aRevision) {
            this.mRevision = aRevision;
        }

        public Revision getRevision() {
            return this.mRevision;
        }

        public int getLineCount() {
            return this.mLineCount;
        }

        void setLineCount(int aLineCount) {
            this.mLineCount = aLineCount;
        }

        void setLineCounts(int added, int removed) {
            this.mLinesAdded = added;
            this.mLinesRemoved = removed;
        }

        public int getLinesAdded() {
            return this.mLinesAdded;
        }

        public int getLinesRemoved() {
            return this.mLinesRemoved;
        }

        public Revision getAncestor() {
            return this.mAncestor;
        }

        void setAncestor(Revision aAncestor) {
            this.mAncestor = aAncestor;
        }

        public int hashCode() {
            return this.mRevision.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node node = (Node)o;
            return this.mRevision.equals(node.mRevision);
        }

        public void setHunks(List<Hunk> hunks) {
            this.hunks = hunks;
        }

        public List<Hunk> getHunks() {
            return this.hunks;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Revision ").append(this.mRevision == null ? "null" : this.mRevision);
            sb.append(", ancestor ").append(this.mAncestor == null ? "null" : this.mAncestor);
            sb.append(", linecount ").append(this.mLineCount);
            sb.append(", added ").append(this.mLinesAdded);
            sb.append(", removed ").append(this.mLinesRemoved);
            sb.append(", diff hunks ").append(this.hunks == null ? "null" : this.hunks);
            return sb.toString();
        }
    }
}

