/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.CvsRepository;
import com.cenqua.fisheye.cvsrep.CvsRepositoryConfig;
import com.cenqua.fisheye.cvsrep.CvsRepositoryEngine;
import com.cenqua.fisheye.cvsrep.cache.CachedCvsRepository;
import com.cenqua.fisheye.cvsrep.cache.CachedDirUpdater;
import com.cenqua.fisheye.cvsrep.cache.CvsHistoryChangeDetector;
import com.cenqua.fisheye.cvsrep.cache.MutableRevisionInfoCache;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.AuthorLinecountCalculator;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.UpgradeDataFilenameSearch;
import com.cenqua.fisheye.util.Disposer;
import java.io.IOException;

public class CachedCvsRepositoryUpdater {
    private final CvsRepository rep;
    private final CvsRepositoryEngine rcfg;
    private final CvsHistoryChangeDetector mDetector;
    int dirCount;
    private final RepositoryStatus mStatus;
    private boolean foundChanges = false;

    public CachedCvsRepositoryUpdater(CvsRepositoryEngine aCfg) {
        this.rcfg = aCfg;
        this.mStatus = this.rcfg.getStatus();
        this.rep = this.rcfg.getRepository();
        CvsRepositoryConfig cfg = this.rcfg.getCvsCfg();
        this.mDetector = new CvsHistoryChangeDetector(this, cfg.getHistoryFile(), cfg.getFullScanPeriod(), cfg.getHistoryStripPrefix());
        this.mDetector.setCacheListener(this.rcfg.makeCachedCvsRepository().getEventMulticaster());
        this.mStatus.setDoneFullSlurp(false);
    }

    public CvsHistoryChangeDetector getDetector() {
        return this.mDetector;
    }

    public boolean foundChanges() {
        return this.foundChanges;
    }

    public void resetFoundChanges() {
        this.foundChanges = false;
    }

    public void requestFullscan() {
        Logs.APP_LOG.info((Object)("fullscan requested on " + this.rep.getName()));
        this.mDetector.requestFullscan();
    }

    public RepositoryStatus getStatus() {
        return this.mStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fullSlurp(long slurpStartTime) throws DbException {
        if (this.mStatus.isStopRequested()) {
            return;
        }
        CachedCvsRepositoryUpdater cachedCvsRepositoryUpdater = this;
        synchronized (cachedCvsRepositoryUpdater) {
            if (this.mStatus.isRefreshing()) {
                return;
            }
            this.mStatus.setRefreshing(true);
        }
        MutableRevisionInfoCache db = null;
        try {
            if (!this.mStatus.isDoneFullSlurp()) {
                Logs.CONSOLE.info((Object)("starting initial scan of repository [" + this.rcfg.getName() + "]"));
            }
            Logs.PERF_LOG.info((Object)("processing /" + this.rcfg.getName()));
            long t0 = System.currentTimeMillis();
            db = this.rcfg.makeDataCacheUpdater();
            this.dirCount = 0;
            this.scanDirAndFiles(db, new Path());
            long t1 = System.currentTimeMillis();
            Logs.PERF_LOG.info((Object)("done " + this.rep.getName() + ", slurp time = " + (t1 - t0) + "ms"));
            if (this.mStatus.isStopRequested()) {
                return;
            }
            this.scanChangesets(slurpStartTime, db);
            long t2 = System.currentTimeMillis();
            if (!this.mStatus.isDoneFullSlurp()) {
                Logs.CONSOLE.info((Object)("finished initial scan of repository [" + this.rcfg.getName() + "] (visited " + this.dirCount + " directories)" + " in " + (t2 - t0) / 1000L + "s"));
            }
        }
        finally {
            this.mStatus.setRefreshing(false);
            this.mStatus.setMessage("");
            this.mStatus.setDoneFullSlurp(true);
            if (db != null) {
                db.commit();
            }
            db = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanForChangesets(long slurpStartTime) throws DbException {
        if (this.mStatus.isStopRequested()) {
            return;
        }
        CachedCvsRepositoryUpdater cachedCvsRepositoryUpdater = this;
        synchronized (cachedCvsRepositoryUpdater) {
            if (this.mStatus.isRefreshing()) {
                return;
            }
            this.mStatus.setRefreshing(true);
        }
        MutableRevisionInfoCache db = null;
        try {
            db = this.rcfg.makeDataCacheUpdater();
            this.scanChangesets(slurpStartTime, db);
        }
        finally {
            this.mStatus.setRefreshing(false);
            this.mStatus.setMessage("");
            if (db != null) {
                db.commit();
            }
            db = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanChangesets(long slurpStartTime, MutableRevisionInfoCache aDB) throws DbException {
        long t0 = System.currentTimeMillis();
        Disposer.pushThreadInstance();
        try {
            this.mStatus.setMessage("scanning for changesets");
            this.foundChanges |= aDB.scanForChangesets(slurpStartTime, this.getStatus());
        }
        finally {
            Disposer.popThreadInstance();
        }
        long t1 = System.currentTimeMillis();
        Logs.PERF_LOG.info((Object)(this.rep.getName() + ": changesets scanned in " + (t1 - t0) + "ms"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanDir(Path aPath) throws DbException {
        if (this.mStatus.isStopRequested()) {
            return;
        }
        CachedCvsRepositoryUpdater cachedCvsRepositoryUpdater = this;
        synchronized (cachedCvsRepositoryUpdater) {
            if (this.mStatus.isRefreshing()) {
                return;
            }
            this.mStatus.setRefreshing(true);
        }
        try {
            if (!this.rep.isDir(aPath)) {
                return;
            }
            MutableRevisionInfoCache db = null;
            try {
                db = this.rcfg.makeDataCacheUpdater();
                this.scanDir(db, aPath);
                this.foundChanges = true;
            }
            finally {
                if (db != null) {
                    db.commit();
                }
                db = null;
            }
        }
        finally {
            this.mStatus.setRefreshing(false);
            this.mStatus.setMessage("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimize() throws DbException {
        this.mStatus.setMessage("Optimizing index");
        try {
            long t0 = System.currentTimeMillis();
            this.rcfg.getLuceneConnection().optimize();
            long t1 = System.currentTimeMillis();
            Logs.PERF_LOG.info((Object)(this.rcfg.getName() + " index optimized in " + (t1 - t0) + "ms"));
        }
        finally {
            this.mStatus.setMessage("");
        }
    }

    private boolean scanDirAndFiles(MutableRevisionInfoCache aDB, Path aPath) throws DbException {
        Path[] dirs;
        ++this.dirCount;
        this.mStatus.setMessage("processing " + this.rep.getName() + ":" + aPath.abbreviate(50) + " (" + this.dirCount + " dirs so far)");
        boolean updated = this.scanDir(aDB, aPath);
        for (Path child : dirs = this.rep.listDirs(aPath)) {
            if (this.mStatus.isStopRequested()) {
                return updated;
            }
            updated |= this.scanDirAndFiles(aDB, child);
        }
        dirs = null;
        this.foundChanges = updated;
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanDir(MutableRevisionInfoCache aDB, Path aPath) throws DbException {
        boolean updated;
        try {
            long t0 = System.currentTimeMillis();
            Disposer.pushThreadInstance();
            CachedDirUpdater updater = new CachedDirUpdater(aPath, this.rcfg, aDB, this.mStatus);
            updated = updater.scanPhase1();
            updater = null;
            long t1 = System.currentTimeMillis();
            Logs.PERF_LOG.info((Object)(" processed /" + this.rep.getName() + ":" + aPath + " in " + (t1 - t0) + "ms " + (updated ? "was updated" : "no change")));
        }
        finally {
            Disposer.popThreadInstance();
        }
        this.foundChanges = updated;
        return updated;
    }

    public void pingSlurp() {
        this.mDetector.ping();
    }

    public void upgrade() throws DbException {
        CachedCvsRepository cache = this.rcfg.makeCachedCvsRepository();
        UpgradeDataFilenameSearch up = new UpgradeDataFilenameSearch(this.rcfg.getName(), this.getStatus(), cache.getInfDb(), cache.getCommonStringTables(), this.rcfg.makeCachedCvsRepository().isCaseSensitive());
        up.upgradeIfNecessary();
        up.initAndUpgradeBuckets(cache);
    }

    public void calculateAuthorBlame() throws IOException, DbException {
        new AuthorLinecountCalculator(this.rcfg).calcBlame();
    }
}

