/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache.infdb;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.KeywordExpansion;
import com.cenqua.fisheye.cvsrep.RcsFileHistory;
import com.cenqua.fisheye.cvsrep.RcsRevisionInfo;
import com.cenqua.fisheye.cvsrep.cache.CvsFileHistory;
import com.cenqua.fisheye.cvsrep.cache.CvsRevInfo;
import com.cenqua.fisheye.cvsrep.cache.infdb.EAV;
import com.cenqua.fisheye.cvsrep.cache.infdb.RevInfoEAV;
import com.cenqua.fisheye.infinitydb.EavEntityCu;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonFileRevision;
import com.cenqua.obfuscate.idbk4ui8v._Attribute;
import com.cenqua.obfuscate.idbk4ui8v._Cu;
import com.cenqua.obfuscate.idbk4ui8v._EntityClass;
import com.cenqua.obfuscate.idbk4ui8v._ItemSpace;
import gnu.trove.TLongArrayList;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileHistEAV {
    public static final _EntityClass ENTITY = EAV.FILE_INFO;
    public static final _Attribute A_ISBINARY = new _Attribute(1L);
    public static final _Attribute A_EXPAND = new _Attribute(2L);
    public static final _Attribute A_HEAD = new _Attribute(3L);
    public static final _Attribute A_MAINBRANCH = new _Attribute(4L);
    public static final _Attribute A_REVISIONS = new _Attribute(5L);
    private final InfinityDbHandle dbh;
    private final UniqueStringTable pathDB;
    private final RevInfoEAV revInfoEav;

    public FileHistEAV(InfinityDbHandle dbh, UniqueStringTable pathDB, RevInfoEAV revInfoEav) {
        this.dbh = dbh;
        this.pathDB = pathDB;
        this.revInfoEav = revInfoEav;
    }

    public void update(RcsFileHistory history) throws IOException, DbException {
        EavEntityCu ecu = this.makeEav(history.getPath());
        ecu.updateBoolean(A_ISBINARY, history.isBinary());
        KeywordExpansion expand = history.getExpand();
        ecu.updateString(A_EXPAND, expand == null ? null : expand.getName());
        ecu.updateString(A_HEAD, history.getHead());
        ecu.updateString(A_MAINBRANCH, history.getMainBranch());
        ecu.deleteValues(A_REVISIONS);
        for (RcsRevisionInfo info : history.getRevisions()) {
            ecu.addLong(A_REVISIONS, info.getRevID());
        }
    }

    public CvsFileHistory load(Path path) throws IOException, DbException {
        EavEntityCu ecu = this.makeEav(path);
        if (!ecu.exists()) {
            return null;
        }
        CvsFileHistory history = new CvsFileHistory(ecu.getBoolean(A_ISBINARY, false), ecu.getString(A_EXPAND, null), path, ecu.getString(A_HEAD, null), ecu.getString(A_MAINBRANCH, null), this.loadRevisions(ecu));
        return history;
    }

    public boolean exists(Path path) throws IOException, DbException {
        EavEntityCu ecu = this.makeEav(path);
        return ecu.exists();
    }

    private Map<String, CommonFileRevision> loadRevisions(EavEntityCu ecu) throws IOException, DbException {
        HashMap<String, CommonFileRevision> map = new HashMap<String, CommonFileRevision>();
        TLongArrayList revids = ecu.getLongs(A_REVISIONS);
        for (int i2 = 0; i2 < revids.size(); ++i2) {
            int revid = (int)revids.get(i2);
            CvsRevInfo info = this.revInfoEav.load(revid);
            if (info == null) continue;
            map.put(info.getRevision(), info);
        }
        return map;
    }

    private EavEntityCu makeEav(Path path) throws IOException, DbException {
        long pid = this.pathDB.add(path.getPath());
        _Cu cu = _Cu.alloc(pid);
        return new EavEntityCu((_ItemSpace)this.dbh.get(), ENTITY, cu);
    }
}

