/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache.infdb;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.RcsFileHistory;
import com.cenqua.fisheye.cvsrep.RcsRevisionInfo;
import com.cenqua.fisheye.cvsrep.cache.CvsCSID;
import com.cenqua.fisheye.cvsrep.cache.CvsRevInfo;
import com.cenqua.fisheye.cvsrep.cache.infdb.EAV;
import com.cenqua.fisheye.infinitydb.EavEntityCu;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonDirInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.obfuscate.idbk4ui8v._Attachment;
import com.cenqua.obfuscate.idbk4ui8v._Attribute;
import com.cenqua.obfuscate.idbk4ui8v._Cu;
import com.cenqua.obfuscate.idbk4ui8v._EntityClass;
import com.cenqua.obfuscate.idbk4ui8v._Inversion;
import com.cenqua.obfuscate.idbk4ui8v._ItemSpace;
import com.cenqua.obfuscate.idbk4ui8v._k4ui8vIDB;
import gnu.trove.TIntArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevInfoEAV {
    public static final _EntityClass ENTITY = CommonSchema.RevInfo.ENTITY;
    public static final _EntityClass E_CSID_TO_REVID = EAV.E_CSID_TO_REVID;
    public static final _EntityClass E_ISCSMARKER_TO_REVID = EAV.E_ISCSMARKER_TO_REVID;
    public static final _EntityClass E_CSTODO_TO_REVID = EAV.E_CSTODO_TO_REVID;
    public static final _Attribute A_ISCSMARKER = new _Attribute(1003L);
    public static final _Attribute A_REVID = new _Attribute(1004L);
    public static final _Attribute A_STATE = new _Attribute(1005L);
    public static final _Attribute A_CSTODO = new _Attribute(1006L);
    public static final _Inversion INV_ISCSMARKER = new _Inversion(EAV.SCHEMA, ENTITY, A_ISCSMARKER, E_ISCSMARKER_TO_REVID, A_REVID);
    public static final _Attachment INV_CSTODO = new _Attachment(EAV.SCHEMA, E_CSTODO_TO_REVID, A_CSTODO);
    private final InfinityDbHandle dbh;
    private final CommonRevInfoDAO commonDao;
    private final CommonDirInfoDAO dirDao;

    public RevInfoEAV(InfinityDbHandle dbh, CommonStringTables commonStringTables, boolean caseSensitive) {
        this.dbh = dbh;
        this.commonDao = new CommonRevInfoDAO(dbh, commonStringTables, false, caseSensitive, true);
        this.dirDao = new CommonDirInfoDAO(dbh, commonStringTables, caseSensitive);
    }

    public CvsRevInfo load(RevInfoKey key) throws IOException, DbException {
        int revid = this.commonDao.getRevId(key);
        if (revid == -1) {
            return null;
        }
        return this.load(revid);
    }

    public CvsRevInfo load(int revid) throws IOException, DbException {
        if (!this.commonDao.exists(revid)) {
            return null;
        }
        CvsRevInfo info = new CvsRevInfo();
        try {
            this.commonDao.load(revid, info);
            EavEntityCu ecu = this.makeEav(revid);
            info.setState(ecu.getString(A_STATE, null));
            info.setChangeSetId(ecu.getString(CommonSchema.RevInfo.A_CSID, null));
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)e2);
            info = null;
        }
        return info;
    }

    public void update(RcsFileHistory history) throws IOException, DbException {
        long t0 = System.currentTimeMillis();
        ArrayList<RcsRevisionInfo> revs = this.historyInAncestorOrder(history);
        for (RcsRevisionInfo r : revs) {
            this.update(r);
        }
        long t1 = System.currentTimeMillis();
        for (RcsRevisionInfo r : revs) {
            int revid = r.getRevID();
            this.commonDao.updateTagData(revid, r.getTags());
        }
        if (Logs.PERF_LOG.isDebugEnabled()) {
            long t2 = System.currentTimeMillis();
            Logs.PERF_LOG.info((Object)("updated " + history.getPath() + " in " + (t2 - t0) + "ms, including tags in " + (t2 - t1) + "ms"));
        }
    }

    private ArrayList<RcsRevisionInfo> historyInAncestorOrder(RcsFileHistory history) {
        ArrayList<RcsRevisionInfo> l = new ArrayList<RcsRevisionInfo>(history.getRevisions());
        Collections.sort(l, new Comparator<RcsRevisionInfo>(){

            @Override
            public int compare(RcsRevisionInfo a2, RcsRevisionInfo b2) {
                return a2.getCvsRevision().compareTo(b2.getCvsRevision());
            }
        });
        return l;
    }

    private boolean update(RcsRevisionInfo ri) throws IOException, DbException {
        int revid;
        _k4ui8vIDB db = this.dbh.get();
        RevInfoKey rk = ri.getRevInfoKey();
        boolean existing = this.commonDao.exists(rk);
        AncestorLink ancestorLink = null;
        if (ri.getAncestor() != null) {
            int aid = this.commonDao.getRevId(ri.getAncestor().getRevInfoKey());
            ancestorLink = new AncestorLink(aid, ri.getAncestorType());
        }
        if (!existing) {
            revid = this.commonDao.insertNew(ri, ancestorLink, true);
            ri.setRevID(revid);
            this.commonDao.addBranchpoints(revid, ancestorLink, ri.getBranches(), ri);
            EavEntityCu ecu = this.makeEav(revid);
            ecu.updateString(A_STATE, ri.getState());
            INV_CSTODO.insert(db, _Cu.alloc().append(ri.getDate()), _Cu.alloc().append(revid));
        } else {
            revid = this.commonDao.getRevId(rk);
            ri.setRevID(revid);
            this.commonDao.addBranchpoints(revid, ancestorLink, ri.getBranches(), ri);
        }
        ri.setNewlyAdded(!existing);
        return existing;
    }

    public Path[] listFiles(Path dir) throws DbException {
        Collection<Path> paths = this.dirDao.listFiles(dir);
        return paths.toArray(new Path[paths.size()]);
    }

    public Path[] listDirs(Path dir) throws DbException {
        Collection<Path> paths = this.dirDao.listDirs(dir);
        return paths.toArray(new Path[paths.size()]);
    }

    public void updateChangeset(FileRevision ri, CvsCSID csid) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            int revid = ri.getRevID();
            this.commonDao.updateCSID(revid, csid.toString());
            INV_CSTODO.delete(db, _Cu.alloc().append(ri.getDate()), _Cu.alloc().append(revid));
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void setAsChangesetMarker(CvsRevInfo marker) throws IOException, DbException {
        EavEntityCu ecu = this.makeEav(marker.getRevID());
        ecu.updateBooleanInversion(INV_ISCSMARKER, true);
    }

    public CvsCSID getChangeSet(int revid) throws IOException, DbException {
        EavEntityCu ecu = this.makeEav(revid);
        String csid = ecu.getString(CommonSchema.RevInfo.A_CSID, null);
        return csid == null ? null : CvsCSID.parse(csid);
    }

    public boolean changesetContainsPath(CvsCSID csid, Path path) throws IOException, DbException {
        _k4ui8vIDB db = this.dbh.get();
        _Cu cu = _Cu.alloc().append(csid.toString());
        _Cu val = _Cu.alloc();
        while (CommonSchema.RevInfoIndexes.I_CSID.nextInIndex(db, cu, val)) {
            int revid = (int)val.longAt(0);
            RevInfoKey key = this.commonDao.getKey(revid);
            if (!path.equals(key.getPath())) continue;
            return true;
        }
        return false;
    }

    public TIntArrayList getChangeSetRevids(CvsCSID csid) throws IOException, DbException {
        _k4ui8vIDB db = this.dbh.get();
        TIntArrayList result = new TIntArrayList();
        _Cu cu = _Cu.alloc().append(csid.toString());
        _Cu val = _Cu.alloc();
        while (CommonSchema.RevInfoIndexes.I_CSID.nextInIndex(db, cu, val)) {
            int revid = (int)val.longAt(0);
            result.add(revid);
        }
        return result;
    }

    public RevInfoKey getKey(int revid) throws DbException {
        return this.commonDao.getKey(revid);
    }

    private EavEntityCu makeEav(int revid) throws DbException {
        _k4ui8vIDB db = this.dbh.get();
        _Cu cu = _Cu.alloc(revid);
        return new EavEntityCu((_ItemSpace)db, ENTITY, cu);
    }

    public int findRevID(RevInfoKey revkey) throws IOException, DbException {
        return this.commonDao.getRevId(revkey);
    }

    public CommonRevInfoDAO getCommonRevInfoDAO() {
        return this.commonDao;
    }

    static class AllocatedRevId {
        final boolean existing;
        final int revid;

        public AllocatedRevId(boolean existing, int revid) {
            this.existing = existing;
            this.revid = revid;
        }
    }
}

