/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.search;

import com.cenqua.fisheye.cvsrep.search.SearchResults;
import com.cenqua.fisheye.cvsrep.search.query.FishQuery;
import com.cenqua.fisheye.cvsrep.search.query.QueryEvaluator;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.LRUCache;
import org.apache.lucene.queryParser.ParseException;

public class SearchManager {
    private final LRUCache mQueryResultCache = new LRUCache(50, true, null);
    private final QueryEvaluator evaluator;

    public SearchManager(QueryEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public SearchResults runQuery(FishQuery query, boolean forceRefresh) throws Exception {
        String qStr = query.makeQueryString();
        if (forceRefresh) {
            this.mQueryResultCache.expire(qStr);
        }
        return this.getFromCache(qStr, query);
    }

    private SearchResults getFromCache(String qStr, final FishQuery query) throws Exception {
        SearchResults collator;
        LRUCache.ValueFactory factory = new LRUCache.ValueFactory(){

            public Object createValue() throws LRUCache.ValueFactoryException {
                try {
                    return SearchManager.this.executeQueryImpl(query);
                }
                catch (Exception e2) {
                    throw new LRUCache.ValueFactoryException(e2);
                }
            }

            public void updateValue(Object key, Object newval) throws Exception {
            }
        };
        try {
            collator = (SearchResults)this.mQueryResultCache.get(qStr, factory);
        }
        catch (LRUCache.ValueFactoryException e2) {
            throw new DbException("Problem executing query (" + e2.getMessage() + "):" + qStr, e2.getException());
        }
        return collator;
    }

    private SearchResults executeQueryImpl(FishQuery query) throws Exception, ParseException {
        return this.evaluator.performQuery(query);
    }
}

