/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.search.query;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cvsrep.search.SearchResults;
import com.cenqua.fisheye.cvsrep.search.SimpleGrouper;
import com.cenqua.fisheye.cvsrep.search.SimpleSearchResults;
import com.cenqua.fisheye.cvsrep.search.query.FishQuery;
import com.cenqua.fisheye.cvsrep.search.query.QueryEvaluator;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.util.CompareUtil;
import com.cenqua.obfuscate.idbk4ui8v._Attribute;
import com.cenqua.obfuscate.idbk4ui8v._Cu;
import com.cenqua.obfuscate.idbk4ui8v._ItemSpace;
import com.cenqua.obfuscate.idbk4ui8v._k4ui8vIDB;
import gnu.trove.TIntArrayList;
import gnu.trove.TLongArrayList;
import java.io.IOException;
import org.apache.lucene.queryParser.ParseException;

public abstract class BaseQueryEvaluator
implements QueryEvaluator {
    protected abstract RevisionCache getRevisionCache();

    protected abstract LuceneConnection getLuceneConnection();

    protected abstract AndQuery3 createQuery3(FishQuery var1) throws IOException, DbException;

    protected boolean isCaseSensitive() {
        return this.getRevisionCache().isCaseSensitive();
    }

    private SimpleGrouper getGroupByAttribute(FishQuery query) {
        switch (query.getGroupByType()) {
            case 2: {
                return new SimpleGrouper.LongAttributeGrouper(CommonSchema.RevInfo.A_REVKEY, "file");
            }
            case 3: {
                return new SimpleGrouper.LongAttributeGrouper(CommonSchema.RevInfo.A_FULLDIR, "dir");
            }
            case 4: {
                return new SimpleGrouper.StringAttributeGrouper(CommonSchema.RevInfo.A_CSID, "changeset");
            }
        }
        return null;
    }

    public SearchResults performQuery(FishQuery query) throws IOException, ParseException, DbException {
        long t0 = System.currentTimeMillis();
        LuceneConnection conn = this.getLuceneConnection();
        AndQuery3 bq2 = this.createQuery3(query);
        _k4ui8vIDB db = this.getRevisionCache().getInfDb().get();
        _ItemSpace result = bq2.asItemSpace((_ItemSpace)db, conn);
        int limit = query.getHintInMemoryResultLimit();
        int STARTSIZE = 256;
        int count = 0;
        TIntArrayList revids = new TIntArrayList(256);
        _Cu cu = _Cu.alloc();
        boolean exceeded = false;
        while (result.next(cu)) {
            if (count >= limit) {
                exceeded = true;
            }
            ++count;
            int revid = (int)cu.longAt(0);
            revids.add(revid);
        }
        if (exceeded) {
            throw new DbException("your query sucks");
        }
        SimpleSearchResults collator = this.doInMemoryResults(query, db, revids);
        long t1 = System.currentTimeMillis();
        Logs.PERF_LOG.info((Object)("qlsearch: inmem q=" + bq2 + " in " + (t1 - t0) + "ms"));
        return collator;
    }

    private SimpleSearchResults doInMemoryResults(FishQuery query, _ItemSpace db, TIntArrayList revids) throws DbException {
        if (!FishQuery.ORDER_BY_TYPE.NONE.equals((Object)query.getOrderByType())) {
            this.inMemoryOrderBy(db, revids, query.getOrderByType(), query.getOrderByDirection());
        }
        SimpleGrouper grouper = this.getGroupByAttribute(query);
        Object[] groupStarts = null;
        String type = "revision";
        if (grouper != null) {
            groupStarts = grouper.group(db, revids);
            type = grouper.getType();
        }
        SimpleSearchResults collator = new SimpleSearchResults(this.getRevisionCache(), type, revids, groupStarts);
        collator.setMetaData(query.getReturnClause());
        return collator;
    }

    private void inMemoryOrderBy(_ItemSpace db, final TIntArrayList revids, FishQuery.ORDER_BY_TYPE orderByType, FishQuery.ORDER_BY_DIR orderByDirection) throws DbException {
        try {
            _Attribute attr = CommonSchema.RevInfo.A_DATE;
            long defaultVal = 0L;
            int revidsSize = revids.size();
            final TLongArrayList values = new TLongArrayList(revidsSize);
            _Cu cu = _Cu.alloc();
            for (int i2 = 0; i2 < revidsSize; ++i2) {
                int revid = revids.get(i2);
                cu.clear().append(CommonSchema.RevInfo.ENTITY).append(revid).append(attr);
                int pl = cu.length();
                long val = db.next(cu, pl) ? cu.longAt(pl) : defaultVal;
                values.add(val);
            }
            final boolean reverse = FishQuery.ORDER_BY_DIR.DESCENDING.equals((Object)orderByDirection);
            IntComparator comp = new IntComparator(){

                public int compare(int i2, int j) {
                    long a2 = values.getQuick(i2);
                    long b2 = values.getQuick(j);
                    int r = CompareUtil.compareTo(a2, b2);
                    return reverse ? -r : r;
                }
            };
            Swapper swapper = new Swapper(){

                public void swap(int a2, int b2) {
                    int itmp = revids.getQuick(a2);
                    revids.setQuick(a2, revids.getQuick(b2));
                    revids.setQuick(b2, itmp);
                    long ltmp = values.getQuick(a2);
                    values.setQuick(a2, values.getQuick(b2));
                    values.setQuick(b2, ltmp);
                }
            };
            GenericSorting.mergeSort((int)0, (int)revidsSize, (IntComparator)comp, (Swapper)swapper);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }
}

