/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.search.query;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cvsrep.search.query.BaseQueryEvaluator;
import com.cenqua.fisheye.cvsrep.search.query.CVSQueryBuilder;
import com.cenqua.fisheye.cvsrep.search.query.Clause;
import com.cenqua.fisheye.cvsrep.search.query.FishQuery;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.infinitydb.query3.Query3;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.impl.CommonQuery3Helper;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;

public class CVSQueryEvaluator
extends BaseQueryEvaluator {
    private RepositoryEngine repoEngine;

    public CVSQueryEvaluator(RepositoryEngine repoEngine) {
        this.repoEngine = repoEngine;
    }

    protected RevisionCache getRevisionCache() {
        return this.repoEngine.getRevisionCache();
    }

    protected LuceneConnection getLuceneConnection() {
        return this.repoEngine.getLuceneConnection();
    }

    protected AndQuery3 createQuery3(FishQuery query) throws IOException, DbException {
        Path fromPath = query.getFromPath();
        if (fromPath == null) {
            fromPath = new Path();
        }
        AndQuery3 bq = CommonQuery3Helper.findRevisionsUnderDirQuery3(fromPath, this.isCaseSensitive());
        Clause where = query.getWhereClause();
        if (where != null) {
            CVSQueryBuilder qb = new CVSQueryBuilder((Analyzer)this.repoEngine.getCfg().getMasterAnalyzer());
            where.accept(qb);
            Query3 q = qb.getQuery();
            if (q != null) {
                bq.addClause(q);
            }
        }
        return bq;
    }
}

