/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.io;

import com.cenqua.fisheye.io.CharSequenceReader;
import com.cenqua.fisheye.io.LineReader;
import com.cenqua.fisheye.logging.Logs;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class IOHelper {
    public static void close(InputStream aIn) {
        if (aIn != null) {
            try {
                aIn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream aOut) {
        if (aOut != null) {
            try {
                aOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Writer aOut) {
        if (aOut != null) {
            try {
                aOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Reader aIn) {
        if (aIn != null) {
            try {
                aIn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void copyDir(File fromDir, File toDir) throws IOException {
        if (fromDir.getCanonicalPath().equals(toDir.getCanonicalPath())) {
            return;
        }
        toDir.mkdirs();
        File[] entries = fromDir.listFiles();
        for (int i2 = 0; i2 < entries.length; ++i2) {
            File entry = entries[i2];
            File dest = new File(toDir, entry.getName());
            if (entry.isDirectory()) {
                IOHelper.copyDir(entry, dest);
                continue;
            }
            IOHelper.copy(entry, dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File src, File dest) throws IOException {
        if (src.getCanonicalPath().equals(dest.getCanonicalPath())) {
            return;
        }
        if (dest.exists() && dest.isDirectory()) {
            dest = new File(dest, src.getName());
        }
        FileOutputStream out = new FileOutputStream(dest);
        try {
            IOHelper.copyStream(src, (OutputStream)out);
        }
        finally {
            IOHelper.close(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream is, File dest) throws IOException {
        FileOutputStream fos = new FileOutputStream(dest);
        try {
            IOHelper.copyStream(is, (OutputStream)fos);
        }
        finally {
            IOHelper.close(is);
            IOHelper.close(fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(File srcFile, OutputStream dest) throws IOException {
        FileInputStream in = new FileInputStream(srcFile);
        try {
            IOHelper.copyStream((InputStream)in, dest);
        }
        finally {
            IOHelper.close(in);
        }
    }

    public static void copyStream(InputStream src, OutputStream dest) throws IOException {
        byte[] buffer = new byte[8192];
        int count = 0;
        do {
            dest.write(buffer, 0, count);
        } while ((count = src.read(buffer, 0, buffer.length)) != -1);
    }

    public static void copyReader(Reader src, Writer dest) throws IOException {
        char[] buffer = new char[8192];
        int count = 0;
        do {
            dest.write(buffer, 0, count);
        } while ((count = src.read(buffer, 0, buffer.length)) != -1);
    }

    public static String copyReaderToString(Reader src) throws IOException {
        StringWriter dest = new StringWriter();
        IOHelper.copyReader(src, dest);
        return dest.toString();
    }

    public static void copyStringToWriter(String src, Writer dest) throws IOException {
        IOHelper.copyReader(new StringReader(src), dest);
    }

    public static void copyCharSequenceToWriter(CharSequence src, Writer dest) throws IOException {
        IOHelper.copyReader(new CharSequenceReader(src), dest);
    }

    public static String copyFileToString(File file) throws IOException {
        return IOHelper.copyReaderToString(new FileReader(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStringToFile(String src, File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        try {
            IOHelper.copyStringToWriter(src, writer);
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyCharSequenceToFile(CharSequence src, File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        try {
            IOHelper.copyCharSequenceToWriter(src, writer);
        }
        finally {
            writer.close();
        }
    }

    public static void recursiveDelete(File dir, int maxRecurse, boolean deleteThisDir) {
        IOHelper.recursiveDeleteImpl(dir, 0, maxRecurse, deleteThisDir);
    }

    public static void recursiveDelete(File dir, int maxRecurse) {
        IOHelper.recursiveDeleteImpl(dir, 0, maxRecurse, true);
    }

    private static void recursiveDeleteImpl(File dir, int currentRecurse, int maxRecurse, boolean deleteThisDir) {
        if (currentRecurse > maxRecurse) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (int i2 = 0; i2 < files.length; ++i2) {
            File file = files[i2];
            if (file.isFile()) {
                Logs.APP_LOG.debug((Object)("deleting file " + file));
                if (file.delete()) continue;
                Logs.APP_LOG.warn((Object)("problem deleting " + file));
                continue;
            }
            if (!file.isDirectory()) continue;
            IOHelper.recursiveDeleteImpl(file, currentRecurse + 1, maxRecurse, true);
        }
        Logs.APP_LOG.debug((Object)("deleting dir " + dir));
        if (deleteThisDir && !dir.delete()) {
            Logs.APP_LOG.warn((Object)("problem deleting directory " + dir));
        }
    }

    public static void copyStream(Reader in, Writer out) throws IOException {
        int c2;
        while (-1 != (c2 = in.read())) {
            out.write(c2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void translateEncodings(File srcFile, Charset srcEnc, File destFile, Charset destEnc) throws IOException {
        BufferedReader in2 = null;
        BufferedWriter out = null;
        try {
            in2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(srcFile), srcEnc));
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destFile), destEnc));
            IOHelper.copyStream(in2, out);
        }
        catch (Throwable throwable) {
            IOHelper.close(in2);
            IOHelper.close(out);
            throw throwable;
        }
        IOHelper.close(in2);
        IOHelper.close(out);
    }

    public static void mkdirs(File dir) throws IOException {
        if (dir != null) {
            dir.mkdirs();
            if (!dir.exists() || !dir.isDirectory()) {
                throw new IOException("Could not create directory: " + dir);
            }
        }
    }

    public static void createNewFile(File file) throws IOException {
        try {
            file.createNewFile();
        }
        catch (IOException e2) {
            throw new IOException(e2.getMessage() + " - " + file.getAbsolutePath());
        }
    }

    public static void close(LineReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void deleteFile(File file) {
        if (file != null && !file.delete()) {
            Logs.APP_LOG.warn((Object)("Unable to delete file: " + file));
        }
    }

    public static void unzip(File zipFile, File dir) throws IOException {
        ZipFile zf = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> e2 = zf.entries();
        while (e2.hasMoreElements()) {
            ZipEntry entry = e2.nextElement();
            String name = entry.getName();
            if (entry.isDirectory()) continue;
            File entryFile = new File(dir, name);
            entryFile.getParentFile().mkdirs();
            InputStream stream = zf.getInputStream(entry);
            IOHelper.copyStream(stream, entryFile);
        }
    }
}

