/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.license;

import com.cenqua.fisheye.license.LicenseException;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.license.CenquaLicense;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public abstract class CenquaLicenseWrapper
extends CenquaLicense {
    protected final int UNLIMITED_MAX_USERS_SENTINEL = 10000;
    private final File licenseFile;

    protected CenquaLicenseWrapper(CenquaLicense cenquaLicense, File source) {
        super(cenquaLicense);
        this.licenseFile = source;
    }

    public File getLicenseFile() {
        return this.licenseFile;
    }

    public boolean getShouldHassle() {
        if (!this.expires()) {
            return false;
        }
        if (this.isExpired()) {
            return true;
        }
        long grace = 1209600000L;
        long now = System.currentTimeMillis();
        return this.getIssuedTime() + grace < now;
    }

    protected long getOurBuildDate() throws LicenseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        try {
            return df.parse("2008-07-31").getTime();
        }
        catch (ParseException e2) {
            throw new LicenseException("Error parsing internal license date");
        }
    }

    public Long getLatestBuildAllowed() throws LicenseException {
        if (this.maintenanceExpires()) {
            return this.getMaintExpiry();
        }
        Long span = this.getUpgradeSpan();
        if (span != null) {
            return this.getIssuedTime() + span;
        }
        return null;
    }

    private Long getUpgradeSpan() throws LicenseException {
        String s = this.getProperty("fisheye.upgradespan");
        if (s == null) {
            return null;
        }
        try {
            return Long.valueOf(s);
        }
        catch (NumberFormatException e2) {
            throw new LicenseException("Internal license problem, span not int", e2);
        }
    }

    public String getOwnerStatement() {
        return this.getProperty("owner");
    }

    public void validateForCurrentBuild() throws LicenseException {
        Long latestBuildAllowed = this.getLatestBuildAllowed();
        if (latestBuildAllowed != null) {
            long buildDate = this.getOurBuildDate();
            long slack = 604800000L;
            if (buildDate > latestBuildAllowed + 604800000L) {
                throw new LicenseException(this.getInvalidBuildMessage(latestBuildAllowed));
            }
        }
    }

    public String getInvalidBuildMessage() {
        Long latestBuildAllowed = null;
        try {
            latestBuildAllowed = this.getLatestBuildAllowed();
        }
        catch (LicenseException licenseException) {
            // empty catch block
        }
        return this.getInvalidBuildMessage(latestBuildAllowed);
    }

    public String getInvalidBuildMessage(Long latestBuildAllowed) {
        if (latestBuildAllowed == null) {
            return null;
        }
        return "Upgrades for your " + this.getProductName() + " license ended " + DateHelper.toGmtString(new Date(latestBuildAllowed)) + ", and this version was built " + "2008-07-31";
    }

    public boolean getShowOwnerInFooter() {
        return this.getBooleanProperty("owner.verbose1") || this.expires();
    }

    protected boolean getBooleanProperty(String key) {
        String v = this.getProperty(key);
        return "true".equalsIgnoreCase(v);
    }
}

