/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.license;

import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.license.CrucibleLicense;
import com.cenqua.fisheye.license.FishEyeLicense;
import com.cenqua.fisheye.license.LicenseException;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.license.AtlassianLicenseConverter;
import com.cenqua.license.AtlassianLicenseConverterFactory;
import com.cenqua.license.CenquaLicense;
import com.cenqua.license.LicenseDecoder;
import com.cenqua.license.crucible.CrucibleConverter;
import com.cenqua.license.fisheye.FishEyeConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;

public class LicenseHolder {
    private String feLicenseString;
    private String cruLicenseString;
    private FishEyeLicense feLicense;
    private CrucibleLicense cruLicense;
    private File feLicenseFile;
    private File cruLicenseFile;

    public LicenseHolder() {
    }

    public LicenseHolder(String fisheyeLicenseString, String crucibleLicenseString) {
        this.cruLicenseString = crucibleLicenseString;
        this.feLicenseString = fisheyeLicenseString;
        this.parseFishEyeLicenseFromString();
        this.parseCrucibleLicenseFromString();
    }

    public CrucibleLicense getCrucibleLicense() {
        return this.cruLicense;
    }

    public String getCrucibleLicenseString() {
        return this.cruLicenseString;
    }

    public void setCrucibleLicenseString(String cruLicenseString) {
        this.cruLicenseString = cruLicenseString;
        this.parseCrucibleLicenseFromString();
    }

    public FishEyeLicense getFishEyeLicense() {
        return this.feLicense;
    }

    public String getFishEyeLicenseString() {
        return this.feLicenseString;
    }

    public void setFishEyeLicenseString(String feLicenseString) {
        this.feLicenseString = feLicenseString;
        this.parseFishEyeLicenseFromString();
    }

    public void setFeLicenseFile(File feLicenseFile) {
        this.feLicenseFile = feLicenseFile;
        this.parseFishEyeLicenseFromFile();
    }

    public void setCruLicenseFile(File cruLicenseFile) {
        this.cruLicenseFile = cruLicenseFile;
        this.parseCrucibleLicenseFromFile();
    }

    public boolean hasFishEye() {
        return !StringUtil.nullOrEmpty(this.feLicenseString) || this.feLicense != null;
    }

    public boolean hasCrucible() {
        return !StringUtil.nullOrEmpty(this.cruLicenseString);
    }

    public boolean canDecodeFishEye() {
        return this.feLicense != null;
    }

    public boolean canDecodeCrucible() {
        return this.cruLicense != null;
    }

    public boolean isFishEyeTerminated() {
        return this.feLicense.isTerminated();
    }

    public boolean isCrucibleTerminated() {
        return this.cruLicense.isTerminated();
    }

    public boolean isFishEyeValidForCurrentBuild() {
        try {
            this.feLicense.validateForCurrentBuild();
            return true;
        }
        catch (LicenseException e2) {
            return false;
        }
    }

    public boolean isCrucibleValidForCurrentBuild() {
        try {
            this.cruLicense.validateForCurrentBuild();
            return true;
        }
        catch (LicenseException e2) {
            return false;
        }
    }

    public LicenseInfo toLicenseInfo() {
        return new LicenseInfo(this.feLicense, this.cruLicense);
    }

    private void parseFishEyeLicenseFromString() {
        if (!StringUtil.nullOrEmpty(this.feLicenseString)) {
            LicenseHolder.setAtlassianConverter(new FishEyeConverter());
            try {
                this.feLicense = new FishEyeLicense(LicenseDecoder.decodeFromCert(this.feLicenseString), null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void parseCrucibleLicenseFromString() {
        if (!StringUtil.nullOrEmpty(this.cruLicenseString)) {
            LicenseHolder.setAtlassianConverter(new CrucibleConverter());
            try {
                this.cruLicense = new CrucibleLicense(LicenseDecoder.decodeFromCert(this.cruLicenseString), null);
                this.tryCopyOldCenquaLicense();
                this.tryCopyEvalLicense();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void tryCopyOldCenquaLicense() {
        if (this.feLicense == null && this.fromCenqua(this.cruLicense)) {
            this.feLicenseString = "FishEye License copied from old Cenqua Crucible License";
            this.feLicense = new FishEyeLicense(this.cruLicense, this.cruLicense.getLicenseFile());
        }
    }

    private boolean fromCenqua(CenquaLicense license) {
        return "Cenqua".equals(license.getProperty("license.synthetic.license-origin"));
    }

    private void tryCopyEvalLicense() {
        if (this.feLicense == null && this.isEval(this.cruLicense)) {
            this.feLicenseString = "Eval License copied from Crucible";
            this.feLicense = this.makeFishEyeEval(this.cruLicense);
        }
    }

    private void parseFishEyeLicenseFromFile() {
        try {
            LicenseHolder.setAtlassianConverter(new FishEyeConverter());
            this.feLicense = new FishEyeLicense(LicenseDecoder.decode(new FileInputStream(this.feLicenseFile)), this.feLicenseFile);
            this.feLicenseString = this.fromCenqua(this.feLicense) ? "FishEye license loaded from Cenqua-issued .license file" : IOHelper.copyFileToString(this.feLicenseFile).trim();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parseCrucibleLicenseFromFile() {
        try {
            LicenseHolder.setAtlassianConverter(new CrucibleConverter());
            this.cruLicense = new CrucibleLicense(LicenseDecoder.decode(new FileInputStream(this.cruLicenseFile)), this.cruLicenseFile);
            this.cruLicenseString = this.fromCenqua(this.cruLicense) ? "Crucible license loaded from Cenqua-issued .license file" : IOHelper.copyFileToString(this.cruLicenseFile).trim();
            this.tryCopyOldCenquaLicense();
            this.tryCopyEvalLicense();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean isEval(CenquaLicense license) {
        return license.expires();
    }

    private FishEyeLicense makeFishEyeEval(CrucibleLicense cruLicense) {
        Properties props = new Properties();
        this.copyProps(props, cruLicense);
        props.put("fisheye.authtypes", "all");
        props.put("fisheye.jspsource", "true");
        props.put("fisheye.reptypes", "all");
        if (cruLicense.isNumberOfUsersLimited()) {
            props.put("fisheye.maxusers", "" + cruLicense.getMaxCrucibleUsers());
        }
        CenquaLicense fake = new CenquaLicense("FishEye", cruLicense.getLicenseName(), "x", cruLicense.getSoftExpiry(), cruLicense.getHardExpiry(), props);
        return new FishEyeLicense(fake, null);
    }

    private void copyProps(Properties props, CenquaLicense license) {
        Iterator i2 = license.getPropertyKeys();
        while (i2.hasNext()) {
            String key = (String)i2.next();
            props.put(key, license.getProperty(key));
        }
    }

    private static void setAtlassianConverter(AtlassianLicenseConverter converter) {
        AtlassianLicenseConverterFactory.setInstance(new AtlassianLicenseConverterFactory(converter));
    }
}

