/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.logging;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jHandler
extends Handler {
    private Logger log4JLogger;
    public static Map levelMap = new LinkedHashMap();

    public Log4jHandler(Logger logger) {
        this.log4JLogger = logger;
    }

    public void close() throws SecurityException {
    }

    public void flush() {
    }

    public void publish(LogRecord record) {
        Level level = (Level)levelMap.get(record.getLevel());
        if (level == null) {
            level = Level.ERROR;
        }
        if (record.getThrown() != null) {
            this.log4JLogger.log((Priority)level, (Object)record.getMessage(), record.getThrown());
        } else {
            this.log4JLogger.log((Priority)level, (Object)record.getMessage());
        }
    }

    static {
        levelMap.put(java.util.logging.Level.FINEST, Level.DEBUG);
        levelMap.put(java.util.logging.Level.FINER, Level.DEBUG);
        levelMap.put(java.util.logging.Level.FINE, Level.DEBUG);
        levelMap.put(java.util.logging.Level.CONFIG, Level.DEBUG);
        levelMap.put(java.util.logging.Level.INFO, Level.INFO);
        levelMap.put(java.util.logging.Level.WARNING, Level.WARN);
        levelMap.put(java.util.logging.Level.SEVERE, Level.ERROR);
    }
}

