/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene;

import com.cenqua.fisheye.lucene.LongField;
import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Filter;

public class LongFieldFilter
extends Filter {
    private final String mField;
    private final String mStart;
    private final String mEnd;
    private final boolean mIncStart;
    private final boolean mIncEnd;

    public LongFieldFilter(String f2, long from, boolean incFrom, long to, boolean incTo) {
        this.mField = f2;
        this.mStart = LongField.longToString(from);
        this.mIncStart = incFrom;
        this.mEnd = LongField.longToString(to);
        this.mIncEnd = incTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitSet bits(IndexReader reader) throws IOException {
        BitSet bits = new BitSet(reader.maxDoc());
        TermEnum enumerator = reader.terms(new Term(this.mField, this.mStart));
        TermDocs termDocs = reader.termDocs();
        try {
            if (enumerator.term() == null) {
                BitSet bitSet = bits;
                return bitSet;
            }
            Term stop = new Term(this.mField, this.mEnd);
            while (enumerator.term().compareTo(stop) <= 0) {
                boolean skipTerm;
                Term term = enumerator.term();
                boolean bl = skipTerm = !this.mIncStart && term.text().equals(this.mStart) || !this.mIncEnd && term.text().equals(this.mEnd);
                if (!skipTerm) {
                    termDocs.seek(term);
                    while (termDocs.next()) {
                        bits.set(termDocs.doc());
                    }
                }
                if (enumerator.next()) continue;
                break;
            }
        }
        finally {
            enumerator.close();
            termDocs.close();
        }
        return bits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LongFieldFilter that = (LongFieldFilter)((Object)o);
        if (this.mIncEnd != that.mIncEnd) {
            return false;
        }
        if (this.mIncStart != that.mIncStart) {
            return false;
        }
        if (!this.mEnd.equals(that.mEnd)) {
            return false;
        }
        if (!this.mField.equals(that.mField)) {
            return false;
        }
        return this.mStart.equals(that.mStart);
    }

    public int hashCode() {
        int result = this.mField.hashCode();
        result = 29 * result + this.mStart.hashCode();
        result = 29 * result + this.mEnd.hashCode();
        result = 29 * result + (this.mIncStart ? 1 : 0);
        result = 29 * result + (this.mIncEnd ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.mField);
        buffer.append(":");
        buffer.append(LongField.stringToLong(this.mStart));
        buffer.append("-");
        buffer.append(LongField.stringToLong(this.mEnd));
        return buffer.toString();
    }
}

