/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.Lock;

public class LuceneConnection {
    private static final int DEFAULTIDX = 0;
    private static final int MAX_FIELD_LENGTH = 1000000;
    private final File mLocationBase;
    private final Analyzer mAnalyzer;
    private final int mNumIndexes;
    private final ReentrantReadWriteLock mSync = new ReentrantReadWriteLock(true);
    private final Object mCreateLock = new Object();
    private final IndexReader[] mReaders;
    private final IndexWriter[] mWriters;
    private final File[] mLocations;

    public LuceneConnection(File locationBase, Analyzer analyzer, int numIndexes) {
        this.mLocationBase = locationBase;
        this.mAnalyzer = analyzer;
        this.mNumIndexes = numIndexes;
        this.mReaders = new IndexReader[this.mNumIndexes];
        this.mWriters = new IndexWriter[this.mNumIndexes];
        this.mLocations = new File[this.mNumIndexes];
        String base = this.mLocationBase.getPath();
        for (int i2 = 0; i2 < this.mLocations.length; ++i2) {
            this.mLocations[i2] = new File(base + i2);
        }
    }

    public void withQuery(QueryAction action) throws DbException {
        this.grabReadLock();
        try {
            IndexReader reader = this.getReader(0);
            action.perform(new IndexSearcher(reader));
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            this.releaseReadLock();
        }
    }

    public void withReader(ReaderAction action) throws DbException {
        this.grabReadLock();
        try {
            IndexReader reader = this.getReader(0);
            action.perform(reader);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            this.releaseReadLock();
        }
    }

    public void withReader(TIntHashSet requiredIndexes, ReaderActionN action) throws DbException {
        this.grabReadLock();
        try {
            IndexReader[] readers = new IndexReader[this.mNumIndexes];
            for (int idx : requiredIndexes) {
                readers[idx] = this.getReader(idx);
            }
            action.perform(readers);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            this.releaseReadLock();
        }
    }

    public void withReader(BitSet requiredIndexes, ReaderActionN action) throws DbException {
        this.grabReadLock();
        try {
            IndexReader[] readers = new IndexReader[this.mNumIndexes];
            int idx = requiredIndexes.nextSetBit(0);
            while (idx >= 0) {
                readers[idx] = this.getReader(idx);
                idx = requiredIndexes.nextSetBit(idx + 1);
            }
            action.perform(readers);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            this.releaseReadLock();
        }
    }

    public void withAllReaders(ReaderActionN action) throws DbException {
        this.grabReadLock();
        try {
            IndexReader[] readers = new IndexReader[this.mNumIndexes];
            for (int idx = 0; idx < readers.length; ++idx) {
                readers[idx] = this.getReader(idx);
            }
            action.perform(readers);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            this.releaseReadLock();
        }
    }

    public void withReaderAndDeletes(ReaderAction action) throws DbException {
        this.withReaderAndDeletes(0, action);
    }

    public void withReaderAndDeletes(int idx, ReaderAction action) throws DbException {
        this.grabWriteLock();
        try {
            IndexReader reader = this.getReader(idx);
            action.perform(reader);
            this.closeReader(0);
            this.closeWriter(0);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void withWriter(WriterAction action) throws DbException {
        this.withWriter(0, action);
    }

    public void withWriter(int idx, WriterAction action) throws DbException {
        this.grabWriteLock();
        try {
            IndexWriter writer = this.getWriter(idx);
            action.perform(writer);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void withWriter(TIntHashSet requiredIndexes, WriterActionN action) throws DbException {
        this.grabWriteLock();
        try {
            IndexWriter[] writers = new IndexWriter[this.mNumIndexes];
            for (int idx : requiredIndexes) {
                writers[idx] = this.getWriter(idx);
            }
            action.perform(writers);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void optimize() throws DbException {
        this.grabWriteLock();
        try {
            for (int i2 = 0; i2 < this.mNumIndexes; ++i2) {
                IndexWriter writer = this.getWriter(i2);
                writer.optimize();
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void createAndConfigureWriter(int idx) throws DbException {
        IndexWriter w = null;
        try {
            Logs.PERF_LOG.debug((Object)("##opening writer " + idx));
            w = new IndexWriter(this.mLocations[idx], this.mAnalyzer, false);
            LuceneConnection.configureWriter(w);
            this.mWriters[idx] = w;
        }
        catch (IOException e2) {
            LuceneConnection.cleanup(w);
            this.mWriters[idx] = null;
            throw new DbException(e2);
        }
    }

    public static void configureWriter(IndexWriter writer) {
        writer.setUseCompoundFile(true);
        writer.setMaxFieldLength(1000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushWriter() throws DbException {
        this.grabWriteLock();
        try {
            for (int i2 = 0; i2 < this.mNumIndexes; ++i2) {
                this.closeReader(i2);
                this.closeWriter(i2);
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void createIndexes(boolean create) throws DbException {
        try {
            for (int i2 = 0; i2 < this.mNumIndexes; ++i2) {
                File dir = this.mLocations[i2];
                dir.mkdirs();
                if (!dir.isDirectory()) {
                    throw new DbException("could not create directory: " + dir.getAbsolutePath());
                }
                IndexWriter idx = new IndexWriter(dir, this.mAnalyzer, create);
                idx.close();
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void killLuceneLocks() throws DbException {
        try {
            for (File mLocation : this.mLocations) {
                LuceneConnection.killLuceneLocks(mLocation);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private static void killLuceneLocks(File loc) throws IOException {
        FSDirectory dir = FSDirectory.getDirectory((File)loc, (boolean)false);
        IndexReader.unlock((Directory)dir);
        Lock l = dir.makeLock("write.lock");
        if (l.isLocked()) {
            Logs.APP_LOG.warn((Object)("write lock still locked " + l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexReader getReader(int idx) throws DbException {
        Object object = this.mCreateLock;
        synchronized (object) {
            this.closeWriter(idx);
            if (this.mReaders[idx] == null) {
                try {
                    Logs.PERF_LOG.debug((Object)("##opening reader " + idx));
                    this.mReaders[idx] = IndexReader.open((File)this.mLocations[idx]);
                }
                catch (IOException e2) {
                    LuceneConnection.cleanup(this.mReaders[idx]);
                    this.mReaders[idx] = null;
                    throw new DbException(e2);
                }
            }
            return this.mReaders[idx];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexWriter getWriter(int idx) throws DbException {
        Object object = this.mCreateLock;
        synchronized (object) {
            this.closeReader(idx);
            if (this.mWriters[idx] == null) {
                this.createAndConfigureWriter(idx);
            }
            return this.mWriters[idx];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeWriter(int idx) {
        Object object = this.mCreateLock;
        synchronized (object) {
            if (this.mWriters[idx] != null) {
                try {
                    IndexWriter writer = this.mWriters[idx];
                    this.mWriters[idx] = null;
                    Logs.PERF_LOG.debug((Object)("##closing writer " + idx));
                    writer.close();
                }
                catch (IOException e2) {
                    Logs.APP_LOG.warn((Object)"problem closing index writer", (Throwable)e2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeReader(int idx) {
        Object object = this.mCreateLock;
        synchronized (object) {
            if (this.mReaders[idx] != null) {
                try {
                    IndexReader reader = this.mReaders[idx];
                    this.mReaders[idx] = null;
                    Logs.PERF_LOG.debug((Object)("##closing reader " + idx));
                    reader.close();
                }
                catch (IOException e2) {
                    Logs.APP_LOG.warn((Object)"problem closing index reader", (Throwable)e2);
                }
            }
        }
    }

    private void grabReadLock() {
        this.mSync.readLock().lock();
    }

    private void releaseReadLock() {
        this.mSync.readLock().unlock();
    }

    private void grabWriteLock() {
        this.mSync.writeLock().lock();
    }

    private void releaseWriteLock() {
        this.mSync.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.grabWriteLock();
        try {
            for (int i2 = 0; i2 < this.mNumIndexes; ++i2) {
                this.closeReader(i2);
                this.closeWriter(i2);
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private static void cleanup(IndexWriter w) {
        if (w == null) {
            return;
        }
        try {
            w.close();
        }
        catch (IOException e2) {
            Logs.APP_LOG.warn((Object)"problem closing writer", (Throwable)e2);
        }
    }

    private static void cleanup(IndexReader r) {
        if (r == null) {
            return;
        }
        try {
            r.close();
        }
        catch (IOException e2) {
            Logs.APP_LOG.warn((Object)"problem closing reader", (Throwable)e2);
        }
    }

    public static interface WriterActionN {
        public void perform(IndexWriter[] var1) throws IOException, DbException;
    }

    public static interface WriterAction {
        public void perform(IndexWriter var1) throws IOException, DbException;
    }

    public static interface ReaderActionN {
        public void perform(IndexReader[] var1) throws IOException, DbException;
    }

    public static interface ReaderAction {
        public void perform(IndexReader var1) throws IOException, DbException;
    }

    public static interface QueryAction {
        public void perform(IndexSearcher var1) throws IOException, DbException;
    }
}

