/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.cenqua.fisheye.perforce.client.P4ChangePath;
import com.cenqua.fisheye.util.AntGlob;

public class P4BranchMapping {
    private AntGlob fromGlob;
    private AntGlob toGlob;
    private String from;
    private String to;

    public P4BranchMapping(String from, String to) {
        this.from = from;
        this.to = to;
        this.fromGlob = this.createGlob(from);
        this.toGlob = this.createGlob(to);
    }

    private AntGlob createGlob(String spec) {
        if (spec.endsWith("...")) {
            spec = spec.substring(0, spec.length() - "...".length()) + "**";
        }
        return new AntGlob(spec.substring(1));
    }

    public String toString() {
        return this.from + "->" + this.to;
    }

    public boolean matches(P4ChangePath changePath) {
        return this.toGlob.matches(changePath.getPath().substring(1));
    }

    public String getTo() {
        return this.to;
    }

    public String getFrom() {
        return this.from;
    }
}

