/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.cenqua.fisheye.cache.BaseRevisionCache;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.cvsrep.search.SearchManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.perforce.P4RepositoryConfig;
import com.cenqua.fisheye.perforce.P4RepositoryInfo;
import com.cenqua.fisheye.perforce.P4Scanner;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.NetworkRepositorySettings;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.util.Throttle;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;

public class P4RepositoryEngine
extends RepositoryEngine {
    private P4Scanner scanner;

    public P4RepositoryEngine(P4RepositoryConfig config) {
        super(config);
        NetworkRepositorySettings networkSettings = config.getNetworkSettings();
        float throttleLimit = networkSettings.getCps();
        Throttle throttle = new Throttle();
        if (throttleLimit > 0.0f) {
            throttle.setOperationsPerSecond(throttleLimit);
        }
        P4RepositoryInfo repoInfo = config.createRespositoryInfo();
        this.scanner = new P4Scanner(this.getName(), repoInfo, throttle, this.getStatus());
        this.scanner.setCharset(config.getCharset());
        this.scanner.setMasterAnalyzer((Analyzer)config.getMasterAnalyzer());
        this.scanner.setCommitBlockSize(config.getBlocksize());
    }

    public void startEngine() throws IOException, DbException {
        this.scanner.setCacheDir(this.cacheDir);
        this.scanner.start();
    }

    protected void softPassivate() {
        this.getLuceneConnection().close();
    }

    public SearchManager getSearchManager() {
        return this.scanner.getSearchManager();
    }

    public LuceneConnection getLuceneConnection() {
        return this.scanner.getLuceneConnection();
    }

    public RevisionCache getRevisionCache() {
        return this.scanner.getCache();
    }

    protected BaseRevisionCache getBaseRevisionCache() {
        return this.scanner.getP4Cache();
    }

    public void forceClose() {
        this.scanner.forceClose();
        Logs.APP_LOG.debug((Object)("Closed engine " + this.getName()));
    }

    public void requestFullscan() {
    }

    public void doSlurp() throws DbException, ConfigException {
        this.scanner.ping();
    }

    private P4RepositoryConfig getP4Config() {
        return (P4RepositoryConfig)this.getCfg();
    }

    protected long getPollPeriod() {
        return this.getP4Config().getNetworkSettings().getPollPeriod();
    }

    protected boolean wantInitialSlurp() {
        return this.scanner.wantsInitialSlurp();
    }

    public void rescan(String start, String end) throws UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException("Rescan is not supported on Perforce repositories");
    }

    public P4Scanner getScanner() {
        return this.scanner;
    }

    public void requestStop() {
        this.scanner.requestStop();
    }
}

