/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.cvsrep.search.SearchManager;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.P4BranchMapping;
import com.cenqua.fisheye.perforce.P4BranchSpec;
import com.cenqua.fisheye.perforce.P4Cache;
import com.cenqua.fisheye.perforce.P4MultiLineCountStream;
import com.cenqua.fisheye.perforce.P4RepoTester;
import com.cenqua.fisheye.perforce.P4RepositoryInfo;
import com.cenqua.fisheye.perforce.client.P4ChangeList;
import com.cenqua.fisheye.perforce.client.P4ChangePath;
import com.cenqua.fisheye.perforce.client.P4Client;
import com.cenqua.fisheye.perforce.client.P4ClientException;
import com.cenqua.fisheye.perforce.client.P4ClientFactory;
import com.cenqua.fisheye.perforce.client.P4FileSpec;
import com.cenqua.fisheye.perforce.client.P4Fix;
import com.cenqua.fisheye.perforce.client.P4InputDemuxer;
import com.cenqua.fisheye.perforce.client.P4Job;
import com.cenqua.fisheye.perforce.client.P4Label;
import com.cenqua.fisheye.perforce.client.P4Process;
import com.cenqua.fisheye.perforce.client.P4Visitor;
import com.cenqua.fisheye.perforce.db.P4RevInfo;
import com.cenqua.fisheye.perforce.db.P4RevInfoDAO;
import com.cenqua.fisheye.perforce.search.P4QueryEvaluator;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryCache;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RepositoryScanner;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.RevListCache;
import com.cenqua.fisheye.util.LineCountingInputStream;
import com.cenqua.fisheye.util.Throttle;
import com.cenqua.fisheye.util.Timer;
import com.cenqua.fisheye.util.bitset.SegmentedIntSet;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4Scanner
extends RepositoryScanner {
    private final P4ClientFactory clientFactory;
    private P4Client client;
    private P4RevInfoDAO dao;
    private static final int BATCH_SIZE = 400;
    private static final int ADDEDFILE_BATCHSIZE = 2000;
    private Map<String, Long> branchTimes = new HashMap<String, Long>();
    private Map<String, P4BranchSpec> branchSpecs = new HashMap<String, P4BranchSpec>();
    private boolean createOnDemand;

    public P4Scanner(String name, P4RepositoryInfo repInfo, Throttle throttle, RepositoryStatus status) {
        super(name, repInfo, status, repInfo.isCaseSensitive());
        P4Cache cache = new P4Cache(repInfo);
        this.setCache(cache);
        this.setSearchManager(new SearchManager(new P4QueryEvaluator(this.getP4Cache())));
        this.clientFactory = new P4ClientFactory(repInfo, throttle);
        cache.setClientFactory(this.clientFactory);
        this.setCommitBlockSize(200L);
    }

    @Override
    public void start() throws IOException, DbException {
        super.start();
        try {
            this.client = this.clientFactory.createClient();
            this.client.setRepoStatus(this.getStatus());
        }
        catch (P4ClientException e2) {
            throw new DbException(e2);
        }
        this.dao = this.getP4Cache().createDAO();
    }

    @Override
    protected Map<Long, P4ChangeList> getRevList(long startRevision, long endRevision) throws RepositoryClientException {
        long blockEnd;
        SortedMap<Long, P4ChangeList> result = null;
        long blockStart = startRevision;
        long blockLookAhead = 8192L;
        do {
            blockEnd = endRevision > blockStart + blockLookAhead ? blockStart + blockLookAhead - 1L : endRevision;
            try {
                SortedMap<Long, P4ChangeList> revs = this.client.getChangeLists(blockStart, blockLookAhead, blockEnd, false);
                if (result == null) {
                    result = revs;
                } else {
                    result.putAll(revs);
                }
                blockStart = blockEnd + 1L;
                if (blockLookAhead >= 8192L) continue;
                blockLookAhead <<= 1;
            }
            catch (P4ClientException e2) {
                Logs.APP_LOG.warn((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Unable to get revlist due to:" + e2.getMessage()));
                blockLookAhead >>= 2;
            }
        } while (blockLookAhead != 0L && (result == null || (long)result.size() < this.getCommitBlockSize()) && blockEnd < endRevision);
        if (blockLookAhead == 0L) {
            throw new P4ClientException("Unable to get P4 changelists");
        }
        return result;
    }

    public P4Cache getP4Cache() {
        return (P4Cache)this.getCache();
    }

    @Override
    protected void validateRepo() throws ConfigException {
        P4RepoTester tester = new P4RepoTester(this.client);
        tester.testConnection();
    }

    @Override
    protected long slurpRevisionBlock(long startRevision, long endRevision) throws RepositoryClientException, DbException {
        Timer timer = new Timer("Slurping from " + startRevision + " to " + endRevision);
        this.updateBranchMappings();
        SortedMap<Long, P4ChangeList> changeLists = this.client.getChangeLists(startRevision, 0L, endRevision, true);
        Map<String, P4Job> jobInfo = this.getJobInfo(changeLists);
        if (changeLists.size() != 0) {
            Long firstFetched = changeLists.firstKey();
            Long lastFetched = changeLists.lastKey();
            this.getStatus().setMessage("Processing changelists " + firstFetched + " to " + lastFetched);
            this.getStatus().setMessage("Processing " + changeLists.size() + " change lists");
            for (P4ChangeList changeList : changeLists.values()) {
                if (this.getStatus().isStopRequested()) break;
                this.processChangeList(changeList);
            }
            endRevision = lastFetched;
        }
        if (!jobInfo.isEmpty() && !this.getStatus().isStopRequested()) {
            for (Map.Entry<String, P4Job> entry : jobInfo.entrySet()) {
                this.dao.updateJob(entry.getValue());
            }
        }
        timer.end();
        return endRevision;
    }

    private void updateBranchMappings() throws P4ClientException {
        Map<String, Long> updatedTimes = this.client.getBranchUpdateTimes();
        for (Map.Entry<String, Long> entry : updatedTimes.entrySet()) {
            Long oldTime;
            String branchName = entry.getKey();
            Long newTime = entry.getValue();
            if (newTime != null && ((oldTime = this.branchTimes.get(branchName)) == null || newTime > oldTime)) {
                this.branchTimes.put(branchName, newTime);
                this.loadBranchInfo(branchName);
            }
            if (!this.getStatus().isStopRequested()) continue;
            return;
        }
    }

    private void loadBranchInfo(String branchName) throws P4ClientException {
        P4BranchSpec branchSpec = this.client.getBranchSpec(branchName);
        if (branchSpec != null) {
            for (P4BranchMapping mapping : branchSpec.getMappings()) {
                if (!this.getRepositoryInfo().isPathInRepo(mapping.getTo(), -1L) || !this.getRepositoryInfo().isPathInRepo(mapping.getFrom(), -1L)) continue;
                this.branchSpecs.put(branchSpec.getName(), branchSpec);
                break;
            }
        }
    }

    private int insertNewRevision(P4RevInfo revInfo, AncestorLink ancestor) throws DbException {
        this.createParentDir(revInfo.getPath().getParent());
        return this.dao.insertNew(revInfo, ancestor, this.getRepositoryInfo().isStoreDiffs());
    }

    private void createParentDir(Path dir) throws DbException {
        if (!this.dao.existsDir(dir)) {
            if (!dir.isRoot()) {
                this.createParentDir(dir.getParent());
            }
            this.dao.createDir(dir);
        }
    }

    private P4RevInfo createFileRevision(P4ChangeList changeList, P4ChangePath changePath) {
        P4RevInfo revision = new P4RevInfo();
        revision.setP4ChangeSetId(changeList.getId());
        revision.setAuthor(changeList.getAuthor());
        revision.setDate(changeList.getDate());
        revision.setComment(changeList.getComment());
        revision.setPath(this.getRepositoryInfo().getLocalPath(changePath.getPath(), changeList.getId()));
        revision.setBranch("head");
        revision.setTrunkLike(true);
        revision.setHunks(changePath.getHunks());
        revision.setFileType(2);
        for (P4Fix fix : changeList.getFixes()) {
            revision.addFix(fix.getJobName());
        }
        return revision;
    }

    private void processChangeList(P4ChangeList changeList) throws DbException, P4ClientException {
        Timer timer = new Timer("Processing changelist " + changeList.getId());
        this.getStatus().setMessage("Processing changelist " + changeList.getId());
        HashMap<P4FileSpec, P4ChangePath> addedFiles = new HashMap<P4FileSpec, P4ChangePath>();
        for (P4ChangePath changePath : changeList.getChangePaths()) {
            if (!this.getRepositoryInfo().isPathInRepo(changePath.getPath(), changeList.getId())) continue;
            P4RevInfo revInfo = this.createFileRevision(changeList, changePath);
            this.addPathInfo(revInfo, changePath);
            this.processAction(changeList, changePath, revInfo, addedFiles);
        }
        do {
            if (addedFiles.size() < 2000) {
                this.updateAddedFileLineCounts(changeList.getId(), addedFiles);
                addedFiles.clear();
                continue;
            }
            HashMap<P4FileSpec, P4ChangePath> batch = new HashMap<P4FileSpec, P4ChangePath>();
            int count = 0;
            Iterator i2 = addedFiles.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry entry = i2.next();
                batch.put((P4FileSpec)entry.getKey(), (P4ChangePath)entry.getValue());
                i2.remove();
                if (++count < 2000) continue;
                break;
            }
            this.updateAddedFileLineCounts(changeList.getId(), batch);
        } while (!addedFiles.isEmpty());
        timer.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAddedFileLineCounts(final long csid, Map<P4FileSpec, P4ChangePath> addedFiles) throws P4ClientException {
        if (addedFiles.isEmpty()) {
            return;
        }
        HashMap<P4FileSpec, P4ChangePath> files = new HashMap<P4FileSpec, P4ChangePath>(addedFiles);
        final HashSet processedFiles = new HashSet();
        final HashSet duplicateFiles = new HashSet();
        HashMap<P4FileSpec, P4ChangePath> multiStreamFiles = new HashMap<P4FileSpec, P4ChangePath>();
        for (Map.Entry entry : files.entrySet()) {
            String fileType = ((P4ChangePath)entry.getValue()).getFileType();
            if (fileType.equals("unicode") || fileType.equals("utf16")) continue;
            multiStreamFiles.put((P4FileSpec)entry.getKey(), (P4ChangePath)entry.getValue());
        }
        final P4MultiLineCountStream output = new P4MultiLineCountStream(multiStreamFiles, new P4MultiLineCountStream.CountVisitor(){

            public void visit(P4FileSpec file, int count) {
                if (processedFiles.contains(file)) {
                    duplicateFiles.add(file);
                } else {
                    processedFiles.add(file);
                    try {
                        P4Scanner.this.updateLineCount(file, count, csid);
                    }
                    catch (DbException e2) {
                        Logs.APP_LOG.warn((Object)("[" + P4Scanner.this.getRepositoryInfo().getRepositoryDescriptor() + "] Unable to update line count for : " + file));
                    }
                }
            }
        });
        boolean streamed = true;
        try {
            this.client.streamMultipleContent(multiStreamFiles.keySet(), new P4Visitor.ProcessOutputVisitor(){

                public void visit(P4Process p4Process, InputStream is) throws P4Visitor.VisitorException {
                    try {
                        IOHelper.copyStream(is, (OutputStream)output);
                        IOHelper.close(is);
                    }
                    catch (IOException e2) {
                        throw new P4Visitor.VisitorException(e2);
                    }
                }
            });
        }
        catch (P4ClientException e2) {
            streamed = false;
            Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Multiple streaming failed"), (Throwable)e2);
        }
        finally {
            IOHelper.close(output);
        }
        processedFiles.removeAll(duplicateFiles);
        files.keySet().removeAll(processedFiles);
        if (!streamed || !files.isEmpty()) {
            for (Map.Entry<P4FileSpec, P4ChangePath> entry : addedFiles.entrySet()) {
                final P4FileSpec file = entry.getKey();
                final P4ChangePath changePath = entry.getValue();
                try {
                    this.client.streamContent(file, null, new P4Visitor.ProcessOutputVisitor(){

                        public void visit(P4Process p4Process, InputStream is) throws P4Visitor.VisitorException {
                            LineCountingInputStream.CharMode charMode = LineCountingInputStream.CharMode.BYTES;
                            String fileType = changePath.getFileType();
                            if (fileType.equals("unicode")) {
                                charMode = LineCountingInputStream.CharMode.BOM;
                            }
                            LineCountingInputStream lcis = new LineCountingInputStream(is, charMode);
                            try {
                                lcis.readFully();
                                lcis.close();
                                P4Scanner.this.updateLineCount(file, lcis.getLineCount(), csid);
                            }
                            catch (Exception e2) {
                                throw new P4Visitor.VisitorException(e2);
                            }
                        }
                    });
                }
                catch (P4Visitor.VisitorException e3) {
                    Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Unable to get content for " + file), (Throwable)e3);
                }
                catch (P4ClientException e4) {
                    Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Unable to get content for " + file), (Throwable)e4);
                }
            }
        }
    }

    private void updateLineCount(P4FileSpec p4FileSpec, int lineCount, long csid) throws DbException {
        Path repoPath = this.getRepositoryInfo().getLocalPath(p4FileSpec.getPath(), csid);
        RevInfoKey key = new RevInfoKey(repoPath, Long.toString(csid));
        this.dao.updateLineCount(key, lineCount, lineCount, 0);
        P4RepositoryInfo repInfo = (P4RepositoryInfo)this.getRepositoryInfo();
        if (repInfo.isStoreDiffs()) {
            Hunk hunk = new Hunk(0, 1, 0, lineCount);
            this.dao.addHunk(key, hunk);
        }
    }

    private Map<String, P4Job> getJobInfo(Map<Long, P4ChangeList> changeLists) throws P4ClientException {
        HashMap<String, P4Job> jobs = new HashMap<String, P4Job>();
        for (P4ChangeList changeList : changeLists.values()) {
            for (P4Fix p4Fix : changeList.getFixes()) {
                String jobName = p4Fix.getJobName();
                if (jobs.containsKey(jobName)) continue;
                jobs.put(jobName, this.client.getJob(jobName));
            }
        }
        return jobs;
    }

    private void processAction(P4ChangeList changeList, P4ChangePath changePath, P4RevInfo revInfo, Map<P4FileSpec, P4ChangePath> addedFiles) throws DbException, P4ClientException {
        if (changePath.getAction() == null) {
            Logs.APP_LOG.error((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] No action on " + changePath + " in change list: " + changeList));
            return;
        }
        try {
            if (changePath.getAction().equals("add")) {
                this.processAdd(changeList, changePath, revInfo, addedFiles);
            } else if (changePath.getAction().equals("edit")) {
                this.processEdit(changeList, changePath, revInfo, addedFiles);
            } else if (changePath.getAction().equals("delete")) {
                this.processDelete(changeList, changePath, revInfo);
            } else if (changePath.getAction().equals("branch")) {
                this.processBranch(changeList, changePath, revInfo, addedFiles);
            } else if (changePath.getAction().equals("import")) {
                this.processImport(changeList, changePath, revInfo, addedFiles);
            } else if (changePath.getAction().equals("integrate")) {
                this.processIntegrate(changeList, changePath, revInfo, addedFiles);
            } else if (changePath.getAction().equals("purge")) {
                this.processPurge(changeList, changePath, revInfo);
            } else {
                Logs.APP_LOG.error((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Unknown action: " + changePath.getAction()));
            }
        }
        catch (DbException e2) {
            Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Error processing path " + changePath + " in change list " + changeList));
            throw e2;
        }
    }

    private void processPurge(P4ChangeList changeList, P4ChangePath changePath, P4RevInfo revInfo) throws DbException {
        this.processDelete(changeList, changePath, revInfo);
    }

    private String getChangePathBranch(P4ChangePath changePath) {
        for (Map.Entry<String, P4BranchSpec> entry : this.branchSpecs.entrySet()) {
            String name = entry.getKey();
            P4BranchSpec branchSpec = entry.getValue();
            for (P4BranchMapping mapping : branchSpec.getMappings()) {
                if (!mapping.matches(changePath)) continue;
                return name;
            }
        }
        return "head";
    }

    public Map getBranchSpecs() {
        return this.branchSpecs;
    }

    private void processAdd(P4ChangeList changeList, P4ChangePath changePath, P4RevInfo revInfo, Map<P4FileSpec, P4ChangePath> addedFiles) throws DbException, P4ClientException {
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Processing add in " + changeList.getId() + " for " + changePath));
        revInfo.setAdded(true);
        if (!revInfo.isBinary()) {
            addedFiles.put(changePath.getFileSpec(), changePath);
        }
        revInfo.setLineCount(revInfo.getLinesAdded() - revInfo.getLinesRemoved());
        this.insertNewRevision(revInfo, null);
    }

    private void processImport(P4ChangeList changeList, P4ChangePath changePath, P4RevInfo revInfo, Map<P4FileSpec, P4ChangePath> addedFiles) throws DbException, P4ClientException {
        this.processIntegrate(changeList, changePath, revInfo, addedFiles);
    }

    private void processBranch(P4ChangeList changeList, P4ChangePath changePath, P4RevInfo revInfo, Map<P4FileSpec, P4ChangePath> addedFiles) throws DbException, P4ClientException {
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Processing branch in " + changeList.getId() + " for " + changePath));
        if (changePath.getSourceFileSpec() == null) {
            Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] No source path for branch to " + changePath + " in " + changeList.getId()));
            this.processAdd(changeList, changePath, revInfo, addedFiles);
        } else {
            String sourcePath = changePath.getSourceFileSpec().getPath();
            if (!this.getRepositoryInfo().isPathInRepo(sourcePath, changeList.getId())) {
                if (changePath.getFileRev() == 1) {
                    this.processAdd(changeList, changePath, revInfo, addedFiles);
                } else {
                    this.processEdit(changeList, changePath, revInfo, addedFiles);
                }
            } else {
                this.processCopy(changeList, changePath, revInfo, addedFiles);
            }
        }
    }

    private void processCopy(P4ChangeList changeList, P4ChangePath changePath, P4RevInfo revInfo, Map<P4FileSpec, P4ChangePath> addedFiles) throws DbException, P4ClientException {
        int currentLineCount;
        int ancestorType;
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Processing copy in " + changeList.getId() + " for " + changePath));
        String sourcePath = changePath.getSourceFileSpec().getPath();
        P4ChangePath sourceChangePath = changeList.getChangePath(sourcePath);
        Path sourceRepoPath = this.getRepositoryInfo().getLocalPath(sourcePath, changeList.getId());
        int sourceRevId = this.dao.getRevIdByFileRev(sourceRepoPath, changePath.getSourceFileSpec().getFileRev());
        if (sourceRevId == -1) {
            Path destPath = this.getRepositoryInfo().getLocalPath(changePath.getPath(), changeList.getId());
            int latestRevId = this.dao.getLatestPathRevid(destPath);
            if (latestRevId == -1 || this.dao.isDeleted(latestRevId)) {
                this.processAdd(changeList, changePath, revInfo, addedFiles);
            } else {
                this.processEdit(changeList, changePath, revInfo, addedFiles);
            }
            return;
        }
        String sourceBranch = this.dao.getBranch(sourceRevId);
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] copy branch is " + sourceBranch));
        if (sourceChangePath != null && sourceChangePath.getAction().equals("delete")) {
            revInfo.setMove(true);
            ancestorType = 3;
        } else {
            revInfo.setCopy(true);
            ancestorType = sourceBranch.equals(revInfo.getBranch()) ? 2 : 1;
        }
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] ancestorType is " + ancestorType));
        int sourceLineCount = this.dao.getLineCount(sourceRevId);
        long lastCsid = this.dao.getLatestPathChange(revInfo.getPath());
        if (lastCsid != -1L) {
            int lastRevid = this.dao.getRevId(revInfo.getPath(), lastCsid);
            if (this.dao.isDeleted(lastRevid)) {
                revInfo.setAdded(true);
                currentLineCount = 0;
            } else {
                currentLineCount = this.dao.getLineCount(lastRevid);
            }
        } else {
            revInfo.setAdded(true);
            currentLineCount = 0;
        }
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] last change for path " + lastCsid));
        revInfo.setLineCount(sourceLineCount);
        revInfo.setLinesAdded(sourceLineCount - currentLineCount);
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] src line count " + sourceLineCount));
        if (revInfo.isAdded()) {
            revInfo.createAdditionHunk();
        }
        AncestorLink ancestor = new AncestorLink(sourceRevId, ancestorType);
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] inserting new revision for " + changePath));
        int newRevid = this.insertNewRevision(revInfo, ancestor);
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] inserted new revision for " + changePath + ", rev id = " + newRevid));
    }

    private void processDelete(P4ChangeList changeList, P4ChangePath changePath, P4RevInfo revInfo) throws DbException {
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Processing delete in " + changeList.getId() + " for " + changePath));
        int previousRevid = this.dao.getRevIdByFileRev(revInfo.getPath(), revInfo.getFileRev() - 1);
        revInfo.setLineCount(0);
        revInfo.setDead(true);
        AncestorLink ancestor = null;
        if (previousRevid == -1) {
            Logs.APP_LOG.warn((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Processing a delete with no previous revision at " + changeList.getId() + " for " + changePath));
        } else {
            ancestor = new AncestorLink(previousRevid, 0);
            int oldLineCount = this.dao.getLineCount(previousRevid);
            revInfo.setLinesRemoved(oldLineCount);
            revInfo.createDeletedHunk();
        }
        this.insertNewRevision(revInfo, ancestor);
    }

    private void processIntegrate(P4ChangeList changeList, P4ChangePath changePath, P4RevInfo revInfo, Map<P4FileSpec, P4ChangePath> addedFiles) throws DbException, P4ClientException {
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Processing integrate in " + changeList.getId() + " for " + changePath));
        if (changePath.getFileRev() == 1) {
            P4FileSpec sourceFileSpec = changePath.getSourceFileSpec();
            if (sourceFileSpec == null || !this.getRepositoryInfo().isPathInRepo(sourceFileSpec.getPath(), changeList.getId())) {
                this.processAdd(changeList, changePath, revInfo, addedFiles);
            } else {
                this.processCopy(changeList, changePath, revInfo, addedFiles);
            }
        } else {
            String integrationAction = changePath.getIntegrationAction();
            if (integrationAction == null || integrationAction.equals("merge")) {
                this.processEdit(changeList, changePath, revInfo, addedFiles);
            } else if (integrationAction.equals("copy")) {
                String sourcePath = changePath.getSourceFileSpec().getPath();
                if (!this.getRepositoryInfo().isPathInRepo(sourcePath, changeList.getId())) {
                    this.processEdit(changeList, changePath, revInfo, addedFiles);
                } else {
                    this.processCopy(changeList, changePath, revInfo, addedFiles);
                }
            } else if (integrationAction.equals("edit")) {
                this.processEdit(changeList, changePath, revInfo, addedFiles);
            } else if (integrationAction.equals("branch")) {
                this.processBranch(changeList, changePath, revInfo, addedFiles);
            } else if (integrationAction.equals("delete")) {
                this.processDelete(changeList, changePath, revInfo);
            } else {
                Logs.APP_LOG.error((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Unknown integration action: " + integrationAction));
            }
        }
    }

    private void processEdit(P4ChangeList changeList, P4ChangePath changePath, P4RevInfo revInfo, Map<P4FileSpec, P4ChangePath> addedFiles) throws DbException, P4ClientException {
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Processing edit in " + changeList.getId() + " for " + changePath));
        int previousRevid = this.dao.getRevIdByFileRev(revInfo.getPath(), revInfo.getFileRev() - 1);
        if (previousRevid == -1) {
            Logs.APP_LOG.warn((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Edit for " + changePath + " with no preceding revision"));
        }
        if (previousRevid == -1 || this.dao.isDeleted(previousRevid)) {
            this.processAdd(changeList, changePath, revInfo, addedFiles);
        } else {
            AncestorLink ancestor = new AncestorLink(previousRevid, 0);
            int oldLineCount = this.dao.getLineCount(previousRevid);
            revInfo.setLineCount(oldLineCount + revInfo.getLinesAdded() - revInfo.getLinesRemoved());
            this.insertNewRevision(revInfo, ancestor);
        }
    }

    private void addPathInfo(P4RevInfo revInfo, P4ChangePath changePath) {
        revInfo.setLinesAdded(changePath.getAdded());
        revInfo.setLinesRemoved(changePath.getRemoved());
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Creating revision for " + changePath.getFileSpec() + "@" + revInfo.getP4ChangeSetId()));
        revInfo.setUnicode(changePath.getFileType().equals("unicode"));
        revInfo.setBinary(changePath.isBinary());
        revInfo.setFileType(1);
        revInfo.setFileRev(changePath.getFileRev());
        revInfo.setFileSize(changePath.getFileSize());
        revInfo.setP4FileType(changePath.getFileType());
        revInfo.setBranch(this.getChangePathBranch(changePath));
    }

    @Override
    protected long getFirstRevision() throws RepositoryClientException {
        return 1L;
    }

    @Override
    protected long getLatestRevision() throws RepositoryClientException, ConfigException {
        return this.client.getLatestRevision();
    }

    @Override
    protected boolean processTags() throws RepositoryClientException, DbException {
        final boolean[] changed = new boolean[]{false};
        this.getStatus().setMessage("Processing labels");
        try {
            final int[] count = new int[1];
            this.client.visitLabels(this.getRepositoryInfo().getIncludedPaths(), new P4Visitor.LabelVisitor(){

                public void visit(P4Label label) {
                    count[0] = count[0] + 1;
                    try {
                        final String tag = label.getName();
                        if (tag.indexOf("#") != -1) {
                            Logs.APP_LOG.warn((Object)("[" + P4Scanner.this.getRepositoryInfo().getRepositoryDescriptor() + "] Skipping label with # character: " + tag));
                            return;
                        }
                        long accessTime = P4Scanner.this.dao.getTagUpdateTime(tag);
                        if (accessTime == -1L || label.getAccessTime() > accessTime) {
                            changed[0] = true;
                            P4Scanner.this.dao.removeTag(tag);
                            P4Scanner.this.client.visitLabelFiles(tag, new P4Visitor.LabeledFileVisitor(){

                                public void visit(String label, P4FileSpec fileSpec) {
                                    try {
                                        Path path = P4Scanner.this.getRepositoryInfo().getLocalPath(fileSpec.getPath(), -1L);
                                        int revid = P4Scanner.this.dao.getRevIdByFileRev(path, fileSpec.getFileRev());
                                        P4Scanner.this.dao.addTag(revid, tag);
                                    }
                                    catch (DbException e2) {
                                        throw new P4Visitor.VisitorException(e2);
                                    }
                                }
                            });
                            label = P4Scanner.this.client.getLabel(label.getName());
                            P4Scanner.this.dao.setTagUpdateTime(label.getName(), label.getAccessTime());
                        }
                    }
                    catch (Exception e2) {
                        throw new P4Visitor.VisitorException(e2);
                    }
                }
            });
            this.getStatus().setMessage("Processed " + count[0] + " labels");
        }
        catch (P4Visitor.VisitorException e2) {
            if (e2.getCause() instanceof RepositoryClientException) {
                throw (RepositoryClientException)e2.getCause();
            }
            if (e2.getCause() instanceof DbException) {
                throw (DbException)e2.getCause();
            }
            throw new DbException(e2);
        }
        return changed[0];
    }

    @Override
    protected void setCreateOnDemand(boolean createOnDemand) {
        this.createOnDemand = createOnDemand;
    }

    @Override
    protected void createInitialImport(RevListCache revListCache, long startRevision) throws DbException {
        throw new RuntimeException("Initial import is not supported for Perforce repositories");
    }

    @Override
    protected void validateAccess() throws ConfigException {
    }

    @Override
    protected SortedIntSet getRevidsInChangeSetRange(long startRevision, long endRevision) throws DbException {
        return this.dao.getRevidsInChangeSetRange(startRevision, endRevision);
    }

    @Override
    protected SortedIntSet getPathRevids(SortedIntSet physicalPaths) throws DbException {
        SegmentedIntSet outdatedRevids = new SegmentedIntSet();
        int physicalPathId = physicalPaths.nextSetBit(0);
        while (physicalPathId >= 0) {
            this.dao.addPathRevIds(outdatedRevids, physicalPathId);
            physicalPathId = physicalPaths.nextSetBit(physicalPathId + 1);
        }
        return outdatedRevids;
    }

    @Override
    protected SortedIntSet getPhysicalPaths(long startRevision, long endRevision) throws DbException {
        SortedIntSet revids = this.dao.getRevidsInChangeSetRange(startRevision, endRevision);
        return this.dao.getPaths(revids);
    }

    @Override
    protected void indexRevisions(SortedIntSet revids) throws DbException {
        RepositoryCache cache = this.getCache();
        ArrayList<P4RevInfo> revisions = new ArrayList<P4RevInfo>();
        int count = 0;
        int total = revids.cardinality();
        int revid = revids.nextSetBit(0);
        while (revid >= 0 && !this.getStatus().isStopRequested()) {
            revisions.add(this.dao.load(revid));
            if (++count % 400 == 0) {
                this.getStatus().setMessage("Indexing revision metadata item " + count + " of " + total);
            }
            if (revisions.size() >= 400) {
                this.getIndexer().indexBatch(revisions);
                revisions.clear();
                cache.setScanProperty("LastMetadataRevid", revid);
                cache.commit();
                this.clearSetUpto(revids, revid);
            }
            revid = revids.nextSetBit(revid + 1);
        }
        this.getIndexer().indexBatch(revisions);
        revisions.clear();
        cache.setScanProperty("LastMetadataRevid", -1L);
        cache.commit();
        this.clearSetUpto(revids, revids.length() + 1);
    }

    @Override
    protected String getCacheVersion() {
        return "3";
    }

    @Override
    protected void indexUpdatedContent(SortedIntSet physicalPaths) throws DbException, IOException {
        RepositoryCache cache = this.getCache();
        int pathIndex = 0;
        int count = physicalPaths.cardinality();
        HashMap<P4FileSpec, Long> contentBlock = new HashMap<P4FileSpec, Long>();
        int contentBlockSize = 0;
        HashMap<P4FileSpec, P4RevInfo> revInfoMap = new HashMap<P4FileSpec, P4RevInfo>();
        int physicalPathId = physicalPaths.nextSetBit(0);
        while (physicalPathId >= 0 && !this.getStatus().isStopRequested()) {
            long csid;
            ++pathIndex;
            Path path = this.dao.getPath(physicalPathId);
            int revid = this.dao.getRevId(path, csid = this.dao.getLatestPathChange(path));
            P4RevInfo revision = this.dao.load(revid);
            if (revision == null || revision.isBinary() || revision.isDead()) {
                Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] " + "Not indexing contents of HEAD of " + path + " as file is binary or deleted"));
            } else if (revision.getFileType() != 1) {
                Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] " + "Not indexing contents of HEAD of " + path + " as this is not a file"));
            } else if (revision.getFileSize() >= 0x500000L) {
                Logs.APP_LOG.warn((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Not indexing contents of HEAD of " + path + " because its size (" + revision.getFileSize() + "B) is too large (limit is 5MB)"));
            } else {
                this.getStatus().setMessage("Indexing content: " + path + " (" + pathIndex + " of " + count + ")");
                String serverPath = this.getRepositoryInfo().getServerPath(revision.getPath(), csid);
                P4FileSpec fileSpec = new P4FileSpec(serverPath, revision.getFileRev());
                contentBlock.put(fileSpec, revision.getFileSize());
                contentBlockSize = (int)((long)contentBlockSize + revision.getFileSize());
                revInfoMap.put(fileSpec, revision);
                if (contentBlock.size() >= this.client.getMaxPrint() || contentBlockSize >= this.client.getMaxPrintBytes()) {
                    this.indexContentBlock(contentBlock, revInfoMap);
                    contentBlock.clear();
                    contentBlockSize = 0;
                    revInfoMap.clear();
                    cache.setScanProperty("LastContentRevid", physicalPathId);
                    cache.commit();
                    this.clearSetUpto(physicalPaths, physicalPathId);
                }
            }
            physicalPathId = physicalPaths.nextSetBit(physicalPathId + 1);
        }
        this.indexContentBlock(contentBlock, revInfoMap);
        cache.setScanProperty("LastContentRevid", -1L);
        cache.commit();
        this.clearSetUpto(physicalPaths, physicalPaths.length() + 1);
    }

    private void indexContentBlock(final Map<P4FileSpec, Long> contentMap, final Map<P4FileSpec, P4RevInfo> revInfoMap) {
        final HashSet processedFiles = new HashSet();
        final HashSet duplicateFiles = new HashSet();
        try {
            this.client.streamMultipleContent(contentMap.keySet(), new P4Visitor.ProcessOutputVisitor(){

                public void visit(P4Process p4Process, InputStream is) throws P4Visitor.VisitorException {
                    try {
                        P4InputDemuxer demuxer = new P4InputDemuxer(p4Process, is, contentMap, new P4InputDemuxer.Callback(){

                            public void processFile(P4FileSpec file, InputStream is) {
                                if (processedFiles.contains(file)) {
                                    duplicateFiles.add(file);
                                } else {
                                    try {
                                        processedFiles.add(file);
                                        BufferedReader in = new BufferedReader(new InputStreamReader(is));
                                        P4RevInfo revInfo = (P4RevInfo)revInfoMap.get(file);
                                        Charset encoding = P4Scanner.this.getCache().getTextEncoding(revInfo.getRevInfoKey());
                                        Logs.APP_LOG.debug((Object)("[" + P4Scanner.this.getRepositoryInfo().getRepositoryDescriptor() + "] Indexing streamed content of " + revInfo.getRevInfoKey()));
                                        P4Scanner.this.getIndexer().indexContent((FileRevision)revInfo, in, encoding);
                                    }
                                    catch (Exception e2) {
                                        Logs.APP_LOG.warn((Object)("[" + P4Scanner.this.getRepositoryInfo().getRepositoryDescriptor() + "] Error indexing " + file), (Throwable)e2);
                                    }
                                }
                            }
                        });
                        demuxer.process();
                    }
                    catch (P4ClientException e2) {
                        throw new P4Visitor.VisitorException(e2);
                    }
                    catch (IOException e3) {
                        throw new P4Visitor.VisitorException(e3);
                    }
                }
            });
            processedFiles.removeAll(duplicateFiles);
            revInfoMap.keySet().removeAll(processedFiles);
            if (!revInfoMap.isEmpty()) {
                this.indexContentFileByFile(revInfoMap);
            }
        }
        catch (P4ClientException e2) {
            Logs.APP_LOG.warn((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Problem streaming content for indexing"), (Throwable)e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexContentFileByFile(Map<P4FileSpec, P4RevInfo> revInfoMap) {
        for (Map.Entry<P4FileSpec, P4RevInfo> entry : revInfoMap.entrySet()) {
            File contentFile;
            block9: {
                contentFile = null;
                P4RevInfo revision = entry.getValue();
                try {
                    contentFile = File.createTempFile("fisheye", null, this.getRepositoryInfo().getRepoTempDir());
                    boolean exported = false;
                    try {
                        long csid = Long.parseLong(revision.getRevInfoKey().getRev());
                        String repoPath = this.getRepositoryInfo().getServerPath(revision.getPath(), csid);
                        exported = this.client.exportContent(repoPath, contentFile, revision.getP4ChangeSetId());
                    }
                    catch (RepositoryClientException e2) {
                        Logs.APP_LOG.warn((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Error exporting content for indexing"), (Throwable)e2);
                    }
                    if (!exported) {
                        Logs.APP_LOG.warn((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Skipping " + revision.getPath() + " as content is not available"));
                        break block9;
                    }
                    if (!contentFile.exists()) {
                        Logs.APP_LOG.error((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Not indexing contents of " + revision.getPath() + " because content was not exported"));
                        break block9;
                    }
                    Charset encoding = this.getCache().getTextEncoding(revision.getRevInfoKey());
                    Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Indexing content of " + revision.getRevInfoKey()));
                    this.getIndexer().indexContent((FileRevision)revision, contentFile, encoding);
                }
                catch (Throwable e3) {
                    try {
                        Logs.APP_LOG.warn((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Error indexing content for " + revision));
                    }
                    catch (Throwable throwable) {
                        IOHelper.deleteFile(contentFile);
                        throw throwable;
                    }
                    IOHelper.deleteFile(contentFile);
                    continue;
                }
            }
            IOHelper.deleteFile(contentFile);
        }
    }

    public void setCharset(Charset charset) {
        this.getP4Cache().setCharset(charset);
    }

    public void requestStop() {
        this.client.cancel();
    }
}

