/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce.search;

import com.cenqua.fisheye.cvsrep.search.query.P4FixesClause;
import com.cenqua.fisheye.cvsrep.search.query.P4FixesRegexClause;
import com.cenqua.fisheye.infinitydb.query3.RegexQuery3;
import com.cenqua.fisheye.infinitydb.query3.TermQuery3;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.P4Cache;
import com.cenqua.fisheye.perforce.db.P4Schema;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.search.QueryBuilder;
import java.io.IOException;
import java.util.regex.Pattern;

public class P4QueryBuilder
extends QueryBuilder {
    private P4Cache cache;

    public P4QueryBuilder(P4Cache cache) {
        super(cache.getMasterAnalyzer(), cache.isCaseSensitive());
        this.cache = cache;
    }

    public void visitP4FixesClause(P4FixesClause p4FixesClause) throws IOException {
        try {
            long jobId = this.cache.getJobId(p4FixesClause.getJobId());
            TermQuery3 t = new TermQuery3(P4Schema.I_JOBID_TO_REVID, jobId, null);
            this.setQuery(t);
        }
        catch (DbException e2) {
            Logs.APP_LOG.error((Object)("Unable to lookup job id for fixes clause: " + p4FixesClause));
        }
    }

    public void visitP4FixesRegexClause(P4FixesRegexClause p4FixesRegexClause) {
        Pattern match = p4FixesRegexClause.getMatch();
        this.setQuery(new RegexQuery3(P4Schema.E_NAMES, P4Schema.I_JOBID_TO_REVID, match));
    }
}

