/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.obfuscate.idbk4ui8v._Cu;

public class AncestorLink {
    public static final int DIRECT = 0;
    public static final int BRANCHPOINT = 1;
    public static final int COPY = 2;
    public static final int MOVE = 3;
    private final int revid;
    private final int type;

    public AncestorLink(int revid, int type) {
        this.revid = revid;
        this.type = type;
    }

    public int getRevid() {
        return this.revid;
    }

    public int getType() {
        return this.type;
    }

    public boolean isDirect() {
        return this.type == 0;
    }

    public boolean isBranchPoint() {
        return this.type == 1;
    }

    public boolean isCopy() {
        return this.type == 2;
    }

    public boolean isMove() {
        return this.type == 3;
    }

    public static AncestorLink fromCu(_Cu cu, int pl) {
        int arevid = (int)cu.longAt(pl);
        int type = (int)cu.longAt(cu.skipLong(pl));
        return new AncestorLink(arevid, type);
    }

    public String toString() {
        return "AncestorLink[" + this.revid + "," + this.type + "]";
    }
}

