/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.rep.AuthorBlameException;
import com.cenqua.fisheye.util.SumMap;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AuthorBlameLines {
    private LinkedList<BlameSpan> blame = new LinkedList();

    private AuthorBlameLines(LinkedList<BlameSpan> copiedBlame) {
        this.blame = copiedBlame;
    }

    public AuthorBlameLines() {
    }

    public void init(String name, int lines) {
        if (lines != 0) {
            this.blame.add(new BlameSpan(0, lines, name));
        }
    }

    public AuthorBlameLines getCopy() {
        LinkedList<BlameSpan> copiedBlame = new LinkedList<BlameSpan>();
        for (BlameSpan aBlame : this.blame) {
            copiedBlame.add(aBlame.getCopy());
        }
        return new AuthorBlameLines(copiedBlame);
    }

    public int size() {
        if (this.blame.size() == 0) {
            return 0;
        }
        return this.blame.getLast().length + this.blame.getLast().start;
    }

    public void removeBlame(int start, int length, SumMap<String> authorDiff) throws AuthorBlameException {
        if (length > 0) {
            if (start + length > this.size() || start < 0) {
                throw new AuthorBlameException("Error removing lines of blame: trying to remove " + length + " lines starting at line " + start + " but file is only " + this.size() + " lines long");
            }
            if (start < 0) {
                throw new AuthorBlameException("Error removing lines of blame: start index " + start + " is invalid");
            }
            int removed = 0;
            ListIterator<BlameSpan> i2 = this.blame.listIterator();
            while (i2.hasNext()) {
                BlameSpan span = (BlameSpan)i2.next();
                span.shiftIndex(-removed);
                if (removed >= length || start >= span.end) continue;
                i2.previous();
                i2.remove();
                int lengthLeft = length - removed;
                int removeLength = Math.min(span.end, start + lengthLeft) - Math.max(start, span.start);
                if (span.length - removeLength > 0) {
                    i2.add(new BlameSpan(span.start, span.length - removeLength, span.name));
                }
                removed += removeLength;
                authorDiff.addValue(span.name, -removeLength);
            }
        }
        this.checkConsistent();
    }

    public void addBlame(String author, int start, int length, SumMap<String> authorDiff) throws AuthorBlameException {
        if (length > 0) {
            if (start > this.size()) {
                throw new AuthorBlameException("Error adding lines of blame: trying to add starting at line " + start + " but the file is only " + this.size() + " lines");
            }
            if (start < 0) {
                throw new AuthorBlameException("Error adding lines of blame: invalid start line " + start);
            }
            boolean alreadyAdded = false;
            if (this.blame.size() == 0 || this.blame.getLast().start + this.blame.getLast().length == start) {
                this.blame.add(new BlameSpan(start, length, author));
            } else {
                ListIterator<BlameSpan> i2 = this.blame.listIterator();
                while (i2.hasNext()) {
                    BlameSpan span = (BlameSpan)i2.next();
                    if (alreadyAdded) {
                        span.shiftIndex(length);
                        continue;
                    }
                    if (start < span.start || start >= span.end) continue;
                    i2.previous();
                    if (author.equals(span.name) && start >= span.start && start < span.end) {
                        i2.remove();
                        i2.add(new BlameSpan(span.start, span.length + length, author));
                    } else if (span.start == start) {
                        i2.add(new BlameSpan(start, length, author));
                        span.shiftIndex(length);
                        i2.next();
                    } else {
                        i2.remove();
                        i2.add(new BlameSpan(span.start, start - span.start, span.name));
                        i2.add(new BlameSpan(start, length, author));
                        i2.add(new BlameSpan(start + length, span.length + span.start - start, span.name));
                    }
                    alreadyAdded = true;
                }
            }
            authorDiff.addValue(author, length);
        }
        this.checkConsistent();
    }

    private void checkConsistent() throws AuthorBlameException {
        int total = 0;
        for (BlameSpan span : this.blame) {
            if (span.start != total) {
                System.out.println("Error in author blame: " + this.blame);
                throw new AuthorBlameException("Error in author blame: " + this.blame);
            }
            if (span.length == 0) {
                System.out.println("Error in author blame: zero length: " + this.blame);
            }
            total += span.length;
        }
    }

    public String toString() {
        return this.blame.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BlameSpan
    implements Comparable<BlameSpan> {
        private int start;
        private int end;
        private final int length;
        private final String name;
        public static final Comparator<BlameSpan> COMP = new Comparator<BlameSpan>(){

            @Override
            public int compare(BlameSpan span1, BlameSpan span2) {
                return span1.start - span2.start;
            }
        };

        BlameSpan(int start, int length, String name) {
            this.start = start;
            this.length = length;
            this.name = name;
            this.end = start + length;
        }

        public void shiftIndex(int offset) {
            this.start += offset;
            this.end = this.start + this.length;
        }

        public String toString() {
            return this.start + "-" + this.end + ":" + this.name;
        }

        @Override
        public int compareTo(BlameSpan span) {
            return this.start - span.start;
        }

        public BlameSpan getCopy() {
            return new BlameSpan(this.start, this.length, this.name);
        }
    }
}

